/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.objectstorage.model.StorageTier;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.requests.HasContentLength;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class PutObjectRequest
extends BmcRequest<InputStream>
implements HasContentLength {
    private String namespaceName;
    private String bucketName;
    private String objectName;
    private Long contentLength;
    private InputStream putObjectBody;
    private String ifMatch;
    private String ifNoneMatch;
    private String opcClientRequestId;
    private String expect;
    private String contentMD5;
    private String contentType;
    private String contentLanguage;
    private String contentEncoding;
    private String contentDisposition;
    private String cacheControl;
    private String opcSseCustomerAlgorithm;
    private String opcSseCustomerKey;
    private String opcSseCustomerKeySha256;
    private String opcSseKmsKeyId;
    private StorageTier storageTier;
    private Map<String, String> opcMeta;

    @InternalSdk
    public InputStream getBody$() {
        return this.putObjectBody;
    }

    public boolean supportsExpect100Continue() {
        return true;
    }

    @ConstructorProperties(value={"namespaceName", "bucketName", "objectName", "contentLength", "putObjectBody", "ifMatch", "ifNoneMatch", "opcClientRequestId", "expect", "contentMD5", "contentType", "contentLanguage", "contentEncoding", "contentDisposition", "cacheControl", "opcSseCustomerAlgorithm", "opcSseCustomerKey", "opcSseCustomerKeySha256", "opcSseKmsKeyId", "storageTier", "opcMeta"})
    PutObjectRequest(String namespaceName, String bucketName, String objectName, Long contentLength, InputStream putObjectBody, String ifMatch, String ifNoneMatch, String opcClientRequestId, String expect, String contentMD5, String contentType, String contentLanguage, String contentEncoding, String contentDisposition, String cacheControl, String opcSseCustomerAlgorithm, String opcSseCustomerKey, String opcSseCustomerKeySha256, String opcSseKmsKeyId, StorageTier storageTier, Map<String, String> opcMeta) {
        this.namespaceName = namespaceName;
        this.bucketName = bucketName;
        this.objectName = objectName;
        this.contentLength = contentLength;
        this.putObjectBody = putObjectBody;
        this.ifMatch = ifMatch;
        this.ifNoneMatch = ifNoneMatch;
        this.opcClientRequestId = opcClientRequestId;
        this.expect = expect;
        this.contentMD5 = contentMD5;
        this.contentType = contentType;
        this.contentLanguage = contentLanguage;
        this.contentEncoding = contentEncoding;
        this.contentDisposition = contentDisposition;
        this.cacheControl = cacheControl;
        this.opcSseCustomerAlgorithm = opcSseCustomerAlgorithm;
        this.opcSseCustomerKey = opcSseCustomerKey;
        this.opcSseCustomerKeySha256 = opcSseCustomerKeySha256;
        this.opcSseKmsKeyId = opcSseKmsKeyId;
        this.storageTier = storageTier;
        this.opcMeta = opcMeta;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).bucketName(this.bucketName).objectName(this.objectName).contentLength(this.contentLength).putObjectBody(this.putObjectBody).ifMatch(this.ifMatch).ifNoneMatch(this.ifNoneMatch).opcClientRequestId(this.opcClientRequestId).expect(this.expect).contentMD5(this.contentMD5).contentType(this.contentType).contentLanguage(this.contentLanguage).contentEncoding(this.contentEncoding).contentDisposition(this.contentDisposition).cacheControl(this.cacheControl).opcSseCustomerAlgorithm(this.opcSseCustomerAlgorithm).opcSseCustomerKey(this.opcSseCustomerKey).opcSseCustomerKeySha256(this.opcSseCustomerKeySha256).opcSseKmsKeyId(this.opcSseKmsKeyId).storageTier(this.storageTier).opcMeta(this.opcMeta);
    }

    public String toString() {
        return "PutObjectRequest(super=" + super.toString() + ", namespaceName=" + this.getNamespaceName() + ", bucketName=" + this.getBucketName() + ", objectName=" + this.getObjectName() + ", contentLength=" + this.getContentLength() + ", putObjectBody=" + this.getPutObjectBody() + ", ifMatch=" + this.getIfMatch() + ", ifNoneMatch=" + this.getIfNoneMatch() + ", opcClientRequestId=" + this.getOpcClientRequestId() + ", expect=" + this.getExpect() + ", contentMD5=" + this.getContentMD5() + ", contentType=" + this.getContentType() + ", contentLanguage=" + this.getContentLanguage() + ", contentEncoding=" + this.getContentEncoding() + ", contentDisposition=" + this.getContentDisposition() + ", cacheControl=" + this.getCacheControl() + ", opcSseCustomerAlgorithm=" + this.getOpcSseCustomerAlgorithm() + ", opcSseCustomerKey=" + this.getOpcSseCustomerKey() + ", opcSseCustomerKeySha256=" + this.getOpcSseCustomerKeySha256() + ", opcSseKmsKeyId=" + this.getOpcSseKmsKeyId() + ", storageTier=" + (Object)((Object)this.getStorageTier()) + ", opcMeta=" + this.getOpcMeta() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PutObjectRequest)) {
            return false;
        }
        PutObjectRequest other = (PutObjectRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$contentLength = this.getContentLength();
        Long other$contentLength = other.getContentLength();
        if (this$contentLength == null ? other$contentLength != null : !((Object)this$contentLength).equals(other$contentLength)) {
            return false;
        }
        String this$namespaceName = this.getNamespaceName();
        String other$namespaceName = other.getNamespaceName();
        if (this$namespaceName == null ? other$namespaceName != null : !this$namespaceName.equals(other$namespaceName)) {
            return false;
        }
        String this$bucketName = this.getBucketName();
        String other$bucketName = other.getBucketName();
        if (this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName)) {
            return false;
        }
        String this$objectName = this.getObjectName();
        String other$objectName = other.getObjectName();
        if (this$objectName == null ? other$objectName != null : !this$objectName.equals(other$objectName)) {
            return false;
        }
        InputStream this$putObjectBody = this.getPutObjectBody();
        InputStream other$putObjectBody = other.getPutObjectBody();
        if (this$putObjectBody == null ? other$putObjectBody != null : !this$putObjectBody.equals(other$putObjectBody)) {
            return false;
        }
        String this$ifMatch = this.getIfMatch();
        String other$ifMatch = other.getIfMatch();
        if (this$ifMatch == null ? other$ifMatch != null : !this$ifMatch.equals(other$ifMatch)) {
            return false;
        }
        String this$ifNoneMatch = this.getIfNoneMatch();
        String other$ifNoneMatch = other.getIfNoneMatch();
        if (this$ifNoneMatch == null ? other$ifNoneMatch != null : !this$ifNoneMatch.equals(other$ifNoneMatch)) {
            return false;
        }
        String this$opcClientRequestId = this.getOpcClientRequestId();
        String other$opcClientRequestId = other.getOpcClientRequestId();
        if (this$opcClientRequestId == null ? other$opcClientRequestId != null : !this$opcClientRequestId.equals(other$opcClientRequestId)) {
            return false;
        }
        String this$expect = this.getExpect();
        String other$expect = other.getExpect();
        if (this$expect == null ? other$expect != null : !this$expect.equals(other$expect)) {
            return false;
        }
        String this$contentMD5 = this.getContentMD5();
        String other$contentMD5 = other.getContentMD5();
        if (this$contentMD5 == null ? other$contentMD5 != null : !this$contentMD5.equals(other$contentMD5)) {
            return false;
        }
        String this$contentType = this.getContentType();
        String other$contentType = other.getContentType();
        if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) {
            return false;
        }
        String this$contentLanguage = this.getContentLanguage();
        String other$contentLanguage = other.getContentLanguage();
        if (this$contentLanguage == null ? other$contentLanguage != null : !this$contentLanguage.equals(other$contentLanguage)) {
            return false;
        }
        String this$contentEncoding = this.getContentEncoding();
        String other$contentEncoding = other.getContentEncoding();
        if (this$contentEncoding == null ? other$contentEncoding != null : !this$contentEncoding.equals(other$contentEncoding)) {
            return false;
        }
        String this$contentDisposition = this.getContentDisposition();
        String other$contentDisposition = other.getContentDisposition();
        if (this$contentDisposition == null ? other$contentDisposition != null : !this$contentDisposition.equals(other$contentDisposition)) {
            return false;
        }
        String this$cacheControl = this.getCacheControl();
        String other$cacheControl = other.getCacheControl();
        if (this$cacheControl == null ? other$cacheControl != null : !this$cacheControl.equals(other$cacheControl)) {
            return false;
        }
        String this$opcSseCustomerAlgorithm = this.getOpcSseCustomerAlgorithm();
        String other$opcSseCustomerAlgorithm = other.getOpcSseCustomerAlgorithm();
        if (this$opcSseCustomerAlgorithm == null ? other$opcSseCustomerAlgorithm != null : !this$opcSseCustomerAlgorithm.equals(other$opcSseCustomerAlgorithm)) {
            return false;
        }
        String this$opcSseCustomerKey = this.getOpcSseCustomerKey();
        String other$opcSseCustomerKey = other.getOpcSseCustomerKey();
        if (this$opcSseCustomerKey == null ? other$opcSseCustomerKey != null : !this$opcSseCustomerKey.equals(other$opcSseCustomerKey)) {
            return false;
        }
        String this$opcSseCustomerKeySha256 = this.getOpcSseCustomerKeySha256();
        String other$opcSseCustomerKeySha256 = other.getOpcSseCustomerKeySha256();
        if (this$opcSseCustomerKeySha256 == null ? other$opcSseCustomerKeySha256 != null : !this$opcSseCustomerKeySha256.equals(other$opcSseCustomerKeySha256)) {
            return false;
        }
        String this$opcSseKmsKeyId = this.getOpcSseKmsKeyId();
        String other$opcSseKmsKeyId = other.getOpcSseKmsKeyId();
        if (this$opcSseKmsKeyId == null ? other$opcSseKmsKeyId != null : !this$opcSseKmsKeyId.equals(other$opcSseKmsKeyId)) {
            return false;
        }
        StorageTier this$storageTier = this.getStorageTier();
        StorageTier other$storageTier = other.getStorageTier();
        if (this$storageTier == null ? other$storageTier != null : !((Object)((Object)this$storageTier)).equals((Object)other$storageTier)) {
            return false;
        }
        Map<String, String> this$opcMeta = this.getOpcMeta();
        Map<String, String> other$opcMeta = other.getOpcMeta();
        return !(this$opcMeta == null ? other$opcMeta != null : !((Object)this$opcMeta).equals(other$opcMeta));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PutObjectRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $contentLength = this.getContentLength();
        result = result * 59 + ($contentLength == null ? 43 : ((Object)$contentLength).hashCode());
        String $namespaceName = this.getNamespaceName();
        result = result * 59 + ($namespaceName == null ? 43 : $namespaceName.hashCode());
        String $bucketName = this.getBucketName();
        result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
        String $objectName = this.getObjectName();
        result = result * 59 + ($objectName == null ? 43 : $objectName.hashCode());
        InputStream $putObjectBody = this.getPutObjectBody();
        result = result * 59 + ($putObjectBody == null ? 43 : $putObjectBody.hashCode());
        String $ifMatch = this.getIfMatch();
        result = result * 59 + ($ifMatch == null ? 43 : $ifMatch.hashCode());
        String $ifNoneMatch = this.getIfNoneMatch();
        result = result * 59 + ($ifNoneMatch == null ? 43 : $ifNoneMatch.hashCode());
        String $opcClientRequestId = this.getOpcClientRequestId();
        result = result * 59 + ($opcClientRequestId == null ? 43 : $opcClientRequestId.hashCode());
        String $expect = this.getExpect();
        result = result * 59 + ($expect == null ? 43 : $expect.hashCode());
        String $contentMD5 = this.getContentMD5();
        result = result * 59 + ($contentMD5 == null ? 43 : $contentMD5.hashCode());
        String $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
        String $contentLanguage = this.getContentLanguage();
        result = result * 59 + ($contentLanguage == null ? 43 : $contentLanguage.hashCode());
        String $contentEncoding = this.getContentEncoding();
        result = result * 59 + ($contentEncoding == null ? 43 : $contentEncoding.hashCode());
        String $contentDisposition = this.getContentDisposition();
        result = result * 59 + ($contentDisposition == null ? 43 : $contentDisposition.hashCode());
        String $cacheControl = this.getCacheControl();
        result = result * 59 + ($cacheControl == null ? 43 : $cacheControl.hashCode());
        String $opcSseCustomerAlgorithm = this.getOpcSseCustomerAlgorithm();
        result = result * 59 + ($opcSseCustomerAlgorithm == null ? 43 : $opcSseCustomerAlgorithm.hashCode());
        String $opcSseCustomerKey = this.getOpcSseCustomerKey();
        result = result * 59 + ($opcSseCustomerKey == null ? 43 : $opcSseCustomerKey.hashCode());
        String $opcSseCustomerKeySha256 = this.getOpcSseCustomerKeySha256();
        result = result * 59 + ($opcSseCustomerKeySha256 == null ? 43 : $opcSseCustomerKeySha256.hashCode());
        String $opcSseKmsKeyId = this.getOpcSseKmsKeyId();
        result = result * 59 + ($opcSseKmsKeyId == null ? 43 : $opcSseKmsKeyId.hashCode());
        StorageTier $storageTier = this.getStorageTier();
        result = result * 59 + ($storageTier == null ? 43 : ((Object)((Object)$storageTier)).hashCode());
        Map<String, String> $opcMeta = this.getOpcMeta();
        result = result * 59 + ($opcMeta == null ? 43 : ((Object)$opcMeta).hashCode());
        return result;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public InputStream getPutObjectBody() {
        return this.putObjectBody;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getIfNoneMatch() {
        return this.ifNoneMatch;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public String getExpect() {
        return this.expect;
    }

    public String getContentMD5() {
        return this.contentMD5;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public String getOpcSseCustomerAlgorithm() {
        return this.opcSseCustomerAlgorithm;
    }

    public String getOpcSseCustomerKey() {
        return this.opcSseCustomerKey;
    }

    public String getOpcSseCustomerKeySha256() {
        return this.opcSseCustomerKeySha256;
    }

    public String getOpcSseKmsKeyId() {
        return this.opcSseKmsKeyId;
    }

    public StorageTier getStorageTier() {
        return this.storageTier;
    }

    public Map<String, String> getOpcMeta() {
        return this.opcMeta;
    }

    public static class Builder
    implements BmcRequest.Builder<PutObjectRequest, InputStream> {
        private String namespaceName;
        private String bucketName;
        private String objectName;
        private Long contentLength;
        private InputStream putObjectBody;
        private String ifMatch;
        private String ifNoneMatch;
        private String opcClientRequestId;
        private String expect;
        private String contentMD5;
        private String contentType;
        private String contentLanguage;
        private String contentEncoding;
        private String contentDisposition;
        private String cacheControl;
        private String opcSseCustomerAlgorithm;
        private String opcSseCustomerKey;
        private String opcSseCustomerKeySha256;
        private String opcSseKmsKeyId;
        private StorageTier storageTier;
        private Map<String, String> opcMeta;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(PutObjectRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.bucketName(o.getBucketName());
            this.objectName(o.getObjectName());
            this.contentLength(o.getContentLength());
            this.putObjectBody(o.getPutObjectBody());
            this.ifMatch(o.getIfMatch());
            this.ifNoneMatch(o.getIfNoneMatch());
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.expect(o.getExpect());
            this.contentMD5(o.getContentMD5());
            this.contentType(o.getContentType());
            this.contentLanguage(o.getContentLanguage());
            this.contentEncoding(o.getContentEncoding());
            this.contentDisposition(o.getContentDisposition());
            this.cacheControl(o.getCacheControl());
            this.opcSseCustomerAlgorithm(o.getOpcSseCustomerAlgorithm());
            this.opcSseCustomerKey(o.getOpcSseCustomerKey());
            this.opcSseCustomerKeySha256(o.getOpcSseCustomerKeySha256());
            this.opcSseKmsKeyId(o.getOpcSseKmsKeyId());
            this.storageTier(o.getStorageTier());
            this.opcMeta(o.getOpcMeta());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public PutObjectRequest build() {
            PutObjectRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(InputStream body) {
            this.putObjectBody(body);
            return this;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder objectName(String objectName) {
            this.objectName = objectName;
            return this;
        }

        public Builder contentLength(Long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        public Builder putObjectBody(InputStream putObjectBody) {
            this.putObjectBody = putObjectBody;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder ifNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder expect(String expect) {
            this.expect = expect;
            return this;
        }

        public Builder contentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder contentLanguage(String contentLanguage) {
            this.contentLanguage = contentLanguage;
            return this;
        }

        public Builder contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public Builder contentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
            return this;
        }

        public Builder cacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
            return this;
        }

        public Builder opcSseCustomerAlgorithm(String opcSseCustomerAlgorithm) {
            this.opcSseCustomerAlgorithm = opcSseCustomerAlgorithm;
            return this;
        }

        public Builder opcSseCustomerKey(String opcSseCustomerKey) {
            this.opcSseCustomerKey = opcSseCustomerKey;
            return this;
        }

        public Builder opcSseCustomerKeySha256(String opcSseCustomerKeySha256) {
            this.opcSseCustomerKeySha256 = opcSseCustomerKeySha256;
            return this;
        }

        public Builder opcSseKmsKeyId(String opcSseKmsKeyId) {
            this.opcSseKmsKeyId = opcSseKmsKeyId;
            return this;
        }

        public Builder storageTier(StorageTier storageTier) {
            this.storageTier = storageTier;
            return this;
        }

        public Builder opcMeta(Map<String, String> opcMeta) {
            this.opcMeta = opcMeta;
            return this;
        }

        public PutObjectRequest buildWithoutInvocationCallback() {
            return new PutObjectRequest(this.namespaceName, this.bucketName, this.objectName, this.contentLength, this.putObjectBody, this.ifMatch, this.ifNoneMatch, this.opcClientRequestId, this.expect, this.contentMD5, this.contentType, this.contentLanguage, this.contentEncoding, this.contentDisposition, this.cacheControl, this.opcSseCustomerAlgorithm, this.opcSseCustomerKey, this.opcSseCustomerKeySha256, this.opcSseKmsKeyId, this.storageTier, this.opcMeta);
        }

        public String toString() {
            return "PutObjectRequest.Builder(namespaceName=" + this.namespaceName + ", bucketName=" + this.bucketName + ", objectName=" + this.objectName + ", contentLength=" + this.contentLength + ", putObjectBody=" + this.putObjectBody + ", ifMatch=" + this.ifMatch + ", ifNoneMatch=" + this.ifNoneMatch + ", opcClientRequestId=" + this.opcClientRequestId + ", expect=" + this.expect + ", contentMD5=" + this.contentMD5 + ", contentType=" + this.contentType + ", contentLanguage=" + this.contentLanguage + ", contentEncoding=" + this.contentEncoding + ", contentDisposition=" + this.contentDisposition + ", cacheControl=" + this.cacheControl + ", opcSseCustomerAlgorithm=" + this.opcSseCustomerAlgorithm + ", opcSseCustomerKey=" + this.opcSseCustomerKey + ", opcSseCustomerKeySha256=" + this.opcSseCustomerKeySha256 + ", opcSseKmsKeyId=" + this.opcSseKmsKeyId + ", storageTier=" + (Object)((Object)this.storageTier) + ", opcMeta=" + this.opcMeta + ")";
        }
    }
}

