/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListBucketsRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private String compartmentId;
    private Integer limit;
    private String page;
    private List<Fields> fields;
    private String opcClientRequestId;

    @ConstructorProperties(value={"namespaceName", "compartmentId", "limit", "page", "fields", "opcClientRequestId"})
    ListBucketsRequest(String namespaceName, String compartmentId, Integer limit, String page, List<Fields> fields, String opcClientRequestId) {
        this.namespaceName = namespaceName;
        this.compartmentId = compartmentId;
        this.limit = limit;
        this.page = page;
        this.fields = fields;
        this.opcClientRequestId = opcClientRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).compartmentId(this.compartmentId).limit(this.limit).page(this.page).fields(this.fields).opcClientRequestId(this.opcClientRequestId);
    }

    public String toString() {
        return "ListBucketsRequest(super=" + super.toString() + ", namespaceName=" + this.getNamespaceName() + ", compartmentId=" + this.getCompartmentId() + ", limit=" + this.getLimit() + ", page=" + this.getPage() + ", fields=" + this.getFields() + ", opcClientRequestId=" + this.getOpcClientRequestId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListBucketsRequest)) {
            return false;
        }
        ListBucketsRequest other = (ListBucketsRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        String this$namespaceName = this.getNamespaceName();
        String other$namespaceName = other.getNamespaceName();
        if (this$namespaceName == null ? other$namespaceName != null : !this$namespaceName.equals(other$namespaceName)) {
            return false;
        }
        String this$compartmentId = this.getCompartmentId();
        String other$compartmentId = other.getCompartmentId();
        if (this$compartmentId == null ? other$compartmentId != null : !this$compartmentId.equals(other$compartmentId)) {
            return false;
        }
        String this$page = this.getPage();
        String other$page = other.getPage();
        if (this$page == null ? other$page != null : !this$page.equals(other$page)) {
            return false;
        }
        List<Fields> this$fields = this.getFields();
        List<Fields> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        String this$opcClientRequestId = this.getOpcClientRequestId();
        String other$opcClientRequestId = other.getOpcClientRequestId();
        return !(this$opcClientRequestId == null ? other$opcClientRequestId != null : !this$opcClientRequestId.equals(other$opcClientRequestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListBucketsRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        String $namespaceName = this.getNamespaceName();
        result = result * 59 + ($namespaceName == null ? 43 : $namespaceName.hashCode());
        String $compartmentId = this.getCompartmentId();
        result = result * 59 + ($compartmentId == null ? 43 : $compartmentId.hashCode());
        String $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        List<Fields> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        String $opcClientRequestId = this.getOpcClientRequestId();
        result = result * 59 + ($opcClientRequestId == null ? 43 : $opcClientRequestId.hashCode());
        return result;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public List<Fields> getFields() {
        return this.fields;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListBucketsRequest, Void> {
        private String namespaceName;
        private String compartmentId;
        private Integer limit;
        private String page;
        private String opcClientRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private List<Fields> fields = null;

        public Builder fields(List<Fields> fields) {
            this.fields = fields;
            return this;
        }

        public Builder fields(Fields singularValue) {
            return this.fields(Arrays.asList(singularValue));
        }

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListBucketsRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.compartmentId(o.getCompartmentId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.fields(o.getFields());
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListBucketsRequest build() {
            ListBucketsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public ListBucketsRequest buildWithoutInvocationCallback() {
            return new ListBucketsRequest(this.namespaceName, this.compartmentId, this.limit, this.page, this.fields, this.opcClientRequestId);
        }

        public String toString() {
            return "ListBucketsRequest.Builder(namespaceName=" + this.namespaceName + ", compartmentId=" + this.compartmentId + ", limit=" + this.limit + ", page=" + this.page + ", fields=" + this.fields + ", opcClientRequestId=" + this.opcClientRequestId + ")";
        }
    }

    public static enum Fields {
        Tags("tags");

        private final String value;
        private static Map<String, Fields> map;

        private Fields(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Fields create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Fields: " + key);
        }

        static {
            map = new HashMap<String, Fields>();
            for (Fields v : Fields.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

