/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.circuitbreaker.JaxRsCircuitBreaker;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ApacheUtils;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.DefaultConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.io.internal.KeepOpenInputStream;
import com.oracle.bmc.model.BmcException;
import com.oracle.bmc.objectstorage.ObjectStorage;
import com.oracle.bmc.objectstorage.ObjectStoragePaginators;
import com.oracle.bmc.objectstorage.ObjectStorageWaiters;
import com.oracle.bmc.objectstorage.internal.http.AbortMultipartUploadConverter;
import com.oracle.bmc.objectstorage.internal.http.CancelWorkRequestConverter;
import com.oracle.bmc.objectstorage.internal.http.CommitMultipartUploadConverter;
import com.oracle.bmc.objectstorage.internal.http.CopyObjectConverter;
import com.oracle.bmc.objectstorage.internal.http.CreateBucketConverter;
import com.oracle.bmc.objectstorage.internal.http.CreateMultipartUploadConverter;
import com.oracle.bmc.objectstorage.internal.http.CreatePreauthenticatedRequestConverter;
import com.oracle.bmc.objectstorage.internal.http.CreateReplicationPolicyConverter;
import com.oracle.bmc.objectstorage.internal.http.CreateRetentionRuleConverter;
import com.oracle.bmc.objectstorage.internal.http.DeleteBucketConverter;
import com.oracle.bmc.objectstorage.internal.http.DeleteObjectConverter;
import com.oracle.bmc.objectstorage.internal.http.DeleteObjectLifecyclePolicyConverter;
import com.oracle.bmc.objectstorage.internal.http.DeletePreauthenticatedRequestConverter;
import com.oracle.bmc.objectstorage.internal.http.DeleteReplicationPolicyConverter;
import com.oracle.bmc.objectstorage.internal.http.DeleteRetentionRuleConverter;
import com.oracle.bmc.objectstorage.internal.http.GetBucketConverter;
import com.oracle.bmc.objectstorage.internal.http.GetNamespaceConverter;
import com.oracle.bmc.objectstorage.internal.http.GetNamespaceMetadataConverter;
import com.oracle.bmc.objectstorage.internal.http.GetObjectConverter;
import com.oracle.bmc.objectstorage.internal.http.GetObjectLifecyclePolicyConverter;
import com.oracle.bmc.objectstorage.internal.http.GetPreauthenticatedRequestConverter;
import com.oracle.bmc.objectstorage.internal.http.GetReplicationPolicyConverter;
import com.oracle.bmc.objectstorage.internal.http.GetRetentionRuleConverter;
import com.oracle.bmc.objectstorage.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.objectstorage.internal.http.HeadBucketConverter;
import com.oracle.bmc.objectstorage.internal.http.HeadObjectConverter;
import com.oracle.bmc.objectstorage.internal.http.ListBucketsConverter;
import com.oracle.bmc.objectstorage.internal.http.ListMultipartUploadPartsConverter;
import com.oracle.bmc.objectstorage.internal.http.ListMultipartUploadsConverter;
import com.oracle.bmc.objectstorage.internal.http.ListObjectVersionsConverter;
import com.oracle.bmc.objectstorage.internal.http.ListObjectsConverter;
import com.oracle.bmc.objectstorage.internal.http.ListPreauthenticatedRequestsConverter;
import com.oracle.bmc.objectstorage.internal.http.ListReplicationPoliciesConverter;
import com.oracle.bmc.objectstorage.internal.http.ListReplicationSourcesConverter;
import com.oracle.bmc.objectstorage.internal.http.ListRetentionRulesConverter;
import com.oracle.bmc.objectstorage.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.objectstorage.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.objectstorage.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.objectstorage.internal.http.MakeBucketWritableConverter;
import com.oracle.bmc.objectstorage.internal.http.PutObjectConverter;
import com.oracle.bmc.objectstorage.internal.http.PutObjectLifecyclePolicyConverter;
import com.oracle.bmc.objectstorage.internal.http.ReencryptBucketConverter;
import com.oracle.bmc.objectstorage.internal.http.ReencryptObjectConverter;
import com.oracle.bmc.objectstorage.internal.http.RenameObjectConverter;
import com.oracle.bmc.objectstorage.internal.http.RestoreObjectsConverter;
import com.oracle.bmc.objectstorage.internal.http.UpdateBucketConverter;
import com.oracle.bmc.objectstorage.internal.http.UpdateNamespaceMetadataConverter;
import com.oracle.bmc.objectstorage.internal.http.UpdateObjectStorageTierConverter;
import com.oracle.bmc.objectstorage.internal.http.UpdateRetentionRuleConverter;
import com.oracle.bmc.objectstorage.internal.http.UploadPartConverter;
import com.oracle.bmc.objectstorage.requests.AbortMultipartUploadRequest;
import com.oracle.bmc.objectstorage.requests.CancelWorkRequestRequest;
import com.oracle.bmc.objectstorage.requests.CommitMultipartUploadRequest;
import com.oracle.bmc.objectstorage.requests.CopyObjectRequest;
import com.oracle.bmc.objectstorage.requests.CreateBucketRequest;
import com.oracle.bmc.objectstorage.requests.CreateMultipartUploadRequest;
import com.oracle.bmc.objectstorage.requests.CreatePreauthenticatedRequestRequest;
import com.oracle.bmc.objectstorage.requests.CreateReplicationPolicyRequest;
import com.oracle.bmc.objectstorage.requests.CreateRetentionRuleRequest;
import com.oracle.bmc.objectstorage.requests.DeleteBucketRequest;
import com.oracle.bmc.objectstorage.requests.DeleteObjectLifecyclePolicyRequest;
import com.oracle.bmc.objectstorage.requests.DeleteObjectRequest;
import com.oracle.bmc.objectstorage.requests.DeletePreauthenticatedRequestRequest;
import com.oracle.bmc.objectstorage.requests.DeleteReplicationPolicyRequest;
import com.oracle.bmc.objectstorage.requests.DeleteRetentionRuleRequest;
import com.oracle.bmc.objectstorage.requests.GetBucketRequest;
import com.oracle.bmc.objectstorage.requests.GetNamespaceMetadataRequest;
import com.oracle.bmc.objectstorage.requests.GetNamespaceRequest;
import com.oracle.bmc.objectstorage.requests.GetObjectLifecyclePolicyRequest;
import com.oracle.bmc.objectstorage.requests.GetObjectRequest;
import com.oracle.bmc.objectstorage.requests.GetPreauthenticatedRequestRequest;
import com.oracle.bmc.objectstorage.requests.GetReplicationPolicyRequest;
import com.oracle.bmc.objectstorage.requests.GetRetentionRuleRequest;
import com.oracle.bmc.objectstorage.requests.GetWorkRequestRequest;
import com.oracle.bmc.objectstorage.requests.HeadBucketRequest;
import com.oracle.bmc.objectstorage.requests.HeadObjectRequest;
import com.oracle.bmc.objectstorage.requests.ListBucketsRequest;
import com.oracle.bmc.objectstorage.requests.ListMultipartUploadPartsRequest;
import com.oracle.bmc.objectstorage.requests.ListMultipartUploadsRequest;
import com.oracle.bmc.objectstorage.requests.ListObjectVersionsRequest;
import com.oracle.bmc.objectstorage.requests.ListObjectsRequest;
import com.oracle.bmc.objectstorage.requests.ListPreauthenticatedRequestsRequest;
import com.oracle.bmc.objectstorage.requests.ListReplicationPoliciesRequest;
import com.oracle.bmc.objectstorage.requests.ListReplicationSourcesRequest;
import com.oracle.bmc.objectstorage.requests.ListRetentionRulesRequest;
import com.oracle.bmc.objectstorage.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.objectstorage.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.objectstorage.requests.ListWorkRequestsRequest;
import com.oracle.bmc.objectstorage.requests.MakeBucketWritableRequest;
import com.oracle.bmc.objectstorage.requests.PutObjectLifecyclePolicyRequest;
import com.oracle.bmc.objectstorage.requests.PutObjectRequest;
import com.oracle.bmc.objectstorage.requests.ReencryptBucketRequest;
import com.oracle.bmc.objectstorage.requests.ReencryptObjectRequest;
import com.oracle.bmc.objectstorage.requests.RenameObjectRequest;
import com.oracle.bmc.objectstorage.requests.RestoreObjectsRequest;
import com.oracle.bmc.objectstorage.requests.UpdateBucketRequest;
import com.oracle.bmc.objectstorage.requests.UpdateNamespaceMetadataRequest;
import com.oracle.bmc.objectstorage.requests.UpdateObjectStorageTierRequest;
import com.oracle.bmc.objectstorage.requests.UpdateRetentionRuleRequest;
import com.oracle.bmc.objectstorage.requests.UploadPartRequest;
import com.oracle.bmc.objectstorage.responses.AbortMultipartUploadResponse;
import com.oracle.bmc.objectstorage.responses.CancelWorkRequestResponse;
import com.oracle.bmc.objectstorage.responses.CommitMultipartUploadResponse;
import com.oracle.bmc.objectstorage.responses.CopyObjectResponse;
import com.oracle.bmc.objectstorage.responses.CreateBucketResponse;
import com.oracle.bmc.objectstorage.responses.CreateMultipartUploadResponse;
import com.oracle.bmc.objectstorage.responses.CreatePreauthenticatedRequestResponse;
import com.oracle.bmc.objectstorage.responses.CreateReplicationPolicyResponse;
import com.oracle.bmc.objectstorage.responses.CreateRetentionRuleResponse;
import com.oracle.bmc.objectstorage.responses.DeleteBucketResponse;
import com.oracle.bmc.objectstorage.responses.DeleteObjectLifecyclePolicyResponse;
import com.oracle.bmc.objectstorage.responses.DeleteObjectResponse;
import com.oracle.bmc.objectstorage.responses.DeletePreauthenticatedRequestResponse;
import com.oracle.bmc.objectstorage.responses.DeleteReplicationPolicyResponse;
import com.oracle.bmc.objectstorage.responses.DeleteRetentionRuleResponse;
import com.oracle.bmc.objectstorage.responses.GetBucketResponse;
import com.oracle.bmc.objectstorage.responses.GetNamespaceMetadataResponse;
import com.oracle.bmc.objectstorage.responses.GetNamespaceResponse;
import com.oracle.bmc.objectstorage.responses.GetObjectLifecyclePolicyResponse;
import com.oracle.bmc.objectstorage.responses.GetObjectResponse;
import com.oracle.bmc.objectstorage.responses.GetPreauthenticatedRequestResponse;
import com.oracle.bmc.objectstorage.responses.GetReplicationPolicyResponse;
import com.oracle.bmc.objectstorage.responses.GetRetentionRuleResponse;
import com.oracle.bmc.objectstorage.responses.GetWorkRequestResponse;
import com.oracle.bmc.objectstorage.responses.HeadBucketResponse;
import com.oracle.bmc.objectstorage.responses.HeadObjectResponse;
import com.oracle.bmc.objectstorage.responses.ListBucketsResponse;
import com.oracle.bmc.objectstorage.responses.ListMultipartUploadPartsResponse;
import com.oracle.bmc.objectstorage.responses.ListMultipartUploadsResponse;
import com.oracle.bmc.objectstorage.responses.ListObjectVersionsResponse;
import com.oracle.bmc.objectstorage.responses.ListObjectsResponse;
import com.oracle.bmc.objectstorage.responses.ListPreauthenticatedRequestsResponse;
import com.oracle.bmc.objectstorage.responses.ListReplicationPoliciesResponse;
import com.oracle.bmc.objectstorage.responses.ListReplicationSourcesResponse;
import com.oracle.bmc.objectstorage.responses.ListRetentionRulesResponse;
import com.oracle.bmc.objectstorage.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.objectstorage.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.objectstorage.responses.ListWorkRequestsResponse;
import com.oracle.bmc.objectstorage.responses.MakeBucketWritableResponse;
import com.oracle.bmc.objectstorage.responses.PutObjectLifecyclePolicyResponse;
import com.oracle.bmc.objectstorage.responses.PutObjectResponse;
import com.oracle.bmc.objectstorage.responses.ReencryptBucketResponse;
import com.oracle.bmc.objectstorage.responses.ReencryptObjectResponse;
import com.oracle.bmc.objectstorage.responses.RenameObjectResponse;
import com.oracle.bmc.objectstorage.responses.RestoreObjectsResponse;
import com.oracle.bmc.objectstorage.responses.UpdateBucketResponse;
import com.oracle.bmc.objectstorage.responses.UpdateNamespaceMetadataResponse;
import com.oracle.bmc.objectstorage.responses.UpdateObjectStorageTierResponse;
import com.oracle.bmc.objectstorage.responses.UpdateRetentionRuleResponse;
import com.oracle.bmc.objectstorage.responses.UploadPartResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import com.oracle.bmc.util.CircuitBreakerUtils;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.glassfish.jersey.apache.connector.ApacheConnectionClosingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectStorageClient
implements ObjectStorage {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectStorageClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("OBJECTSTORAGE").serviceEndpointPrefix("objectstorage").serviceEndpointTemplate("https://objectstorage.{region}.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final ObjectStorageWaiters waiters;
    private final ObjectStoragePaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;
    private final ApacheConnectionClosingStrategy apacheConnectionClosingStrategy;

    public ObjectStorageClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public ObjectStorageClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public ObjectStorageClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public ObjectStorageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public ObjectStorageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public ObjectStorageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public ObjectStorageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public ObjectStorageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, executorService, RestClientFactoryBuilder.builder());
    }

    protected ObjectStorageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.defaultConfigurator((ClientConfigurator)new DefaultConfigurator.NonBuffering()).clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        boolean isNonBufferingApacheClient = ApacheUtils.isNonBufferingClientConfigurator((ClientConfigurator)restClientFactory.getClientConfigurator());
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        this.apacheConnectionClosingStrategy = ApacheUtils.getApacheConnectionClosingStrategy((ClientConfigurator)restClientFactory.getClientConfigurator());
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        JaxRsCircuitBreaker circuitBreaker = CircuitBreakerUtils.getUserDefinedCircuitBreaker((ClientConfiguration)configuration);
        if (circuitBreaker == null) {
            circuitBreaker = CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER;
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse, isNonBufferingApacheClient, circuitBreaker);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ObjectStorage-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new ObjectStorageWaiters(executorService, this);
        this.paginators = new ObjectStoragePaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public AbortMultipartUploadResponse abortMultipartUpload(AbortMultipartUploadRequest request) {
        LOG.trace("Called abortMultipartUpload");
        AbortMultipartUploadRequest interceptedRequest = AbortMultipartUploadConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AbortMultipartUploadConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, AbortMultipartUploadResponse> transformer = AbortMultipartUploadConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (AbortMultipartUploadResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (AbortMultipartUploadResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (AbortMultipartUploadResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public CancelWorkRequestResponse cancelWorkRequest(CancelWorkRequestRequest request) {
        LOG.trace("Called cancelWorkRequest");
        CancelWorkRequestRequest interceptedRequest = CancelWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CancelWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CancelWorkRequestResponse> transformer = CancelWorkRequestConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (CancelWorkRequestResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CancelWorkRequestResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (CancelWorkRequestResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public CommitMultipartUploadResponse commitMultipartUpload(CommitMultipartUploadRequest request) {
        LOG.trace("Called commitMultipartUpload");
        CommitMultipartUploadRequest interceptedRequest = CommitMultipartUploadConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CommitMultipartUploadConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CommitMultipartUploadResponse> transformer = CommitMultipartUploadConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (CommitMultipartUploadResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CommitMultipartUploadResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCommitMultipartUploadDetails(), (BmcRequest)retriedRequest);
                return (CommitMultipartUploadResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public CopyObjectResponse copyObject(CopyObjectRequest request) {
        LOG.trace("Called copyObject");
        CopyObjectRequest interceptedRequest = CopyObjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CopyObjectConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CopyObjectResponse> transformer = CopyObjectConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (CopyObjectResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CopyObjectResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCopyObjectDetails(), (BmcRequest)retriedRequest);
                return (CopyObjectResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public CreateBucketResponse createBucket(CreateBucketRequest request) {
        LOG.trace("Called createBucket");
        CreateBucketRequest interceptedRequest = CreateBucketConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateBucketConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateBucketResponse> transformer = CreateBucketConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (CreateBucketResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateBucketResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateBucketDetails(), (BmcRequest)retriedRequest);
                return (CreateBucketResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public CreateMultipartUploadResponse createMultipartUpload(CreateMultipartUploadRequest request) {
        LOG.trace("Called createMultipartUpload");
        CreateMultipartUploadRequest interceptedRequest = CreateMultipartUploadConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateMultipartUploadConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateMultipartUploadResponse> transformer = CreateMultipartUploadConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (CreateMultipartUploadResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateMultipartUploadResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateMultipartUploadDetails(), (BmcRequest)retriedRequest);
                return (CreateMultipartUploadResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public CreatePreauthenticatedRequestResponse createPreauthenticatedRequest(CreatePreauthenticatedRequestRequest request) {
        LOG.trace("Called createPreauthenticatedRequest");
        CreatePreauthenticatedRequestRequest interceptedRequest = CreatePreauthenticatedRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreatePreauthenticatedRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreatePreauthenticatedRequestResponse> transformer = CreatePreauthenticatedRequestConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (CreatePreauthenticatedRequestResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreatePreauthenticatedRequestResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreatePreauthenticatedRequestDetails(), (BmcRequest)retriedRequest);
                return (CreatePreauthenticatedRequestResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public CreateReplicationPolicyResponse createReplicationPolicy(CreateReplicationPolicyRequest request) {
        LOG.trace("Called createReplicationPolicy");
        CreateReplicationPolicyRequest interceptedRequest = CreateReplicationPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateReplicationPolicyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateReplicationPolicyResponse> transformer = CreateReplicationPolicyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (CreateReplicationPolicyResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateReplicationPolicyResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateReplicationPolicyDetails(), (BmcRequest)retriedRequest);
                return (CreateReplicationPolicyResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public CreateRetentionRuleResponse createRetentionRule(CreateRetentionRuleRequest request) {
        LOG.trace("Called createRetentionRule");
        CreateRetentionRuleRequest interceptedRequest = CreateRetentionRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateRetentionRuleConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateRetentionRuleResponse> transformer = CreateRetentionRuleConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (CreateRetentionRuleResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateRetentionRuleResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateRetentionRuleDetails(), (BmcRequest)retriedRequest);
                return (CreateRetentionRuleResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public DeleteBucketResponse deleteBucket(DeleteBucketRequest request) {
        LOG.trace("Called deleteBucket");
        DeleteBucketRequest interceptedRequest = DeleteBucketConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteBucketConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteBucketResponse> transformer = DeleteBucketConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (DeleteBucketResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteBucketResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteBucketResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public DeleteObjectResponse deleteObject(DeleteObjectRequest request) {
        LOG.trace("Called deleteObject");
        DeleteObjectRequest interceptedRequest = DeleteObjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteObjectConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteObjectResponse> transformer = DeleteObjectConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (DeleteObjectResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteObjectResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteObjectResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public DeleteObjectLifecyclePolicyResponse deleteObjectLifecyclePolicy(DeleteObjectLifecyclePolicyRequest request) {
        LOG.trace("Called deleteObjectLifecyclePolicy");
        DeleteObjectLifecyclePolicyRequest interceptedRequest = DeleteObjectLifecyclePolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteObjectLifecyclePolicyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteObjectLifecyclePolicyResponse> transformer = DeleteObjectLifecyclePolicyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (DeleteObjectLifecyclePolicyResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteObjectLifecyclePolicyResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteObjectLifecyclePolicyResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public DeletePreauthenticatedRequestResponse deletePreauthenticatedRequest(DeletePreauthenticatedRequestRequest request) {
        LOG.trace("Called deletePreauthenticatedRequest");
        DeletePreauthenticatedRequestRequest interceptedRequest = DeletePreauthenticatedRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeletePreauthenticatedRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeletePreauthenticatedRequestResponse> transformer = DeletePreauthenticatedRequestConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (DeletePreauthenticatedRequestResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeletePreauthenticatedRequestResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeletePreauthenticatedRequestResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public DeleteReplicationPolicyResponse deleteReplicationPolicy(DeleteReplicationPolicyRequest request) {
        LOG.trace("Called deleteReplicationPolicy");
        DeleteReplicationPolicyRequest interceptedRequest = DeleteReplicationPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteReplicationPolicyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteReplicationPolicyResponse> transformer = DeleteReplicationPolicyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (DeleteReplicationPolicyResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteReplicationPolicyResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteReplicationPolicyResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public DeleteRetentionRuleResponse deleteRetentionRule(DeleteRetentionRuleRequest request) {
        LOG.trace("Called deleteRetentionRule");
        DeleteRetentionRuleRequest interceptedRequest = DeleteRetentionRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteRetentionRuleConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteRetentionRuleResponse> transformer = DeleteRetentionRuleConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (DeleteRetentionRuleResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteRetentionRuleResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteRetentionRuleResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetBucketResponse getBucket(GetBucketRequest request) {
        LOG.trace("Called getBucket");
        GetBucketRequest interceptedRequest = GetBucketConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetBucketConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetBucketResponse> transformer = GetBucketConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (GetBucketResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetBucketResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetBucketResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetNamespaceResponse getNamespace(GetNamespaceRequest request) {
        LOG.trace("Called getNamespace");
        GetNamespaceRequest interceptedRequest = GetNamespaceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetNamespaceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetNamespaceResponse> transformer = GetNamespaceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (GetNamespaceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetNamespaceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetNamespaceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetNamespaceMetadataResponse getNamespaceMetadata(GetNamespaceMetadataRequest request) {
        LOG.trace("Called getNamespaceMetadata");
        GetNamespaceMetadataRequest interceptedRequest = GetNamespaceMetadataConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetNamespaceMetadataConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetNamespaceMetadataResponse> transformer = GetNamespaceMetadataConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (GetNamespaceMetadataResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetNamespaceMetadataResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetNamespaceMetadataResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetObjectResponse getObject(GetObjectRequest request) {
        LOG.trace("Called getObject");
        if (ApacheUtils.isExtraStreamLogsEnabled()) {
            LOG.warn("getObject returns a stream, please make sure to close the stream to avoid any indefinite hangs");
            if (this.apacheConnectionClosingStrategy != null) {
                LOG.warn("ApacheConnectionClosingStrategy set to {}. For large streams with partial reads of stream, please use ImmediateClosingStrategy. For small streams with partial reads of stream, please use GracefulClosingStrategy. More info in ApacheConnectorProperties", (Object)this.apacheConnectionClosingStrategy);
            }
        }
        GetObjectRequest interceptedRequest = GetObjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetObjectConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetObjectResponse> transformer = GetObjectConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (GetObjectResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetObjectResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetObjectResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetObjectLifecyclePolicyResponse getObjectLifecyclePolicy(GetObjectLifecyclePolicyRequest request) {
        LOG.trace("Called getObjectLifecyclePolicy");
        GetObjectLifecyclePolicyRequest interceptedRequest = GetObjectLifecyclePolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetObjectLifecyclePolicyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetObjectLifecyclePolicyResponse> transformer = GetObjectLifecyclePolicyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (GetObjectLifecyclePolicyResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetObjectLifecyclePolicyResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetObjectLifecyclePolicyResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetPreauthenticatedRequestResponse getPreauthenticatedRequest(GetPreauthenticatedRequestRequest request) {
        LOG.trace("Called getPreauthenticatedRequest");
        GetPreauthenticatedRequestRequest interceptedRequest = GetPreauthenticatedRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetPreauthenticatedRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetPreauthenticatedRequestResponse> transformer = GetPreauthenticatedRequestConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (GetPreauthenticatedRequestResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetPreauthenticatedRequestResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetPreauthenticatedRequestResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetReplicationPolicyResponse getReplicationPolicy(GetReplicationPolicyRequest request) {
        LOG.trace("Called getReplicationPolicy");
        GetReplicationPolicyRequest interceptedRequest = GetReplicationPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetReplicationPolicyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetReplicationPolicyResponse> transformer = GetReplicationPolicyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (GetReplicationPolicyResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetReplicationPolicyResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetReplicationPolicyResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetRetentionRuleResponse getRetentionRule(GetRetentionRuleRequest request) {
        LOG.trace("Called getRetentionRule");
        GetRetentionRuleRequest interceptedRequest = GetRetentionRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetRetentionRuleConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetRetentionRuleResponse> transformer = GetRetentionRuleConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (GetRetentionRuleResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetRetentionRuleResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetRetentionRuleResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        LOG.trace("Called getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (GetWorkRequestResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetWorkRequestResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetWorkRequestResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public HeadBucketResponse headBucket(HeadBucketRequest request) {
        LOG.trace("Called headBucket");
        HeadBucketRequest interceptedRequest = HeadBucketConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = HeadBucketConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, HeadBucketResponse> transformer = HeadBucketConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (HeadBucketResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (HeadBucketResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.head(ib, (BmcRequest)retriedRequest);
                return (HeadBucketResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public HeadObjectResponse headObject(HeadObjectRequest request) {
        LOG.trace("Called headObject");
        HeadObjectRequest interceptedRequest = HeadObjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = HeadObjectConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, HeadObjectResponse> transformer = HeadObjectConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (HeadObjectResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (HeadObjectResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.head(ib, (BmcRequest)retriedRequest);
                return (HeadObjectResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListBucketsResponse listBuckets(ListBucketsRequest request) {
        LOG.trace("Called listBuckets");
        ListBucketsRequest interceptedRequest = ListBucketsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListBucketsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListBucketsResponse> transformer = ListBucketsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ListBucketsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListBucketsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListBucketsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListMultipartUploadPartsResponse listMultipartUploadParts(ListMultipartUploadPartsRequest request) {
        LOG.trace("Called listMultipartUploadParts");
        ListMultipartUploadPartsRequest interceptedRequest = ListMultipartUploadPartsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListMultipartUploadPartsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListMultipartUploadPartsResponse> transformer = ListMultipartUploadPartsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ListMultipartUploadPartsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListMultipartUploadPartsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListMultipartUploadPartsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListMultipartUploadsResponse listMultipartUploads(ListMultipartUploadsRequest request) {
        LOG.trace("Called listMultipartUploads");
        ListMultipartUploadsRequest interceptedRequest = ListMultipartUploadsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListMultipartUploadsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListMultipartUploadsResponse> transformer = ListMultipartUploadsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ListMultipartUploadsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListMultipartUploadsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListMultipartUploadsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListObjectVersionsResponse listObjectVersions(ListObjectVersionsRequest request) {
        LOG.trace("Called listObjectVersions");
        ListObjectVersionsRequest interceptedRequest = ListObjectVersionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListObjectVersionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListObjectVersionsResponse> transformer = ListObjectVersionsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ListObjectVersionsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListObjectVersionsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListObjectVersionsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListObjectsResponse listObjects(ListObjectsRequest request) {
        LOG.trace("Called listObjects");
        ListObjectsRequest interceptedRequest = ListObjectsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListObjectsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListObjectsResponse> transformer = ListObjectsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ListObjectsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListObjectsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListObjectsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListPreauthenticatedRequestsResponse listPreauthenticatedRequests(ListPreauthenticatedRequestsRequest request) {
        LOG.trace("Called listPreauthenticatedRequests");
        ListPreauthenticatedRequestsRequest interceptedRequest = ListPreauthenticatedRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListPreauthenticatedRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListPreauthenticatedRequestsResponse> transformer = ListPreauthenticatedRequestsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ListPreauthenticatedRequestsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListPreauthenticatedRequestsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListPreauthenticatedRequestsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListReplicationPoliciesResponse listReplicationPolicies(ListReplicationPoliciesRequest request) {
        LOG.trace("Called listReplicationPolicies");
        ListReplicationPoliciesRequest interceptedRequest = ListReplicationPoliciesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListReplicationPoliciesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListReplicationPoliciesResponse> transformer = ListReplicationPoliciesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ListReplicationPoliciesResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListReplicationPoliciesResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListReplicationPoliciesResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListReplicationSourcesResponse listReplicationSources(ListReplicationSourcesRequest request) {
        LOG.trace("Called listReplicationSources");
        ListReplicationSourcesRequest interceptedRequest = ListReplicationSourcesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListReplicationSourcesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListReplicationSourcesResponse> transformer = ListReplicationSourcesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ListReplicationSourcesResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListReplicationSourcesResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListReplicationSourcesResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListRetentionRulesResponse listRetentionRules(ListRetentionRulesRequest request) {
        LOG.trace("Called listRetentionRules");
        ListRetentionRulesRequest interceptedRequest = ListRetentionRulesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListRetentionRulesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListRetentionRulesResponse> transformer = ListRetentionRulesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ListRetentionRulesResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListRetentionRulesResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListRetentionRulesResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        LOG.trace("Called listWorkRequestErrors");
        ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ListWorkRequestErrorsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestErrorsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestErrorsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        LOG.trace("Called listWorkRequestLogs");
        ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ListWorkRequestLogsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestLogsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestLogsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        LOG.trace("Called listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ListWorkRequestsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public MakeBucketWritableResponse makeBucketWritable(MakeBucketWritableRequest request) {
        LOG.trace("Called makeBucketWritable");
        MakeBucketWritableRequest interceptedRequest = MakeBucketWritableConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = MakeBucketWritableConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, MakeBucketWritableResponse> transformer = MakeBucketWritableConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (MakeBucketWritableResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (MakeBucketWritableResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (MakeBucketWritableResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutObjectResponse putObject(PutObjectRequest request) {
        LOG.trace("Called putObject");
        try {
            if (request.getRetryConfiguration() != null || this.retryConfiguration != null || this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
                request = (PutObjectRequest)Retriers.wrapBodyInputStreamIfNecessary((BmcRequest)request, (BmcRequest.Builder)PutObjectRequest.builder());
            }
            PutObjectRequest interceptedRequest = PutObjectConverter.interceptRequest(request);
            WrappedInvocationBuilder ib = PutObjectConverter.fromRequest(this.client, interceptedRequest);
            Function<Response, PutObjectResponse> transformer = PutObjectConverter.fromResponse();
            ib.property("x-obmcs-internal-signing-strategy-name", (Object)SigningStrategy.EXCLUDE_BODY);
            BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
            RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
            PutObjectResponse putObjectResponse = (PutObjectResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
                TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
                return (PutObjectResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                    try {
                        Response response = this.client.put(ib, (Object)retriedRequest.getPutObjectBody(), (BmcRequest)retriedRequest);
                        return (PutObjectResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
                    }
                    catch (RuntimeException e) {
                        if (interceptedRequest.getRetryConfiguration() != null || this.retryConfiguration != null || e instanceof BmcException && tokenRefreshRetrier.getRetryCondition().shouldBeRetried((BmcException)e)) {
                            Retriers.tryResetStreamForRetry((InputStream)interceptedRequest.getPutObjectBody(), (boolean)true);
                        }
                        throw e;
                    }
                })));
            }));
            return putObjectResponse;
        }
        finally {
            KeepOpenInputStream.closeStream((InputStream)request.getPutObjectBody());
        }
    }

    @Override
    public PutObjectLifecyclePolicyResponse putObjectLifecyclePolicy(PutObjectLifecyclePolicyRequest request) {
        LOG.trace("Called putObjectLifecyclePolicy");
        PutObjectLifecyclePolicyRequest interceptedRequest = PutObjectLifecyclePolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = PutObjectLifecyclePolicyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, PutObjectLifecyclePolicyResponse> transformer = PutObjectLifecyclePolicyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (PutObjectLifecyclePolicyResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (PutObjectLifecyclePolicyResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getPutObjectLifecyclePolicyDetails(), (BmcRequest)retriedRequest);
                return (PutObjectLifecyclePolicyResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ReencryptBucketResponse reencryptBucket(ReencryptBucketRequest request) {
        LOG.trace("Called reencryptBucket");
        ReencryptBucketRequest interceptedRequest = ReencryptBucketConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ReencryptBucketConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ReencryptBucketResponse> transformer = ReencryptBucketConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ReencryptBucketResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ReencryptBucketResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (ReencryptBucketResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ReencryptObjectResponse reencryptObject(ReencryptObjectRequest request) {
        LOG.trace("Called reencryptObject");
        ReencryptObjectRequest interceptedRequest = ReencryptObjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ReencryptObjectConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ReencryptObjectResponse> transformer = ReencryptObjectConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ReencryptObjectResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ReencryptObjectResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getReencryptObjectDetails(), (BmcRequest)retriedRequest);
                return (ReencryptObjectResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public RenameObjectResponse renameObject(RenameObjectRequest request) {
        LOG.trace("Called renameObject");
        RenameObjectRequest interceptedRequest = RenameObjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RenameObjectConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RenameObjectResponse> transformer = RenameObjectConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (RenameObjectResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (RenameObjectResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getRenameObjectDetails(), (BmcRequest)retriedRequest);
                return (RenameObjectResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public RestoreObjectsResponse restoreObjects(RestoreObjectsRequest request) {
        LOG.trace("Called restoreObjects");
        RestoreObjectsRequest interceptedRequest = RestoreObjectsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RestoreObjectsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RestoreObjectsResponse> transformer = RestoreObjectsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (RestoreObjectsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (RestoreObjectsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getRestoreObjectsDetails(), (BmcRequest)retriedRequest);
                return (RestoreObjectsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public UpdateBucketResponse updateBucket(UpdateBucketRequest request) {
        LOG.trace("Called updateBucket");
        UpdateBucketRequest interceptedRequest = UpdateBucketConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateBucketConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateBucketResponse> transformer = UpdateBucketConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (UpdateBucketResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateBucketResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getUpdateBucketDetails(), (BmcRequest)retriedRequest);
                return (UpdateBucketResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public UpdateNamespaceMetadataResponse updateNamespaceMetadata(UpdateNamespaceMetadataRequest request) {
        LOG.trace("Called updateNamespaceMetadata");
        UpdateNamespaceMetadataRequest interceptedRequest = UpdateNamespaceMetadataConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateNamespaceMetadataConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateNamespaceMetadataResponse> transformer = UpdateNamespaceMetadataConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (UpdateNamespaceMetadataResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateNamespaceMetadataResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateNamespaceMetadataDetails(), (BmcRequest)retriedRequest);
                return (UpdateNamespaceMetadataResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public UpdateObjectStorageTierResponse updateObjectStorageTier(UpdateObjectStorageTierRequest request) {
        LOG.trace("Called updateObjectStorageTier");
        UpdateObjectStorageTierRequest interceptedRequest = UpdateObjectStorageTierConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateObjectStorageTierConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateObjectStorageTierResponse> transformer = UpdateObjectStorageTierConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (UpdateObjectStorageTierResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateObjectStorageTierResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getUpdateObjectStorageTierDetails(), (BmcRequest)retriedRequest);
                return (UpdateObjectStorageTierResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public UpdateRetentionRuleResponse updateRetentionRule(UpdateRetentionRuleRequest request) {
        LOG.trace("Called updateRetentionRule");
        UpdateRetentionRuleRequest interceptedRequest = UpdateRetentionRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateRetentionRuleConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateRetentionRuleResponse> transformer = UpdateRetentionRuleConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (UpdateRetentionRuleResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateRetentionRuleResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateRetentionRuleDetails(), (BmcRequest)retriedRequest);
                return (UpdateRetentionRuleResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UploadPartResponse uploadPart(UploadPartRequest request) {
        LOG.trace("Called uploadPart");
        try {
            if (request.getRetryConfiguration() != null || this.retryConfiguration != null || this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
                request = (UploadPartRequest)Retriers.wrapBodyInputStreamIfNecessary((BmcRequest)request, (BmcRequest.Builder)UploadPartRequest.builder());
            }
            UploadPartRequest interceptedRequest = UploadPartConverter.interceptRequest(request);
            WrappedInvocationBuilder ib = UploadPartConverter.fromRequest(this.client, interceptedRequest);
            Function<Response, UploadPartResponse> transformer = UploadPartConverter.fromResponse();
            ib.property("x-obmcs-internal-signing-strategy-name", (Object)SigningStrategy.EXCLUDE_BODY);
            BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
            RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
            UploadPartResponse uploadPartResponse = (UploadPartResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
                TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
                return (UploadPartResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                    try {
                        Response response = this.client.put(ib, (Object)retriedRequest.getUploadPartBody(), (BmcRequest)retriedRequest);
                        return (UploadPartResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
                    }
                    catch (RuntimeException e) {
                        if (interceptedRequest.getRetryConfiguration() != null || this.retryConfiguration != null || e instanceof BmcException && tokenRefreshRetrier.getRetryCondition().shouldBeRetried((BmcException)e)) {
                            Retriers.tryResetStreamForRetry((InputStream)interceptedRequest.getUploadPartBody(), (boolean)true);
                        }
                        throw e;
                    }
                })));
            }));
            return uploadPartResponse;
        }
        finally {
            KeepOpenInputStream.closeStream((InputStream)request.getUploadPartBody());
        }
    }

    @Override
    public ObjectStorageWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public ObjectStoragePaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ObjectStorageClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public ObjectStorageClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new ObjectStorageClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

