/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.druid.common;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum DruidCompareOp {
    EQUAL("$eq"),
    NOT_EQUAL("$ne"),
    GREATER_OR_EQUAL("$gte"),
    GREATER("$gt"),
    LESS_OR_EQUAL("$lte"),
    LESS("$lt"),
    IN("$in"),
    AND("and"),
    OR("or"),
    NOT("not"),
    OPTIONS("$options"),
    PROJECT("$project"),
    COND("$cond"),
    IFNULL("$ifNull"),
    IFNOTNULL("$ifNotNull"),
    SUM("$sum"),
    GROUP_BY("$group"),
    EXISTS("$exists"),
    TYPE_SELECTOR("selector"),
    TYPE_IN("in"),
    TYPE_REGEX("regex"),
    TYPE_SEARCH("search"),
    TYPE_SEARCH_CONTAINS("contains"),
    TYPE_SEARCH_CASESENSITIVE("caseSensitive"),
    TYPE_BOUND("bound");

    private final String compareOp;
    private static final Map<String, DruidCompareOp> ENUM_MAP;

    private DruidCompareOp(String compareOp) {
        this.compareOp = compareOp;
    }

    public String getCompareOp() {
        return this.compareOp;
    }

    public static DruidCompareOp get(String name) {
        return ENUM_MAP.get(name);
    }

    static {
        ConcurrentHashMap<String, DruidCompareOp> map = new ConcurrentHashMap<String, DruidCompareOp>();
        for (DruidCompareOp instance : DruidCompareOp.values()) {
            map.put(instance.getCompareOp(), instance);
        }
        ENUM_MAP = Collections.unmodifiableMap(map);
    }
}

