/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.druid;

import org.apache.commons.lang3.StringUtils;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.store.druid.DruidScanSpec;
import org.apache.drill.exec.store.druid.common.DruidBoundFilter;
import org.apache.drill.exec.store.druid.common.DruidFilter;
import org.apache.drill.exec.store.druid.common.DruidIntervalFilter;
import org.apache.drill.exec.store.druid.common.DruidNotFilter;
import org.apache.drill.exec.store.druid.common.DruidRegexFilter;
import org.apache.drill.exec.store.druid.common.DruidSearchFilter;
import org.apache.drill.exec.store.druid.common.DruidSearchQuerySpec;
import org.apache.drill.exec.store.druid.common.DruidSelectorFilter;

public class DruidScanSpecBuilder {
    private static final String REGEX_KEYWORD_HINT = "$regex$_";

    DruidScanSpec build(String dataSourceName, long dataSourceSize, String maxTime, String minTime, String functionName, SchemaPath field, Object fieldValue) {
        String fieldName = field.getAsNamePart().getName();
        DruidFilter filter = this.translateFilter(functionName, fieldName, String.valueOf(fieldValue));
        return filter == null ? null : new DruidScanSpec(dataSourceName, filter, dataSourceSize, maxTime, minTime);
    }

    private DruidFilter translateFilter(String functionName, String fieldName, String fieldValue) {
        switch (functionName) {
            case "equal": {
                if (fieldName.equalsIgnoreCase("eventInterval")) {
                    return new DruidIntervalFilter(fieldValue);
                }
                return new DruidSelectorFilter(fieldName, fieldValue);
            }
            case "not_equal": {
                DruidSelectorFilter druidSelectorFilter = new DruidSelectorFilter(fieldName, fieldValue);
                return new DruidNotFilter(druidSelectorFilter);
            }
            case "greater_than_or_equal_to": {
                return new DruidBoundFilter(fieldName, fieldValue, null, null, null);
            }
            case "greater_than": {
                return new DruidBoundFilter(fieldName, fieldValue, null, true, null);
            }
            case "less_than_or_equal_to": {
                return new DruidBoundFilter(fieldName, null, fieldValue, null, null);
            }
            case "less_than": {
                return new DruidBoundFilter(fieldName, null, fieldValue, null, true);
            }
            case "isnull": {
                return new DruidSelectorFilter(fieldName, null);
            }
            case "isnotnull": {
                DruidSelectorFilter druidSelectorFilter = new DruidSelectorFilter(fieldName, null);
                return new DruidNotFilter(druidSelectorFilter);
            }
            case "like": {
                if (fieldValue.startsWith(REGEX_KEYWORD_HINT)) {
                    return new DruidRegexFilter(fieldName, fieldValue.substring(REGEX_KEYWORD_HINT.length()));
                }
                String fieldValueNormalized = StringUtils.removeStart((String)StringUtils.removeEnd((String)fieldValue, (String)"%"), (String)"%");
                return new DruidSearchFilter(fieldName, new DruidSearchQuerySpec(fieldValueNormalized, false));
            }
        }
        return null;
    }
}

