/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.druid;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.ops.ExecutorFragmentContext;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.impl.BatchCreator;
import org.apache.drill.exec.physical.impl.ScanBatch;
import org.apache.drill.exec.record.CloseableRecordBatch;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.store.druid.DruidRecordReader;
import org.apache.drill.exec.store.druid.DruidSubScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DruidScanBatchCreator
implements BatchCreator<DruidSubScan> {
    private static final Logger logger = LoggerFactory.getLogger(DruidScanBatchCreator.class);

    public CloseableRecordBatch getBatch(ExecutorFragmentContext context, DruidSubScan subScan, List<RecordBatch> children) throws ExecutionSetupException {
        Preconditions.checkArgument((boolean)children.isEmpty());
        ArrayList readers = Lists.newArrayList();
        for (DruidSubScan.DruidSubScanSpec scanSpec : subScan.getScanSpec()) {
            try {
                List<SchemaPath> columns = subScan.getColumns();
                readers.add(new DruidRecordReader(scanSpec, columns, subScan.getMaxRecordsToRead(), (FragmentContext)context, subScan.getStorageEngine()));
            }
            catch (Exception ex) {
                throw new ExecutionSetupException((Throwable)ex);
            }
        }
        logger.debug("Number of record readers initialized - {}", (Object)readers.size());
        return new ScanBatch((PhysicalOperator)subScan, (FragmentContext)context, (List)readers);
    }
}

