/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.druid;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.util.JacksonUtils;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.impl.OutputMutator;
import org.apache.drill.exec.store.AbstractRecordReader;
import org.apache.drill.exec.store.druid.DruidStoragePlugin;
import org.apache.drill.exec.store.druid.DruidSubScan;
import org.apache.drill.exec.store.druid.common.DruidFilter;
import org.apache.drill.exec.store.druid.druid.DruidScanResponse;
import org.apache.drill.exec.store.druid.druid.ScanQuery;
import org.apache.drill.exec.store.druid.druid.ScanQueryBuilder;
import org.apache.drill.exec.store.druid.rest.DruidQueryClient;
import org.apache.drill.exec.vector.complex.fn.JsonReader;
import org.apache.drill.exec.vector.complex.impl.VectorContainerWriter;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DruidRecordReader
extends AbstractRecordReader {
    private static final Logger logger = LoggerFactory.getLogger(DruidRecordReader.class);
    private static final ObjectMapper objectMapper = JacksonUtils.createObjectMapper();
    private final DruidStoragePlugin plugin;
    private final DruidSubScan.DruidSubScanSpec scanSpec;
    private final List<String> columns;
    private final DruidFilter filter;
    private BigInteger nextOffset = BigInteger.ZERO;
    private int maxRecordsToRead = -1;
    private JsonReader jsonReader;
    private VectorContainerWriter writer;
    private final FragmentContext fragmentContext;
    private final DruidQueryClient druidQueryClient;

    public DruidRecordReader(DruidSubScan.DruidSubScanSpec subScanSpec, List<SchemaPath> projectedColumns, int maxRecordsToRead, FragmentContext context, DruidStoragePlugin plugin) {
        this.columns = new ArrayList<String>();
        this.setColumns(projectedColumns);
        this.maxRecordsToRead = maxRecordsToRead;
        this.plugin = plugin;
        this.scanSpec = subScanSpec;
        this.fragmentContext = context;
        this.filter = subScanSpec.getFilter();
        this.druidQueryClient = plugin.getDruidQueryClient();
    }

    protected Collection<SchemaPath> transformColumns(Collection<SchemaPath> projectedColumns) {
        LinkedHashSet transformed = Sets.newLinkedHashSet();
        if (this.isStarQuery()) {
            transformed.add(SchemaPath.STAR_COLUMN);
        } else {
            for (SchemaPath column : projectedColumns) {
                String fieldName = column.getRootSegment().getPath();
                transformed.add(column);
                this.columns.add(fieldName);
            }
        }
        return transformed;
    }

    public void setup(OperatorContext context, OutputMutator output) {
        this.writer = new VectorContainerWriter(output);
        this.jsonReader = new JsonReader.Builder(this.fragmentContext.getManagedBuffer()).schemaPathColumns((List)ImmutableList.copyOf((Collection)this.getColumns())).skipOuterList(true).build();
    }

    public int next() {
        this.writer.allocate();
        this.writer.reset();
        Stopwatch watch = Stopwatch.createStarted();
        try {
            String query = this.getQuery();
            DruidScanResponse druidScanResponse = this.druidQueryClient.executeQuery(query);
            this.setNextOffset(druidScanResponse);
            int docCount = 0;
            for (ObjectNode eventNode : druidScanResponse.getEvents()) {
                this.writer.setPosition(docCount);
                this.jsonReader.setSource((JsonNode)eventNode);
                try {
                    this.jsonReader.write((BaseWriter.ComplexWriter)this.writer);
                }
                catch (IOException e) {
                    throw UserException.dataReadError((Throwable)e).message("Failure while reading document", new Object[0]).addContext("Failed Query", query).addContext("Parser was at record", eventNode.toString()).addContext(e.getMessage()).build(logger);
                }
                ++docCount;
            }
            this.writer.setValueCount(docCount);
            logger.debug("Took {} ms to get {} records", (Object)watch.elapsed(TimeUnit.MILLISECONDS), (Object)docCount);
            return docCount;
        }
        catch (Exception e) {
            throw UserException.dataReadError((Throwable)e).message("Failure while executing druid query", new Object[0]).addContext(e.getMessage()).build(logger);
        }
    }

    private String getQuery() throws JsonProcessingException {
        int queryThreshold = this.maxRecordsToRead >= 0 ? Math.min(4096, this.maxRecordsToRead) : 4096;
        ScanQueryBuilder scanQueryBuilder = this.plugin.getScanQueryBuilder();
        ScanQuery scanQuery = scanQueryBuilder.build(this.scanSpec.dataSourceName, this.columns, this.filter, this.nextOffset, queryThreshold, this.scanSpec.getMinTime(), this.scanSpec.getMaxTime());
        return objectMapper.writeValueAsString((Object)scanQuery);
    }

    private void setNextOffset(DruidScanResponse druidScanResponse) {
        this.nextOffset = this.nextOffset.add(BigInteger.valueOf(druidScanResponse.getEvents().size()));
    }

    public void close() throws Exception {
        if (this.writer != null) {
            this.writer.close();
        }
        if (!this.nextOffset.equals(BigInteger.ZERO)) {
            this.nextOffset = BigInteger.ZERO;
        }
        this.jsonReader = null;
    }
}

