/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.druid;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.drill.common.PlanStringBuilder;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.physical.EndpointAffinity;
import org.apache.drill.exec.physical.base.AbstractGroupScan;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.ScanStats;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.druid.DruidScanSpec;
import org.apache.drill.exec.store.druid.DruidStoragePlugin;
import org.apache.drill.exec.store.druid.DruidStoragePluginConfig;
import org.apache.drill.exec.store.druid.DruidSubScan;
import org.apache.drill.exec.store.schedule.AffinityCreator;
import org.apache.drill.exec.store.schedule.AssignmentCreator;
import org.apache.drill.exec.store.schedule.CompleteWork;
import org.apache.drill.exec.store.schedule.EndpointByteMap;
import org.apache.drill.exec.store.schedule.EndpointByteMapImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="druid-scan")
public class DruidGroupScan
extends AbstractGroupScan {
    private static final Logger logger = LoggerFactory.getLogger(DruidGroupScan.class);
    private static final long DEFAULT_TABLET_SIZE = 1000L;
    private final DruidScanSpec scanSpec;
    private final DruidStoragePlugin storagePlugin;
    private List<SchemaPath> columns;
    private boolean filterPushedDown = false;
    private int maxRecordsToRead;
    private List<DruidWork> druidWorkList = new ArrayList<DruidWork>();
    private ListMultimap<Integer, DruidWork> assignments;
    private List<EndpointAffinity> affinities;

    @JsonCreator
    public DruidGroupScan(@JsonProperty(value="userName") String userName, @JsonProperty(value="scanSpec") DruidScanSpec scanSpec, @JsonProperty(value="storagePluginConfig") DruidStoragePluginConfig storagePluginConfig, @JsonProperty(value="columns") List<SchemaPath> columns, @JsonProperty(value="maxRecordsToRead") int maxRecordsToRead, @JacksonInject StoragePluginRegistry pluginRegistry) {
        this(userName, (DruidStoragePlugin)pluginRegistry.resolve((StoragePluginConfig)storagePluginConfig, DruidStoragePlugin.class), scanSpec, columns, maxRecordsToRead);
    }

    public DruidGroupScan(String userName, DruidStoragePlugin storagePlugin, DruidScanSpec scanSpec, List<SchemaPath> columns, int maxRecordsToRead) {
        super(userName);
        this.storagePlugin = storagePlugin;
        this.scanSpec = scanSpec;
        this.columns = columns == null || columns.size() == 0 ? ALL_COLUMNS : columns;
        this.maxRecordsToRead = maxRecordsToRead;
        this.init();
    }

    private DruidGroupScan(DruidGroupScan that) {
        super((AbstractGroupScan)that);
        this.columns = that.columns;
        this.maxRecordsToRead = that.maxRecordsToRead;
        this.scanSpec = that.scanSpec;
        this.storagePlugin = that.storagePlugin;
        this.filterPushedDown = that.filterPushedDown;
        this.druidWorkList = that.druidWorkList;
        this.assignments = that.assignments;
    }

    public GroupScan clone(List<SchemaPath> columns) {
        DruidGroupScan newScan = new DruidGroupScan(this);
        newScan.columns = columns;
        return newScan;
    }

    public GroupScan clone(int maxRecordsToRead) {
        DruidGroupScan newScan = new DruidGroupScan(this);
        newScan.maxRecordsToRead = maxRecordsToRead;
        return newScan;
    }

    public List<EndpointAffinity> getOperatorAffinity() {
        if (this.affinities == null) {
            this.affinities = AffinityCreator.getAffinityMap(this.druidWorkList);
        }
        return this.affinities;
    }

    public boolean canPushdownProjects(List<SchemaPath> columns) {
        return true;
    }

    public boolean supportsLimitPushdown() {
        return true;
    }

    public GroupScan applyLimit(int maxRecords) {
        if (this.maxRecordsToRead == maxRecords) {
            return null;
        }
        return this.clone(maxRecords);
    }

    @JsonIgnore
    public boolean isFilterPushedDown() {
        return this.filterPushedDown;
    }

    @JsonIgnore
    public void setFilterPushedDown(boolean filterPushedDown) {
        this.filterPushedDown = filterPushedDown;
    }

    private void init() {
        logger.debug("Adding Druid Work for Table - {}. Filter - {}", (Object)this.getTableName(), (Object)this.getScanSpec().getFilter());
        DruidWork druidWork = new DruidWork(new DruidSubScan.DruidSubScanSpec(this.getTableName(), this.getScanSpec().getFilter(), this.getDatasourceSize(), this.getDataSourceMinTime(), this.getDataSourceMaxTime()));
        this.druidWorkList.add(druidWork);
    }

    public ScanStats getScanStats() {
        long recordCount = 100000L * (long)this.druidWorkList.size();
        return new ScanStats(ScanStats.GroupScanProperty.NO_EXACT_ROW_COUNT, (double)recordCount, 1.0, (double)(recordCount * (long)this.storagePlugin.getConfig().getAverageRowSizeBytes()));
    }

    public void applyAssignments(List<CoordinationProtos.DrillbitEndpoint> endpoints) {
        this.assignments = AssignmentCreator.getMappings(endpoints, this.druidWorkList);
    }

    public DruidSubScan getSpecificScan(int minorFragmentId) {
        List workList = this.assignments.get((Object)minorFragmentId);
        ArrayList scanSpecList = Lists.newArrayList();
        for (DruidWork druidWork : workList) {
            scanSpecList.add(new DruidSubScan.DruidSubScanSpec(druidWork.getDruidSubScanSpec().getDataSourceName(), druidWork.getDruidSubScanSpec().getFilter(), druidWork.getDruidSubScanSpec().getDataSourceSize(), druidWork.getDruidSubScanSpec().getMinTime(), druidWork.getDruidSubScanSpec().getMaxTime()));
        }
        return new DruidSubScan(this.getUserName(), this.storagePlugin, scanSpecList, this.columns, this.maxRecordsToRead);
    }

    @JsonIgnore
    public String getTableName() {
        return this.getScanSpec().getDataSourceName();
    }

    @JsonIgnore
    public long getDatasourceSize() {
        return this.getScanSpec().getDataSourceSize();
    }

    @JsonIgnore
    public String getDataSourceMinTime() {
        return this.getScanSpec().getDataSourceMinTime();
    }

    @JsonIgnore
    public String getDataSourceMaxTime() {
        return this.getScanSpec().getDataSourceMaxTime();
    }

    public int getMaxParallelizationWidth() {
        return this.druidWorkList.size();
    }

    public String getDigest() {
        return this.toString();
    }

    @JsonProperty(value="druidScanSpec")
    public DruidScanSpec getScanSpec() {
        return this.scanSpec;
    }

    @JsonIgnore
    public DruidStoragePlugin getStoragePlugin() {
        return this.storagePlugin;
    }

    @JsonProperty
    public List<SchemaPath> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public int getMaxRecordsToRead() {
        return this.maxRecordsToRead;
    }

    public String toString() {
        return new PlanStringBuilder((Object)this).field("druidScanSpec", (Object)this.scanSpec).field("columns", this.columns).field("druidStoragePlugin", (Object)this.storagePlugin).toString();
    }

    @JsonIgnore
    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) {
        Preconditions.checkArgument((boolean)children.isEmpty());
        return new DruidGroupScan(this);
    }

    private static class DruidWork
    implements CompleteWork {
        private final EndpointByteMapImpl byteMap = new EndpointByteMapImpl();
        private final DruidSubScan.DruidSubScanSpec druidSubScanSpec;

        public DruidWork(DruidSubScan.DruidSubScanSpec druidSubScanSpec) {
            this.druidSubScanSpec = druidSubScanSpec;
        }

        public DruidSubScan.DruidSubScanSpec getDruidSubScanSpec() {
            return this.druidSubScanSpec;
        }

        public long getTotalBytes() {
            return 1000L;
        }

        public EndpointByteMap getByteMap() {
            return this.byteMap;
        }

        public int compareTo(CompleteWork o) {
            return 0;
        }
    }
}

