/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.druid;

import java.util.List;
import org.apache.drill.common.expression.BooleanOperator;
import org.apache.drill.common.expression.FunctionCall;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.visitors.AbstractExprVisitor;
import org.apache.drill.common.expression.visitors.ExprVisitor;
import org.apache.drill.exec.store.druid.DruidCompareFunctionProcessor;
import org.apache.drill.exec.store.druid.DruidGroupScan;
import org.apache.drill.exec.store.druid.DruidScanSpec;
import org.apache.drill.exec.store.druid.DruidScanSpecBuilder;
import org.apache.drill.exec.store.druid.common.DruidFilter;
import org.apache.drill.exec.store.druid.common.DruidUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DruidFilterBuilder
extends AbstractExprVisitor<DruidScanSpec, Void, RuntimeException> {
    private static final Logger logger = LoggerFactory.getLogger(DruidFilterBuilder.class);
    private final DruidGroupScan groupScan;
    private final LogicalExpression le;
    private final DruidScanSpecBuilder druidScanSpecBuilder;
    private boolean allExpressionsConverted = true;

    public DruidFilterBuilder(DruidGroupScan groupScan, LogicalExpression conditionExp) {
        this.groupScan = groupScan;
        this.le = conditionExp;
        this.druidScanSpecBuilder = new DruidScanSpecBuilder();
    }

    public DruidScanSpec parseTree() {
        logger.debug("DruidScanSpec parseTree() called.");
        DruidScanSpec parsedSpec = (DruidScanSpec)this.le.accept((ExprVisitor)this, null);
        if (parsedSpec != null) {
            parsedSpec = this.mergeScanSpecs("booleanAnd", this.groupScan.getScanSpec(), parsedSpec);
        }
        return parsedSpec;
    }

    private DruidScanSpec mergeScanSpecs(String functionName, DruidScanSpec leftScanSpec, DruidScanSpec rightScanSpec) {
        logger.debug("mergeScanSpecs called for functionName - {}", (Object)functionName);
        DruidFilter newFilter = null;
        switch (functionName) {
            case "booleanAnd": {
                if (leftScanSpec.getFilter() != null && rightScanSpec.getFilter() != null) {
                    newFilter = DruidUtils.andFilterAtIndex(leftScanSpec.getFilter(), rightScanSpec.getFilter());
                    break;
                }
                if (leftScanSpec.getFilter() != null) {
                    newFilter = leftScanSpec.getFilter();
                    break;
                }
                newFilter = rightScanSpec.getFilter();
                break;
            }
            case "booleanOr": {
                newFilter = DruidUtils.orFilterAtIndex(leftScanSpec.getFilter(), rightScanSpec.getFilter());
            }
        }
        return new DruidScanSpec(this.groupScan.getScanSpec().getDataSourceName(), newFilter, this.groupScan.getScanSpec().getDataSourceSize(), this.groupScan.getScanSpec().getDataSourceMinTime(), this.groupScan.getScanSpec().getDataSourceMaxTime());
    }

    public boolean isAllExpressionsConverted() {
        return this.allExpressionsConverted;
    }

    public DruidScanSpec visitUnknown(LogicalExpression e, Void value) throws RuntimeException {
        this.allExpressionsConverted = false;
        return null;
    }

    public DruidScanSpec visitBooleanOperator(BooleanOperator op, Void value) {
        List args = op.args();
        DruidScanSpec nodeScanSpec = null;
        String functionName = op.getName();
        logger.debug("visitBooleanOperator Called. FunctionName - {}", (Object)functionName);
        for (LogicalExpression arg : args) {
            switch (functionName) {
                case "booleanAnd": 
                case "booleanOr": {
                    if (nodeScanSpec == null) {
                        nodeScanSpec = (DruidScanSpec)arg.accept((ExprVisitor)this, null);
                        break;
                    }
                    DruidScanSpec scanSpec = (DruidScanSpec)arg.accept((ExprVisitor)this, null);
                    if (scanSpec != null) {
                        nodeScanSpec = this.mergeScanSpecs(functionName, nodeScanSpec, scanSpec);
                        break;
                    }
                    this.allExpressionsConverted = false;
                }
            }
        }
        return nodeScanSpec;
    }

    public DruidScanSpec visitFunctionCall(FunctionCall call, Void value) throws RuntimeException {
        DruidScanSpec nodeScanSpec = null;
        String functionName = call.getName();
        List args = call.args();
        logger.debug("visitFunctionCall Called. FunctionName - {}", (Object)functionName);
        if (DruidCompareFunctionProcessor.isCompareFunction(functionName)) {
            DruidCompareFunctionProcessor processor = DruidCompareFunctionProcessor.process(call);
            if (processor.isSuccess()) {
                DruidScanSpec scanSpec = this.groupScan.getScanSpec();
                nodeScanSpec = this.druidScanSpecBuilder.build(scanSpec.getDataSourceName(), scanSpec.getDataSourceSize(), scanSpec.getDataSourceMinTime(), scanSpec.getDataSourceMaxTime(), processor.getFunctionName(), processor.getPath(), processor.getValue());
            }
        } else {
            switch (functionName) {
                case "booleanAnd": 
                case "booleanOr": {
                    DruidScanSpec leftScanSpec = (DruidScanSpec)((LogicalExpression)args.get(0)).accept((ExprVisitor)this, null);
                    DruidScanSpec rightScanSpec = (DruidScanSpec)((LogicalExpression)args.get(1)).accept((ExprVisitor)this, null);
                    if (leftScanSpec != null && rightScanSpec != null) {
                        nodeScanSpec = this.mergeScanSpecs(functionName, leftScanSpec, rightScanSpec);
                        break;
                    }
                    this.allExpressionsConverted = false;
                    if (!"booleanAnd".equals(functionName)) break;
                    DruidScanSpec druidScanSpec = nodeScanSpec = leftScanSpec == null ? rightScanSpec : leftScanSpec;
                }
            }
        }
        if (nodeScanSpec == null) {
            this.allExpressionsConverted = false;
        }
        return nodeScanSpec;
    }
}

