/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.util.Map;

public class PropertyUtil {
    private PropertyUtil() {
    }

    public static boolean propertyAsBoolean(Map<String, String> properties, String property, boolean defaultValue) {
        String value = properties.get(property);
        if (value != null) {
            return Boolean.parseBoolean(properties.get(property));
        }
        return defaultValue;
    }

    public static double propertyAsDouble(Map<String, String> properties, String property, double defaultValue) {
        String value = properties.get(property);
        if (value != null) {
            return Double.parseDouble(properties.get(property));
        }
        return defaultValue;
    }

    public static int propertyAsInt(Map<String, String> properties, String property, int defaultValue) {
        String value = properties.get(property);
        if (value != null) {
            return Integer.parseInt(properties.get(property));
        }
        return defaultValue;
    }

    public static long propertyAsLong(Map<String, String> properties, String property, long defaultValue) {
        String value = properties.get(property);
        if (value != null) {
            return Long.parseLong(properties.get(property));
        }
        return defaultValue;
    }

    public static String propertyAsString(Map<String, String> properties, String property, String defaultValue) {
        String value = properties.get(property);
        if (value != null) {
            return properties.get(property);
        }
        return defaultValue;
    }
}

