/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.AllDataFilesTable;
import org.apache.iceberg.AllEntriesTable;
import org.apache.iceberg.AllManifestsTable;
import org.apache.iceberg.BaseMetastoreCatalog;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.DataFilesTable;
import org.apache.iceberg.HistoryTable;
import org.apache.iceberg.ManifestEntriesTable;
import org.apache.iceberg.ManifestsTable;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.PartitionsTable;
import org.apache.iceberg.SnapshotsTable;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.NoSuchTableException;

public class MetadataTableUtils {
    private MetadataTableUtils() {
    }

    public static boolean hasMetadataTableName(TableIdentifier identifier) {
        return MetadataTableType.from(identifier.name()) != null;
    }

    public static Table createMetadataTableInstance(TableOperations ops, String baseTableName, String metadataTableName, MetadataTableType type) {
        BaseTable baseTable = new BaseTable(ops, baseTableName);
        switch (type) {
            case ENTRIES: {
                return new ManifestEntriesTable(ops, baseTable, metadataTableName);
            }
            case FILES: {
                return new DataFilesTable(ops, baseTable, metadataTableName);
            }
            case HISTORY: {
                return new HistoryTable(ops, baseTable, metadataTableName);
            }
            case SNAPSHOTS: {
                return new SnapshotsTable(ops, baseTable, metadataTableName);
            }
            case MANIFESTS: {
                return new ManifestsTable(ops, baseTable, metadataTableName);
            }
            case PARTITIONS: {
                return new PartitionsTable(ops, baseTable, metadataTableName);
            }
            case ALL_DATA_FILES: {
                return new AllDataFilesTable(ops, baseTable, metadataTableName);
            }
            case ALL_MANIFESTS: {
                return new AllManifestsTable(ops, baseTable, metadataTableName);
            }
            case ALL_ENTRIES: {
                return new AllEntriesTable(ops, baseTable, metadataTableName);
            }
        }
        throw new NoSuchTableException("Unknown metadata table type: %s for %s", new Object[]{type, metadataTableName});
    }

    public static Table createMetadataTableInstance(TableOperations ops, String catalogName, TableIdentifier baseTableIdentifier, TableIdentifier metadataTableIdentifier, MetadataTableType type) {
        String baseTableName = BaseMetastoreCatalog.fullTableName(catalogName, baseTableIdentifier);
        String metadataTableName = BaseMetastoreCatalog.fullTableName(catalogName, metadataTableIdentifier);
        return MetadataTableUtils.createMetadataTableInstance(ops, baseTableName, metadataTableName, type);
    }
}

