/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util.json;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.expression.function.EncodeFormat;
import org.apache.phoenix.schema.IllegalDataException;
import org.apache.phoenix.schema.types.PBinary;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.base.CaseFormat;
import org.apache.phoenix.thirdparty.com.google.common.base.Function;
import org.apache.phoenix.util.ColumnInfo;
import org.apache.phoenix.util.DateUtil;
import org.apache.phoenix.util.UpsertExecutor;
import org.apache.phoenix.util.json.ObjectToArrayConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUpsertExecutor
extends UpsertExecutor<Map<?, ?>, Object> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(JsonUpsertExecutor.class);

    @VisibleForTesting
    protected JsonUpsertExecutor(Connection conn, List<ColumnInfo> columnInfoList, PreparedStatement stmt, UpsertExecutor.UpsertListener<Map<?, ?>> upsertListener) {
        super(conn, columnInfoList, stmt, upsertListener);
        this.finishInit();
    }

    public JsonUpsertExecutor(Connection conn, String tableName, List<ColumnInfo> columnInfoList, UpsertExecutor.UpsertListener<Map<?, ?>> upsertListener) {
        super(conn, tableName, columnInfoList, upsertListener);
        this.finishInit();
    }

    @Override
    protected void execute(Map<?, ?> record) {
        int fieldIndex = 0;
        String colName = null;
        try {
            if (record.size() < this.conversionFunctions.size()) {
                String message = String.format("JSON record does not have enough values (has %d, but needs %d)", record.size(), this.conversionFunctions.size());
                throw new IllegalArgumentException(message);
            }
            for (fieldIndex = 0; fieldIndex < this.conversionFunctions.size(); ++fieldIndex) {
                Object sqlValue;
                colName = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_UNDERSCORE, ((ColumnInfo)this.columnInfos.get(fieldIndex)).getColumnName());
                if (colName.contains(".")) {
                    StringBuilder sb = new StringBuilder();
                    String[] parts = colName.split("\\.");
                    for (int i = 1; i < parts.length; ++i) {
                        sb.append(parts[i]);
                        if (i == parts.length - 1) continue;
                        sb.append(".");
                    }
                    colName = sb.toString();
                }
                if (colName.contains("\"")) {
                    colName = colName.replace("\"", "");
                }
                if ((sqlValue = ((Function)this.conversionFunctions.get(fieldIndex)).apply(record.get(colName))) != null) {
                    this.preparedStatement.setObject(fieldIndex + 1, sqlValue);
                    continue;
                }
                this.preparedStatement.setNull(fieldIndex + 1, ((PDataType)this.dataTypes.get(fieldIndex)).getSqlType());
            }
            this.preparedStatement.execute();
            this.upsertListener.upsertDone(++this.upsertCount);
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Error on record " + record + ", fieldIndex " + fieldIndex + ", colName " + colName, (Throwable)e);
            }
            this.upsertListener.errorOnRecord(record, new Exception("fieldIndex: " + fieldIndex + ", colName " + colName, e));
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.preparedStatement.close();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Function<Object, Object> createConversionFunction(PDataType dataType) {
        if (dataType.isArrayType()) {
            return new ArrayDatatypeConversionFunction(new ObjectToArrayConverter(this.conn, PDataType.fromTypeId(dataType.getSqlType() - 3000)));
        }
        return new SimpleDatatypeConversionFunction(dataType, this.conn);
    }

    private static class ArrayDatatypeConversionFunction
    implements Function<Object, Object> {
        private final ObjectToArrayConverter arrayConverter;

        private ArrayDatatypeConversionFunction(ObjectToArrayConverter arrayConverter) {
            this.arrayConverter = arrayConverter;
        }

        @Nullable
        public Object apply(@Nullable Object input) {
            try {
                return this.arrayConverter.toArray(input);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class SimpleDatatypeConversionFunction
    implements Function<Object, Object> {
        private final PDataType dataType;
        private final DateUtil.DateTimeParser dateTimeParser;
        private final String binaryEncoding;

        SimpleDatatypeConversionFunction(PDataType dataType, Connection conn) {
            Properties props;
            try {
                props = conn.getClientInfo();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            this.dataType = dataType;
            if (dataType.isCoercibleTo(PTimestamp.INSTANCE)) {
                int dateSqlType = dataType.getResultSetSqlType();
                String dateFormat = dateSqlType == 91 ? props.getProperty("phoenix.query.dateFormat", "yyyy-MM-dd HH:mm:ss.SSS") : (dateSqlType == 92 ? props.getProperty("phoenix.query.timeFormat", "yyyy-MM-dd HH:mm:ss.SSS") : props.getProperty("phoenix.query.timestampFormat", "yyyy-MM-dd HH:mm:ss.SSS"));
                String timeZoneId = props.getProperty("phoenix.query.dateFormatTimeZone", "GMT");
                this.dateTimeParser = DateUtil.getDateTimeParser(dateFormat, dataType, timeZoneId);
            } else {
                this.dateTimeParser = null;
            }
            this.binaryEncoding = props.getProperty("phoenix.upload.binaryDataType.encoding", "BASE64");
        }

        @Nullable
        public Object apply(@Nullable Object input) {
            if (input == null) {
                return null;
            }
            if (this.dataType == PTimestamp.INSTANCE) {
                return DateUtil.parseTimestamp(input.toString());
            }
            if (this.dateTimeParser != null && input instanceof String) {
                String s = (String)input;
                long epochTime = this.dateTimeParser.parseDateTime(s);
                byte[] byteValue = new byte[this.dataType.getByteSize().intValue()];
                this.dataType.getCodec().encodeLong(epochTime, byteValue, 0);
                return this.dataType.toObject(byteValue);
            }
            if (this.dataType == PBoolean.INSTANCE) {
                switch (input.toString()) {
                    case "true": 
                    case "t": 
                    case "T": 
                    case "1": {
                        return Boolean.TRUE;
                    }
                    case "false": 
                    case "f": 
                    case "F": 
                    case "0": {
                        return Boolean.FALSE;
                    }
                }
                throw new RuntimeException("Invalid boolean value: '" + input + "', must be one of ['true','t','1','false','f','0']");
            }
            if (this.dataType == PVarbinary.INSTANCE || this.dataType == PBinary.INSTANCE) {
                EncodeFormat format = EncodeFormat.valueOf(this.binaryEncoding.toUpperCase());
                byte[] object = null;
                switch (format) {
                    case BASE64: {
                        object = Base64.getDecoder().decode(input.toString());
                        if (object != null) break;
                        throw new IllegalDataException("Input: [" + input + "]  is not base64 encoded");
                    }
                    case ASCII: {
                        object = Bytes.toBytes((String)input.toString());
                        break;
                    }
                    default: {
                        throw new IllegalDataException("Unsupported encoding \"" + this.binaryEncoding + "\"");
                    }
                }
                return object;
            }
            return this.dataType.toObject(input, this.dataType);
        }
    }
}

