/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.util.Map;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.phoenix.compat.hbase.coprocessor.CompatIndexRegionObserver;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.hbase.index.IndexRegionObserver;

public class WALAnnotationUtil {
    public static void appendMutationAttributesToWALKey(WALKey key, IndexRegionObserver.BatchMutateContext context) {
        if (context != null && context.getOriginalMutations().size() > 0) {
            Mutation firstMutation = context.getOriginalMutations().get(0);
            Map attrMap = firstMutation.getAttributesMap();
            for (MutationState.MutationMetadataType metadataType : MutationState.MutationMetadataType.values()) {
                String metadataTypeKey = metadataType.toString();
                if (!attrMap.containsKey(metadataTypeKey)) continue;
                CompatIndexRegionObserver.appendToWALKey((WALKey)key, (String)metadataTypeKey, (byte[])((byte[])attrMap.get(metadataTypeKey)));
            }
        }
    }

    public static void annotateMutation(Mutation m, byte[] tenantId, byte[] schemaName, byte[] logicalTableName, byte[] tableType, byte[] ddlTimestamp) {
        if (!m.getDurability().equals((Object)Durability.SKIP_WAL)) {
            if (tenantId != null) {
                m.setAttribute(MutationState.MutationMetadataType.TENANT_ID.toString(), tenantId);
            }
            m.setAttribute(MutationState.MutationMetadataType.SCHEMA_NAME.toString(), schemaName);
            m.setAttribute(MutationState.MutationMetadataType.LOGICAL_TABLE_NAME.toString(), logicalTableName);
            m.setAttribute(MutationState.MutationMetadataType.TABLE_TYPE.toString(), tableType);
            m.setAttribute(MutationState.MutationMetadataType.TIMESTAMP.toString(), ddlTimestamp);
        }
    }
}

