/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.util.ArrayList;
import java.util.Comparator;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.util.PhoenixKeyValueUtil;

public class ResultUtil {
    public static final Result EMPTY_RESULT = new Result(){

        public final boolean isEmpty() {
            return true;
        }
    };
    public static final Comparator<Result> KEY_COMPARATOR = new Comparator<Result>(){

        @Override
        public int compare(Result r1, Result r2) {
            byte[] r1Bytes = ResultUtil.getRawBytes(r1);
            byte[] r2Bytes = ResultUtil.getRawBytes(r2);
            return Bytes.compareTo((byte[])r1Bytes, (int)ResultUtil.getKeyOffset(r1), (int)ResultUtil.getKeyLength(r1), (byte[])r2Bytes, (int)ResultUtil.getKeyOffset(r2), (int)ResultUtil.getKeyLength(r2));
        }
    };

    private ResultUtil() {
    }

    public static Result toResult(ImmutableBytesWritable bytes) {
        int keyLength;
        int offset;
        byte[] buf = bytes.get();
        int finalOffset = bytes.getLength() + offset;
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        for (offset = bytes.getOffset(); offset < finalOffset; offset += keyLength) {
            keyLength = Bytes.toInt((byte[])buf, (int)offset);
            kvs.add(new KeyValue(buf, offset += 4, keyLength));
        }
        return Result.create(kvs);
    }

    public static ImmutableBytesWritable getKey(Result r) {
        return ResultUtil.getKey(r, 0);
    }

    public static void getKey(Result r, ImmutableBytesWritable key) {
        key.set(r.getRow());
    }

    public static void getKey(Cell value, ImmutableBytesWritable key) {
        key.set(value.getRowArray(), value.getRowOffset(), (int)value.getRowLength());
    }

    public static ImmutableBytesWritable getKey(Result r, int offset) {
        return new ImmutableBytesWritable(ResultUtil.getRawBytes(r), ResultUtil.getKeyOffset(r) + offset, ResultUtil.getKeyLength(r) - offset);
    }

    public static void getKey(Result r, int offset, int length, ImmutableBytesWritable key) {
        key.set(ResultUtil.getRawBytes(r), ResultUtil.getKeyOffset(r) + offset, length);
    }

    static int getKeyOffset(Result r) {
        KeyValue firstKV = PhoenixKeyValueUtil.maybeCopyCell(r.rawCells()[0]);
        return firstKV.getOffset();
    }

    static int getKeyLength(Result r) {
        return Bytes.toShort((byte[])ResultUtil.getRawBytes(r), (int)(ResultUtil.getKeyOffset(r) - 2));
    }

    static byte[] getRawBytes(Result r) {
        KeyValue firstKV = PhoenixKeyValueUtil.maybeCopyCell(r.rawCells()[0]);
        return firstKV.getBuffer();
    }

    public static int compareKeys(Result r1, Result r2) {
        return Bytes.compareTo((byte[])ResultUtil.getRawBytes(r1), (int)ResultUtil.getKeyOffset(r1), (int)ResultUtil.getKeyLength(r1), (byte[])ResultUtil.getRawBytes(r2), (int)ResultUtil.getKeyOffset(r2), (int)ResultUtil.getKeyLength(r2));
    }
}

