/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import java.text.Format;
import java.util.Arrays;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.exception.DataExceedsCapacityException;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PBinary;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.base.Strings;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.StringUtil;

public class PChar
extends PDataType<String> {
    public static final PChar INSTANCE = new PChar();

    private PChar() {
        super("CHAR", 1, String.class, null, 1);
    }

    @Override
    public void pad(ImmutableBytesWritable ptr, Integer maxLength, SortOrder sortOrder) {
        if (ptr.getLength() >= maxLength) {
            return;
        }
        byte[] newBytes = new byte[maxLength.intValue()];
        System.arraycopy(ptr.get(), ptr.getOffset(), newBytes, 0, ptr.getLength());
        Arrays.fill(newBytes, ptr.getLength(), (int)maxLength, sortOrder == SortOrder.ASC ? (byte)32 : (byte)StringUtil.INVERTED_SPACE_UTF8);
        ptr.set(newBytes);
    }

    @Override
    public byte[] pad(byte[] b, Integer maxLength, SortOrder sortOrder) {
        if (b == null || b.length >= maxLength) {
            return b;
        }
        byte[] newBytes = new byte[maxLength.intValue()];
        System.arraycopy(b, 0, newBytes, 0, b.length);
        Arrays.fill(newBytes, b.length, (int)maxLength, sortOrder == SortOrder.ASC ? (byte)32 : (byte)StringUtil.INVERTED_SPACE_UTF8);
        return newBytes;
    }

    @Override
    public Object pad(Object object, Integer maxLength) {
        String s = (String)object;
        if (s == null) {
            return Strings.padEnd((String)"", (int)maxLength, (char)' ');
        }
        if (s.length() == maxLength.intValue()) {
            return object;
        }
        if (s.length() > maxLength) {
            throw new DataExceedsCapacityException(this, maxLength, null, null);
        }
        return Strings.padEnd((String)s, (int)maxLength, (char)' ');
    }

    @Override
    public byte[] toBytes(Object object) {
        if (object == null) {
            return ByteUtil.EMPTY_BYTE_ARRAY;
        }
        byte[] b = PVarchar.INSTANCE.toBytes(object);
        if (b.length != ((String)object).length()) {
            throw PChar.newIllegalDataException("CHAR types may only contain single byte characters.");
        }
        return b;
    }

    @Override
    public int toBytes(Object object, byte[] bytes, int offset) {
        if (object == null) {
            throw PChar.newIllegalDataException(this + " may not be null");
        }
        int len = PVarchar.INSTANCE.toBytes(object, bytes, offset);
        if (len != ((String)object).length()) {
            throw PChar.newIllegalDataException("CHAR types may only contain single byte characters.");
        }
        return len;
    }

    @Override
    public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
        String s;
        if (length == 0) {
            return null;
        }
        if (!actualType.isCoercibleTo(this)) {
            PChar.throwConstraintViolationException(actualType, this);
        }
        length = StringUtil.getUnpaddedCharLength(bytes, offset, length, sortOrder);
        if (sortOrder == SortOrder.DESC) {
            bytes = SortOrder.invert(bytes, offset, length);
            offset = 0;
        }
        if (length != (s = Bytes.toString((byte[])bytes, (int)offset, (int)length)).length()) {
            throw PChar.newIllegalDataException("CHAR types may only contain single byte characters.");
        }
        return s;
    }

    @Override
    public Object toObject(Object object, PDataType actualType) {
        if (PChar.equalsAny(actualType, PVarchar.INSTANCE, this)) {
            String s = (String)object;
            return s == null || s.length() > 0 ? s : null;
        }
        return PChar.throwConstraintViolationException(actualType, this);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType) {
        return PChar.equalsAny(targetType, this, PVarchar.INSTANCE, PBinary.INSTANCE, PVarbinary.INSTANCE);
    }

    @Override
    public void coerceBytes(ImmutableBytesWritable ptr, Object o, PDataType actualType, Integer actualMaxLength, Integer actualScale, SortOrder actualModifier, Integer desiredMaxLength, Integer desiredScale, SortOrder expectedModifier) {
        if (o != null && actualType.equals(PVarchar.INSTANCE) && ((String)o).length() != ptr.getLength()) {
            throw PChar.newIllegalDataException("CHAR types may only contain single byte characters.");
        }
        super.coerceBytes(ptr, o, actualType, actualMaxLength, actualScale, actualModifier, desiredMaxLength, desiredScale, expectedModifier);
        if (ptr.getLength() > 0 && desiredMaxLength != null && desiredMaxLength > ptr.getLength()) {
            this.pad(ptr, desiredMaxLength, expectedModifier);
        }
    }

    @Override
    public boolean isSizeCompatible(ImmutableBytesWritable ptr, Object value, PDataType srcType, SortOrder sortOrder, Integer maxLength, Integer scale, Integer desiredMaxLength, Integer desiredScale) {
        if (ptr.getLength() != 0 && desiredMaxLength != null) {
            if (maxLength == null) {
                if (value != null && srcType == INSTANCE) {
                    maxLength = ((String)value).length();
                } else {
                    this.coerceBytes(ptr, value, srcType, maxLength, scale, sortOrder, desiredMaxLength, desiredScale, sortOrder, true);
                    maxLength = ptr.getLength();
                }
            }
            return maxLength <= desiredMaxLength;
        }
        return true;
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public Integer getByteSize() {
        return null;
    }

    @Override
    public Integer getMaxLength(Object o) {
        if (o == null) {
            return null;
        }
        String value = (String)o;
        return value.length();
    }

    @Override
    public int estimateByteSize(Object o) {
        String value = (String)o;
        return value.length();
    }

    @Override
    public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
        return PVarchar.INSTANCE.compareTo(lhs, rhs, rhsType);
    }

    @Override
    public Object toObject(String value) {
        if (StringUtil.hasMultiByteChars(value)) {
            throw PChar.newIllegalDataException("CHAR types may only contain single byte characters.");
        }
        return value;
    }

    @Override
    public Integer estimateByteSizeFromLength(Integer length) {
        return length;
    }

    @Override
    public boolean isBytesComparableWith(PDataType otherType) {
        return super.isBytesComparableWith(otherType) || otherType.equals(PVarchar.INSTANCE);
    }

    @Override
    public String toStringLiteral(byte[] b, int offset, int length, Format formatter) {
        return PVarchar.INSTANCE.toStringLiteral(b, offset, length, formatter);
    }

    @Override
    public String toStringLiteral(Object o, Format formatter) {
        return PVarchar.INSTANCE.toStringLiteral(o, formatter);
    }

    @Override
    public Object getSampleValue(Integer maxLength, Integer arrayLength) {
        return PVarchar.INSTANCE.getSampleValue(maxLength, arrayLength);
    }
}

