/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.stats;

import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.ServiceException;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.MultiRowMutationProtos;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.stats.GuidePostsInfo;
import org.apache.phoenix.schema.stats.StatisticsCollector;
import org.apache.phoenix.schema.stats.StatisticsUtil;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.PrefixByteDecoder;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.ServerUtil;

public class StatisticsWriter
implements Closeable {
    private final Table statsWriterTable;
    private final Table statsReaderTable;
    private final byte[] tableName;
    private final long clientTimeStamp;

    public static StatisticsWriter newWriter(PhoenixConnection conn, String tableName, long clientTimeStamp) throws SQLException {
        Configuration configuration = conn.getQueryServices().getConfiguration();
        long newClientTimeStamp = StatisticsWriter.determineClientTimeStamp(configuration, clientTimeStamp);
        TableName physicalTableName = SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_STATS_NAME_BYTES, configuration);
        Table statsWriterTable = conn.getQueryServices().getTable(physicalTableName.getName());
        Table statsReaderTable = conn.getQueryServices().getTable(physicalTableName.getName());
        StatisticsWriter statsTable = new StatisticsWriter(statsReaderTable, statsWriterTable, tableName, newClientTimeStamp);
        return statsTable;
    }

    public static StatisticsWriter newWriter(RegionCoprocessorEnvironment env, String tableName, long clientTimeStamp) throws IOException {
        Configuration configuration = env.getConfiguration();
        long newClientTimeStamp = StatisticsWriter.determineClientTimeStamp(configuration, clientTimeStamp);
        Table statsWriterTable = ServerUtil.ConnectionFactory.getConnection(ServerUtil.ConnectionType.DEFAULT_SERVER_CONNECTION, env).getTable(SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_STATS_NAME_BYTES, env.getConfiguration()));
        Table statsReaderTable = ServerUtil.getHTableForCoprocessorScan(env, statsWriterTable);
        StatisticsWriter statsTable = new StatisticsWriter(statsReaderTable, statsWriterTable, tableName, newClientTimeStamp);
        return statsTable;
    }

    private static long determineClientTimeStamp(Configuration configuration, long clientTimeStamp) {
        boolean useCurrentTime = configuration.getBoolean("phoenix.stats.useCurrentTime", true);
        if (!useCurrentTime) {
            clientTimeStamp = -1L;
        }
        if (clientTimeStamp == Long.MAX_VALUE) {
            clientTimeStamp = EnvironmentEdgeManager.currentTimeMillis();
        }
        return clientTimeStamp;
    }

    private StatisticsWriter(Table statsReaderTable, Table statsWriterTable, String tableName, long clientTimeStamp) {
        this.statsReaderTable = statsReaderTable;
        this.statsWriterTable = statsWriterTable;
        this.tableName = Bytes.toBytes((String)tableName);
        this.clientTimeStamp = clientTimeStamp;
    }

    @Override
    public void close() throws IOException {
        this.statsWriterTable.close();
        this.statsReaderTable.close();
    }

    public void addStats(StatisticsCollector tracker, ImmutableBytesPtr cfKey, List<Mutation> mutations, long guidePostDepth) throws IOException {
        GuidePostsInfo gps;
        if (tracker == null) {
            return;
        }
        boolean useMaxTimeStamp = this.clientTimeStamp == -1L;
        long timeStamp = this.clientTimeStamp;
        if (useMaxTimeStamp) {
            timeStamp = tracker.getMaxTimeStamp();
            mutations.add((Mutation)this.getLastStatsUpdatedTimePut(timeStamp));
        }
        if ((gps = tracker.getGuidePosts(cfKey)) != null) {
            boolean hasGuidePosts;
            long[] byteCounts = gps.getByteCounts();
            long[] rowCounts = gps.getRowCounts();
            ImmutableBytesWritable keys = gps.getGuidePosts();
            boolean bl = hasGuidePosts = keys.getLength() > 0;
            if (hasGuidePosts) {
                int guidePostCount = 0;
                try (ByteArrayInputStream stream2 = new ByteArrayInputStream(keys.get(), keys.getOffset(), keys.getLength());){
                    DataInputStream input = new DataInputStream(stream2);
                    PrefixByteDecoder decoder = new PrefixByteDecoder(gps.getMaxLength());
                    do {
                        ImmutableBytesWritable ptr = decoder.decode(input);
                        this.addGuidepost(cfKey, mutations, ptr, byteCounts[guidePostCount], rowCounts[guidePostCount], timeStamp);
                        ++guidePostCount;
                    } while (decoder != null);
                }
                catch (EOFException stream2) {
                    // empty catch block
                }
                byte[] rowKey = StatisticsUtil.getRowKey(this.tableName, (ImmutableBytesWritable)cfKey, ByteUtil.EMPTY_IMMUTABLE_BYTE_ARRAY);
                Delete delete = new Delete(rowKey, timeStamp);
                mutations.add((Mutation)delete);
            } else {
                this.addGuidepost(cfKey, mutations, ByteUtil.EMPTY_IMMUTABLE_BYTE_ARRAY, guidePostDepth, 0L, timeStamp);
            }
        }
    }

    private void addGuidepost(ImmutableBytesPtr cfKey, List<Mutation> mutations, ImmutableBytesWritable ptr, long byteCount, long rowCount, long timeStamp) {
        byte[] prefix = StatisticsUtil.getRowKey(this.tableName, (ImmutableBytesWritable)cfKey, ptr);
        Put put = new Put(prefix);
        put.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, PhoenixDatabaseMetaData.GUIDE_POSTS_WIDTH_BYTES, timeStamp, PLong.INSTANCE.toBytes(byteCount));
        put.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, PhoenixDatabaseMetaData.GUIDE_POSTS_ROW_COUNT_BYTES, timeStamp, PLong.INSTANCE.toBytes(rowCount));
        put.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, QueryConstants.EMPTY_COLUMN_BYTES, timeStamp, ByteUtil.EMPTY_BYTE_ARRAY);
        mutations.add((Mutation)put);
    }

    private static ClientProtos.MutationProto.MutationType getMutationType(Mutation m) throws IOException {
        if (m instanceof Put) {
            return ClientProtos.MutationProto.MutationType.PUT;
        }
        if (m instanceof Delete) {
            return ClientProtos.MutationProto.MutationType.DELETE;
        }
        throw new DoNotRetryIOException("Unsupported mutation type in stats commit" + m.getClass().getName());
    }

    public void commitStats(final List<Mutation> mutations, final StatisticsCollector statsCollector) throws IOException {
        User.runAsLoginUser((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                StatisticsWriter.this.commitLastStatsUpdatedTime(statsCollector);
                if (mutations.size() > 0) {
                    byte[] row = ((Mutation)mutations.get(0)).getRow();
                    MultiRowMutationProtos.MutateRowsRequest.Builder mrmBuilder = MultiRowMutationProtos.MutateRowsRequest.newBuilder();
                    for (Mutation m : mutations) {
                        mrmBuilder.addMutationRequest(ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)StatisticsWriter.getMutationType(m), (Mutation)m));
                    }
                    MultiRowMutationProtos.MutateRowsRequest mrm = mrmBuilder.build();
                    CoprocessorRpcChannel channel = StatisticsWriter.this.statsWriterTable.coprocessorService(row);
                    MultiRowMutationProtos.MultiRowMutationService.BlockingInterface service = MultiRowMutationProtos.MultiRowMutationService.newBlockingStub((BlockingRpcChannel)channel);
                    try {
                        service.mutateRows(null, mrm);
                    }
                    catch (ServiceException ex) {
                        ProtobufUtil.toIOException((ServiceException)ex);
                    }
                }
                return null;
            }
        });
    }

    private Put getLastStatsUpdatedTimePut(long timeStamp) {
        long currentTime = EnvironmentEdgeManager.currentTimeMillis();
        byte[] prefix = this.tableName;
        Put put = new Put(prefix);
        put.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, PhoenixDatabaseMetaData.LAST_STATS_UPDATE_TIME_BYTES, timeStamp, PDate.INSTANCE.toBytes(new Date(currentTime)));
        return put;
    }

    private void commitLastStatsUpdatedTime(StatisticsCollector statsCollector) throws IOException {
        long timeStamp = this.clientTimeStamp == -1L ? statsCollector.getMaxTimeStamp() : this.clientTimeStamp;
        Put put = this.getLastStatsUpdatedTimePut(timeStamp);
        this.statsWriterTable.put(put);
    }

    public void deleteStatsForRegion(Region region, StatisticsCollector tracker, ImmutableBytesPtr fam, List<Mutation> mutations) throws IOException {
        long timeStamp = this.clientTimeStamp == -1L ? tracker.getMaxTimeStamp() : this.clientTimeStamp;
        byte[] startKey = region.getRegionInfo().getStartKey();
        byte[] stopKey = region.getRegionInfo().getEndKey();
        ArrayList<Result> statsForRegion = new ArrayList<Result>();
        Scan s = MetaDataUtil.newTableRowsScan(StatisticsUtil.getAdjustedKey(startKey, this.tableName, fam, false), StatisticsUtil.getAdjustedKey(stopKey, this.tableName, fam, true), 0L, this.clientTimeStamp);
        s.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, QueryConstants.EMPTY_COLUMN_BYTES);
        try (ResultScanner scanner = this.statsWriterTable.getScanner(s);){
            Result result = null;
            while ((result = scanner.next()) != null) {
                statsForRegion.add(result);
            }
        }
        for (Result result : statsForRegion) {
            mutations.add((Mutation)new Delete(result.getRow(), timeStamp - 1L));
        }
    }
}

