/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.parse.ShowStatement;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;

public class ShowTablesStatement
extends ShowStatement {
    @Nullable
    private String targetSchema;
    @Nullable
    private String dbPattern;

    public ShowTablesStatement() {
        this(null, null);
    }

    public ShowTablesStatement(@Nullable String schema, @Nullable String pattern) {
        this.targetSchema = schema;
        this.dbPattern = pattern;
    }

    @Nullable
    public String getTargetSchema() {
        return this.targetSchema;
    }

    @Nullable
    public String getDbPattern() {
        return this.dbPattern;
    }

    public void toSQL(ColumnResolver resolver, StringBuilder buf) {
        Preconditions.checkNotNull((Object)buf);
        buf.append("SHOW TABLES");
        if (this.targetSchema != null) {
            buf.append(" IN ");
            buf.append(this.targetSchema);
            buf.append(" ");
        }
        if (this.dbPattern != null) {
            buf.append(" LIKE ");
            buf.append("'").append(this.dbPattern).append("'");
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.toSQL(null, buf);
        return buf.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof ShowTablesStatement)) {
            return false;
        }
        ShowTablesStatement stmt = (ShowTablesStatement)other;
        return Objects.equals(this.targetSchema, stmt.getTargetSchema()) && Objects.equals(this.dbPattern, stmt.getDbPattern());
    }

    public int hashCode() {
        return Objects.hash(this.targetSchema, this.dbPattern);
    }
}

