/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.index;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.coprocessor.IndexToolVerificationResult;
import org.apache.phoenix.hbase.index.table.HTableFactory;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.mapreduce.index.IndexTool;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.util.ByteUtil;

public class IndexVerificationResultRepository
implements AutoCloseable {
    public static final String RUN_STATUS_SKIPPED = "Skipped";
    public static final String RUN_STATUS_EXECUTED = "Executed";
    private Table resultTable;
    private Table indexTable;
    public static final String ROW_KEY_SEPARATOR = "|";
    public static final byte[] ROW_KEY_SEPARATOR_BYTE = Bytes.toBytes((String)"|");
    public static final String RESULT_TABLE_NAME = "PHOENIX_INDEX_TOOL_RESULT";
    public static final byte[] RESULT_TABLE_NAME_BYTES = Bytes.toBytes((String)"PHOENIX_INDEX_TOOL_RESULT");
    public static final byte[] RESULT_TABLE_COLUMN_FAMILY = QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES;
    public static final String SCANNED_DATA_ROW_COUNT = "ScannedDataRowCount";
    public static final byte[] SCANNED_DATA_ROW_COUNT_BYTES = Bytes.toBytes((String)"ScannedDataRowCount");
    public static final String REBUILT_INDEX_ROW_COUNT = "RebuiltIndexRowCount";
    public static final byte[] REBUILT_INDEX_ROW_COUNT_BYTES = Bytes.toBytes((String)"RebuiltIndexRowCount");
    public static final String BEFORE_REBUILD_VALID_INDEX_ROW_COUNT = "BeforeRebuildValidIndexRowCount";
    public static final byte[] BEFORE_REBUILD_VALID_INDEX_ROW_COUNT_BYTES = Bytes.toBytes((String)"BeforeRebuildValidIndexRowCount");
    private static final String INDEX_TOOL_RUN_STATUS = "IndexToolRunStatus";
    public static final byte[] INDEX_TOOL_RUN_STATUS_BYTES = Bytes.toBytes((String)"IndexToolRunStatus");
    public static final String BEFORE_REBUILD_EXPIRED_INDEX_ROW_COUNT = "BeforeRebuildExpiredIndexRowCount";
    public static final byte[] BEFORE_REBUILD_EXPIRED_INDEX_ROW_COUNT_BYTES = Bytes.toBytes((String)"BeforeRebuildExpiredIndexRowCount");
    public static final String BEFORE_REBUILD_MISSING_INDEX_ROW_COUNT = "BeforeRebuildMissingIndexRowCount";
    public static final byte[] BEFORE_REBUILD_MISSING_INDEX_ROW_COUNT_BYTES = Bytes.toBytes((String)"BeforeRebuildMissingIndexRowCount");
    public static final String BEFORE_REBUILD_INVALID_INDEX_ROW_COUNT = "BeforeRebuildInvalidIndexRowCount";
    public static final byte[] BEFORE_REBUILD_INVALID_INDEX_ROW_COUNT_BYTES = Bytes.toBytes((String)"BeforeRebuildInvalidIndexRowCount");
    public static final String BEFORE_REBUILD_UNVERIFIED_INDEX_ROW_COUNT = "BeforeRebuildUnverifiedIndexRowCount";
    public static final byte[] BEFORE_REBUILD_UNVERIFIED_INDEX_ROW_COUNT_BYTES = Bytes.toBytes((String)"BeforeRebuildUnverifiedIndexRowCount");
    public static final String BEFORE_REBUILD_OLD_INDEX_ROW_COUNT = "BeforeRebuildOldIndexRowCount";
    public static final byte[] BEFORE_REBUILD_OLD_INDEX_ROW_COUNT_BYTES = Bytes.toBytes((String)"BeforeRebuildOldIndexRowCount");
    public static final String BEFORE_REBUILD_UNKNOWN_INDEX_ROW_COUNT = "BeforeRebuildUnknownIndexRowCount";
    public static final byte[] BEFORE_REBUILD_UNKNOWN_INDEX_ROW_COUNT_BYTES = Bytes.toBytes((String)"BeforeRebuildUnknownIndexRowCount");
    public static final String AFTER_REBUILD_VALID_INDEX_ROW_COUNT = "AfterRebuildValidIndexRowCount";
    public static final byte[] AFTER_REBUILD_VALID_INDEX_ROW_COUNT_BYTES = Bytes.toBytes((String)"AfterRebuildValidIndexRowCount");
    public static final String AFTER_REBUILD_EXPIRED_INDEX_ROW_COUNT = "AfterRebuildExpiredIndexRowCount";
    public static final byte[] AFTER_REBUILD_EXPIRED_INDEX_ROW_COUNT_BYTES = Bytes.toBytes((String)"AfterRebuildExpiredIndexRowCount");
    public static final String AFTER_REBUILD_MISSING_INDEX_ROW_COUNT = "AfterRebuildMissingIndexRowCount";
    public static final byte[] AFTER_REBUILD_MISSING_INDEX_ROW_COUNT_BYTES = Bytes.toBytes((String)"AfterRebuildMissingIndexRowCount");
    public static final String AFTER_REBUILD_INVALID_INDEX_ROW_COUNT = "AfterRebuildInvalidIndexRowCount";
    public static final byte[] AFTER_REBUILD_INVALID_INDEX_ROW_COUNT_BYTES = Bytes.toBytes((String)"AfterRebuildInvalidIndexRowCount");
    public static final String BEFORE_REBUILD_BEYOND_MAXLOOKBACK_MISSING_INDEX_ROW_COUNT = "BeforeRebuildBeyondMaxLookBackMissingIndexRowCount";
    public static final byte[] BEFORE_REBUILD_BEYOND_MAXLOOKBACK_MISSING_INDEX_ROW_COUNT_BYTES = Bytes.toBytes((String)"BeforeRebuildBeyondMaxLookBackMissingIndexRowCount");
    public static final String BEFORE_REBUILD_BEYOND_MAXLOOKBACK_INVALID_INDEX_ROW_COUNT = "BeforeRebuildBeyondMaxLookBackInvalidIndexRowCount";
    public static final byte[] BEFORE_REBUILD_BEYOND_MAXLOOKBACK_INVALID_INDEX_ROW_COUNT_BYTES = Bytes.toBytes((String)"BeforeRebuildBeyondMaxLookBackInvalidIndexRowCount");
    public static final String AFTER_REBUILD_BEYOND_MAXLOOKBACK_MISSING_INDEX_ROW_COUNT = "AfterRebuildBeyondMaxLookBackMissingIndexRowCount";
    public static final byte[] AFTER_REBUILD_BEYOND_MAXLOOKBACK_MISSING_INDEX_ROW_COUNT_BYTES = Bytes.toBytes((String)"AfterRebuildBeyondMaxLookBackMissingIndexRowCount");
    public static final String AFTER_REBUILD_BEYOND_MAXLOOKBACK_INVALID_INDEX_ROW_COUNT = "AfterRebuildBeyondMaxLookBackInvalidIndexRowCount";
    public static final byte[] AFTER_REBUILD_BEYOND_MAXLOOKBACK_INVALID_INDEX_ROW_COUNT_BYTES = Bytes.toBytes((String)"AfterRebuildBeyondMaxLookBackInvalidIndexRowCount");
    public static String BEFORE_REBUILD_INVALID_INDEX_ROW_COUNT_COZ_EXTRA_CELLS = "BeforeRebuildInvalidIndexRowCountCozExtraCells";
    public static final byte[] BEFORE_REBUILD_INVALID_INDEX_ROW_COUNT_COZ_EXTRA_CELLS_BYTES = Bytes.toBytes((String)BEFORE_REBUILD_INVALID_INDEX_ROW_COUNT_COZ_EXTRA_CELLS);
    public static String BEFORE_REBUILD_INVALID_INDEX_ROW_COUNT_COZ_MISSING_CELLS = "BeforeRebuildInvalidIndexRowCountCozMissingCells";
    public static final byte[] BEFORE_REBUILD_INVALID_INDEX_ROW_COUNT_COZ_MISSING_CELLS_BYTES = Bytes.toBytes((String)BEFORE_REBUILD_INVALID_INDEX_ROW_COUNT_COZ_MISSING_CELLS);
    public static String AFTER_REBUILD_INVALID_INDEX_ROW_COUNT_COZ_EXTRA_CELLS = "AfterRebuildInvalidIndexRowCountCozExtraCells";
    public static final byte[] AFTER_REBUILD_INVALID_INDEX_ROW_COUNT_COZ_EXTRA_CELLS_BYTES = Bytes.toBytes((String)AFTER_REBUILD_INVALID_INDEX_ROW_COUNT_COZ_EXTRA_CELLS);
    public static String AFTER_REBUILD_INVALID_INDEX_ROW_COUNT_COZ_MISSING_CELLS = "AfterRebuildInvalidIndexRowCountCozMissingCells";
    public static final byte[] AFTER_REBUILD_INVALID_INDEX_ROW_COUNT_COZ_MISSING_CELLS_BYTES = Bytes.toBytes((String)AFTER_REBUILD_INVALID_INDEX_ROW_COUNT_COZ_MISSING_CELLS);
    public static final String BEFORE_REPAIR_EXTRA_VERIFIED_INDEX_ROW_COUNT = "BeforeRepairExtraVerifiedIndexRowCount";
    public static final byte[] BEFORE_REPAIR_EXTRA_VERIFIED_INDEX_ROW_COUNT_BYTES = Bytes.toBytes((String)"BeforeRepairExtraVerifiedIndexRowCount");
    public static final String BEFORE_REPAIR_EXTRA_UNVERIFIED_INDEX_ROW_COUNT = "BeforeRepairExtraUnverifiedIndexRowCount";
    public static final byte[] BEFORE_REPAIR_EXTRA_UNVERIFIED_INDEX_ROW_COUNT_BYTES = Bytes.toBytes((String)"BeforeRepairExtraUnverifiedIndexRowCount");
    public static final String AFTER_REPAIR_EXTRA_VERIFIED_INDEX_ROW_COUNT = "AfterRepairExtraVerifiedIndexRowCount";
    public static final byte[] AFTER_REPAIR_EXTRA_VERIFIED_INDEX_ROW_COUNT_BYTES = Bytes.toBytes((String)"AfterRepairExtraVerifiedIndexRowCount");
    public static final String AFTER_REPAIR_EXTRA_UNVERIFIED_INDEX_ROW_COUNT = "AfterRepairExtraUnverifiedIndexRowCount";
    public static final byte[] AFTER_REPAIR_EXTRA_UNVERIFIED_INDEX_ROW_COUNT_BYTES = Bytes.toBytes((String)"AfterRepairExtraUnverifiedIndexRowCount");

    public IndexVerificationResultRepository() {
    }

    public IndexVerificationResultRepository(Connection conn, byte[] indexNameBytes) throws SQLException {
        this.resultTable = this.getTable(conn, RESULT_TABLE_NAME_BYTES);
        this.indexTable = this.getTable(conn, indexNameBytes);
    }

    public IndexVerificationResultRepository(byte[] indexName, HTableFactory hTableFactory) throws IOException {
        this.resultTable = hTableFactory.getTable(new ImmutableBytesPtr(RESULT_TABLE_NAME_BYTES));
        this.indexTable = hTableFactory.getTable(new ImmutableBytesPtr(indexName));
    }

    public void createResultTable(Connection connection) throws IOException, SQLException {
        ConnectionQueryServices queryServices = connection.unwrap(PhoenixConnection.class).getQueryServices();
        try (Admin admin = queryServices.getAdmin();){
            TableName resultTableName = TableName.valueOf((String)RESULT_TABLE_NAME);
            if (!admin.tableExists(resultTableName)) {
                ColumnFamilyDescriptor columnDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])RESULT_TABLE_COLUMN_FAMILY).setTimeToLive(604800).build();
                TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)resultTableName).setColumnFamily(columnDescriptor).build();
                admin.createTable(tableDescriptor);
                this.resultTable = admin.getConnection().getTable(resultTableName);
            }
        }
    }

    private static byte[] generatePartialResultTableRowKey(long ts, byte[] indexTableName) {
        byte[] keyPrefix = Bytes.toBytes((String)Long.toString(ts));
        int targetOffset = 0;
        byte[] partialRowKey = new byte[keyPrefix.length + ROW_KEY_SEPARATOR_BYTE.length + indexTableName.length];
        Bytes.putBytes((byte[])partialRowKey, (int)targetOffset, (byte[])keyPrefix, (int)0, (int)keyPrefix.length);
        Bytes.putBytes((byte[])partialRowKey, (int)(targetOffset += keyPrefix.length), (byte[])ROW_KEY_SEPARATOR_BYTE, (int)0, (int)ROW_KEY_SEPARATOR_BYTE.length);
        Bytes.putBytes((byte[])partialRowKey, (int)(targetOffset += ROW_KEY_SEPARATOR_BYTE.length), (byte[])indexTableName, (int)0, (int)indexTableName.length);
        return partialRowKey;
    }

    private static byte[] generateResultTableRowKey(long ts, byte[] indexTableName, byte[] regionName, byte[] startRow, byte[] stopRow) {
        byte[] keyPrefix = Bytes.toBytes((String)Long.toString(ts));
        int targetOffset = 0;
        byte[] rowKey = new byte[keyPrefix.length + ROW_KEY_SEPARATOR_BYTE.length + indexTableName.length + ROW_KEY_SEPARATOR_BYTE.length + regionName.length + ROW_KEY_SEPARATOR_BYTE.length + startRow.length + ROW_KEY_SEPARATOR_BYTE.length + stopRow.length];
        Bytes.putBytes((byte[])rowKey, (int)targetOffset, (byte[])keyPrefix, (int)0, (int)keyPrefix.length);
        Bytes.putBytes((byte[])rowKey, (int)(targetOffset += keyPrefix.length), (byte[])ROW_KEY_SEPARATOR_BYTE, (int)0, (int)ROW_KEY_SEPARATOR_BYTE.length);
        Bytes.putBytes((byte[])rowKey, (int)(targetOffset += ROW_KEY_SEPARATOR_BYTE.length), (byte[])indexTableName, (int)0, (int)indexTableName.length);
        Bytes.putBytes((byte[])rowKey, (int)(targetOffset += indexTableName.length), (byte[])ROW_KEY_SEPARATOR_BYTE, (int)0, (int)ROW_KEY_SEPARATOR_BYTE.length);
        Bytes.putBytes((byte[])rowKey, (int)(targetOffset += ROW_KEY_SEPARATOR_BYTE.length), (byte[])regionName, (int)0, (int)regionName.length);
        Bytes.putBytes((byte[])rowKey, (int)(targetOffset += regionName.length), (byte[])ROW_KEY_SEPARATOR_BYTE, (int)0, (int)ROW_KEY_SEPARATOR_BYTE.length);
        Bytes.putBytes((byte[])rowKey, (int)(targetOffset += ROW_KEY_SEPARATOR_BYTE.length), (byte[])startRow, (int)0, (int)startRow.length);
        Bytes.putBytes((byte[])rowKey, (int)(targetOffset += startRow.length), (byte[])ROW_KEY_SEPARATOR_BYTE, (int)0, (int)ROW_KEY_SEPARATOR_BYTE.length);
        Bytes.putBytes((byte[])rowKey, (int)(targetOffset += ROW_KEY_SEPARATOR_BYTE.length), (byte[])stopRow, (int)0, (int)stopRow.length);
        return rowKey;
    }

    public void logToIndexToolResultTable(IndexToolVerificationResult verificationResult, IndexTool.IndexVerifyType verifyType, byte[] region) throws IOException {
        this.logToIndexToolResultTable(verificationResult, verifyType, region, false);
    }

    public void logToIndexToolResultTable(IndexToolVerificationResult verificationResult, IndexTool.IndexVerifyType verifyType, byte[] region, boolean skipped) throws IOException {
        long scanMaxTs = verificationResult.getScanMaxTs();
        byte[] rowKey = IndexVerificationResultRepository.generateResultTableRowKey(scanMaxTs, this.indexTable.getName().toBytes(), region, verificationResult.getStartRow(), verificationResult.getStopRow());
        Put put = new Put(rowKey);
        put.addColumn(RESULT_TABLE_COLUMN_FAMILY, SCANNED_DATA_ROW_COUNT_BYTES, Bytes.toBytes((String)Long.toString(verificationResult.getScannedDataRowCount())));
        put.addColumn(RESULT_TABLE_COLUMN_FAMILY, REBUILT_INDEX_ROW_COUNT_BYTES, Bytes.toBytes((String)Long.toString(verificationResult.getRebuiltIndexRowCount())));
        put.addColumn(RESULT_TABLE_COLUMN_FAMILY, INDEX_TOOL_RUN_STATUS_BYTES, Bytes.toBytes((String)(skipped ? RUN_STATUS_SKIPPED : RUN_STATUS_EXECUTED)));
        if (verifyType == IndexTool.IndexVerifyType.BEFORE || verifyType == IndexTool.IndexVerifyType.BOTH || verifyType == IndexTool.IndexVerifyType.ONLY) {
            put.addColumn(RESULT_TABLE_COLUMN_FAMILY, BEFORE_REBUILD_VALID_INDEX_ROW_COUNT_BYTES, Bytes.toBytes((String)Long.toString(verificationResult.getBeforeRebuildValidIndexRowCount())));
            put.addColumn(RESULT_TABLE_COLUMN_FAMILY, BEFORE_REBUILD_EXPIRED_INDEX_ROW_COUNT_BYTES, Bytes.toBytes((String)Long.toString(verificationResult.getBeforeRebuildExpiredIndexRowCount())));
            put.addColumn(RESULT_TABLE_COLUMN_FAMILY, BEFORE_REBUILD_MISSING_INDEX_ROW_COUNT_BYTES, Bytes.toBytes((String)Long.toString(verificationResult.getBeforeRebuildMissingIndexRowCount())));
            put.addColumn(RESULT_TABLE_COLUMN_FAMILY, BEFORE_REBUILD_INVALID_INDEX_ROW_COUNT_BYTES, Bytes.toBytes((String)Long.toString(verificationResult.getBeforeRebuildInvalidIndexRowCount())));
            put.addColumn(RESULT_TABLE_COLUMN_FAMILY, BEFORE_REBUILD_BEYOND_MAXLOOKBACK_MISSING_INDEX_ROW_COUNT_BYTES, Bytes.toBytes((String)Long.toString(verificationResult.getBefore().getBeyondMaxLookBackMissingIndexRowCount())));
            put.addColumn(RESULT_TABLE_COLUMN_FAMILY, BEFORE_REBUILD_BEYOND_MAXLOOKBACK_INVALID_INDEX_ROW_COUNT_BYTES, Bytes.toBytes((String)Long.toString(verificationResult.getBefore().getBeyondMaxLookBackInvalidIndexRowCount())));
            put.addColumn(RESULT_TABLE_COLUMN_FAMILY, BEFORE_REBUILD_INVALID_INDEX_ROW_COUNT_COZ_EXTRA_CELLS_BYTES, Bytes.toBytes((String)Long.toString(verificationResult.getBeforeIndexHasExtraCellsCount())));
            put.addColumn(RESULT_TABLE_COLUMN_FAMILY, BEFORE_REBUILD_INVALID_INDEX_ROW_COUNT_COZ_MISSING_CELLS_BYTES, Bytes.toBytes((String)Long.toString(verificationResult.getBeforeIndexHasMissingCellsCount())));
            put.addColumn(RESULT_TABLE_COLUMN_FAMILY, BEFORE_REBUILD_UNVERIFIED_INDEX_ROW_COUNT_BYTES, Bytes.toBytes((String)Long.toString(verificationResult.getBeforeRebuildUnverifiedIndexRowCount())));
            put.addColumn(RESULT_TABLE_COLUMN_FAMILY, BEFORE_REBUILD_OLD_INDEX_ROW_COUNT_BYTES, Bytes.toBytes((String)Long.toString(verificationResult.getBeforeRebuildOldIndexRowCount())));
            put.addColumn(RESULT_TABLE_COLUMN_FAMILY, BEFORE_REBUILD_UNKNOWN_INDEX_ROW_COUNT_BYTES, Bytes.toBytes((String)Long.toString(verificationResult.getBeforeRebuildUnknownIndexRowCount())));
            put.addColumn(RESULT_TABLE_COLUMN_FAMILY, BEFORE_REPAIR_EXTRA_VERIFIED_INDEX_ROW_COUNT_BYTES, Bytes.toBytes((String)Long.toString(verificationResult.getBeforeRepairExtraVerifiedIndexRowCount())));
            put.addColumn(RESULT_TABLE_COLUMN_FAMILY, BEFORE_REPAIR_EXTRA_UNVERIFIED_INDEX_ROW_COUNT_BYTES, Bytes.toBytes((String)Long.toString(verificationResult.getBeforeRepairExtraUnverifiedIndexRowCount())));
        }
        if (verifyType == IndexTool.IndexVerifyType.AFTER || verifyType == IndexTool.IndexVerifyType.BOTH) {
            put.addColumn(RESULT_TABLE_COLUMN_FAMILY, AFTER_REBUILD_VALID_INDEX_ROW_COUNT_BYTES, Bytes.toBytes((String)Long.toString(verificationResult.getAfterRebuildValidIndexRowCount())));
            put.addColumn(RESULT_TABLE_COLUMN_FAMILY, AFTER_REBUILD_EXPIRED_INDEX_ROW_COUNT_BYTES, Bytes.toBytes((String)Long.toString(verificationResult.getAfterRebuildExpiredIndexRowCount())));
            put.addColumn(RESULT_TABLE_COLUMN_FAMILY, AFTER_REBUILD_MISSING_INDEX_ROW_COUNT_BYTES, Bytes.toBytes((String)Long.toString(verificationResult.getAfterRebuildMissingIndexRowCount())));
            put.addColumn(RESULT_TABLE_COLUMN_FAMILY, AFTER_REBUILD_INVALID_INDEX_ROW_COUNT_BYTES, Bytes.toBytes((String)Long.toString(verificationResult.getAfterRebuildInvalidIndexRowCount())));
            put.addColumn(RESULT_TABLE_COLUMN_FAMILY, AFTER_REBUILD_BEYOND_MAXLOOKBACK_MISSING_INDEX_ROW_COUNT_BYTES, Bytes.toBytes((String)Long.toString(verificationResult.getAfter().getBeyondMaxLookBackMissingIndexRowCount())));
            put.addColumn(RESULT_TABLE_COLUMN_FAMILY, AFTER_REBUILD_BEYOND_MAXLOOKBACK_INVALID_INDEX_ROW_COUNT_BYTES, Bytes.toBytes((String)Long.toString(verificationResult.getAfter().getBeyondMaxLookBackInvalidIndexRowCount())));
            put.addColumn(RESULT_TABLE_COLUMN_FAMILY, AFTER_REBUILD_INVALID_INDEX_ROW_COUNT_COZ_EXTRA_CELLS_BYTES, Bytes.toBytes((String)Long.toString(verificationResult.getAfterIndexHasExtraCellsCount())));
            put.addColumn(RESULT_TABLE_COLUMN_FAMILY, AFTER_REBUILD_INVALID_INDEX_ROW_COUNT_COZ_MISSING_CELLS_BYTES, Bytes.toBytes((String)Long.toString(verificationResult.getAfterIndexHasMissingCellsCount())));
            put.addColumn(RESULT_TABLE_COLUMN_FAMILY, AFTER_REPAIR_EXTRA_VERIFIED_INDEX_ROW_COUNT_BYTES, Bytes.toBytes((String)Long.toString(verificationResult.getAfterRepairExtraVerifiedIndexRowCount())));
            put.addColumn(RESULT_TABLE_COLUMN_FAMILY, AFTER_REPAIR_EXTRA_UNVERIFIED_INDEX_ROW_COUNT_BYTES, Bytes.toBytes((String)Long.toString(verificationResult.getAfterRepairExtraUnverifiedIndexRowCount())));
        }
        this.resultTable.put(put);
    }

    public Table getTable(Connection conn, byte[] tableName) throws SQLException {
        return conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(tableName);
    }

    public IndexToolVerificationResult getVerificationResult(Table htable, long ts) throws IOException {
        byte[] startRowKey = Bytes.toBytes((String)Long.toString(ts));
        byte[] stopRowKey = ByteUtil.calculateTheClosestNextRowKeyForPrefix(startRowKey);
        IndexToolVerificationResult verificationResult = new IndexToolVerificationResult(ts);
        Scan scan = new Scan();
        scan.setStartRow(startRowKey);
        scan.setStopRow(stopRowKey);
        return this.aggregateVerificationResult(htable, verificationResult, scan);
    }

    private IndexToolVerificationResult aggregateVerificationResult(Table hTable, IndexToolVerificationResult verificationResult, Scan scan) throws IOException {
        try (ResultScanner scanner = hTable.getScanner(scan);){
            Result result = scanner.next();
            while (result != null) {
                boolean isFirst = true;
                for (Cell cell : result.rawCells()) {
                    if (isFirst) {
                        byte[][] rowKeyParts = ByteUtil.splitArrayBySeparator(result.getRow(), ROW_KEY_SEPARATOR_BYTE[0]);
                        verificationResult.setStartRow(rowKeyParts[3]);
                        verificationResult.setStopRow(rowKeyParts[4]);
                        isFirst = false;
                    }
                    verificationResult.update(cell);
                }
                result = scanner.next();
            }
        }
        return verificationResult;
    }

    public IndexToolVerificationResult getVerificationResult(Connection conn, long ts, byte[] indexTableName) throws IOException, SQLException {
        try (Table hTable = this.getTable(conn, RESULT_TABLE_NAME_BYTES);){
            byte[] startRowKey = IndexVerificationResultRepository.generatePartialResultTableRowKey(ts, indexTableName);
            byte[] stopRowKey = ByteUtil.calculateTheClosestNextRowKeyForPrefix(startRowKey);
            IndexToolVerificationResult verificationResult = new IndexToolVerificationResult(ts);
            Scan scan = new Scan();
            scan.setStartRow(startRowKey);
            scan.setStopRow(stopRowKey);
            IndexToolVerificationResult indexToolVerificationResult = this.aggregateVerificationResult(hTable, verificationResult, scan);
            return indexToolVerificationResult;
        }
    }

    private IndexToolVerificationResult getVerificationResult(Table htable, byte[] oldRowKey, Scan scan) throws IOException {
        IndexToolVerificationResult verificationResult = null;
        Result result = htable.get(new Get(oldRowKey));
        if (!result.isEmpty()) {
            byte[][] rowKeyParts = ByteUtil.splitArrayBySeparator(result.getRow(), ROW_KEY_SEPARATOR_BYTE[0]);
            verificationResult = new IndexToolVerificationResult(scan);
            verificationResult.setStartRow(rowKeyParts[3]);
            verificationResult.setStopRow(rowKeyParts[4]);
            for (Cell cell : result.rawCells()) {
                verificationResult.update(cell);
            }
        }
        return verificationResult;
    }

    @Override
    public void close() throws IOException {
        if (this.resultTable != null) {
            this.resultTable.close();
        }
        if (this.indexTable != null) {
            this.indexTable.close();
        }
    }

    public void setResultTable(Table resultTable) {
        this.resultTable = resultTable;
    }

    public void setIndexTable(Table indexTable) {
        this.indexTable = indexTable;
    }

    public IndexToolVerificationResult getVerificationResult(Long ts, Scan scan, Region region, byte[] indexTableName) throws IOException {
        byte[] rowKey = IndexVerificationResultRepository.generateResultTableRowKey(ts, indexTableName, region.getRegionInfo().getRegionName(), scan.getStartRow(), scan.getStopRow());
        return this.getVerificationResult(this.resultTable, rowKey, scan);
    }
}

