/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.write;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import javax.annotation.concurrent.GuardedBy;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.phoenix.hbase.index.table.HTableFactory;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.util.ServerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexWriterUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexWriterUtils.class);
    public static final String INDEX_WRITER_PER_TABLE_THREADS_CONF_KEY = "index.writer.threads.pertable.max";
    public static final int DEFAULT_NUM_PER_TABLE_THREADS = Integer.MAX_VALUE;
    public static final String HTABLE_THREAD_KEY = "hbase.htable.threads.max";
    public static final String INDEX_WRITES_THREAD_MAX_PER_REGIONSERVER_KEY = "phoenix.index.writes.threads.max";
    public static final String HTABLE_KEEP_ALIVE_KEY = "hbase.htable.threads.keepalivetime";
    @Deprecated
    public static final String INDEX_WRITER_RPC_RETRIES_NUMBER = "phoenix.index.writes.rpc.retries.number";
    @Deprecated
    public static final int DEFAULT_INDEX_WRITER_RPC_RETRIES_NUMBER = 11;
    @Deprecated
    public static final String INDEX_WRITER_RPC_PAUSE = "phoenix.index.writes.rpc.pause";
    @Deprecated
    public static final int DEFAULT_INDEX_WRITER_RPC_PAUSE = 100;

    private IndexWriterUtils() {
    }

    public static HTableFactory getDefaultDelegateHTableFactory(RegionCoprocessorEnvironment env) {
        return new CoprocessorHConnectionTableFactory(env, ServerUtil.ConnectionType.INDEX_WRITER_CONNECTION_WITH_CUSTOM_THREADS);
    }

    public static HTableFactory getNoRetriesHTableFactory(RegionCoprocessorEnvironment env) {
        return new CoprocessorHConnectionTableFactory(env, ServerUtil.ConnectionType.INDEX_WRITER_CONNECTION_WITH_CUSTOM_THREADS_NO_RETRIES);
    }

    private static class CoprocessorHConnectionTableFactory
    implements HTableFactory {
        @GuardedBy(value="CoprocessorHConnectionTableFactory.this")
        private RegionCoprocessorEnvironment env;
        private ServerUtil.ConnectionType connectionType;

        CoprocessorHConnectionTableFactory(RegionCoprocessorEnvironment env, ServerUtil.ConnectionType connectionType) {
            this.env = env;
            this.connectionType = connectionType;
        }

        private Connection getConnection() throws IOException {
            return ServerUtil.ConnectionFactory.getConnection(this.connectionType, this.env);
        }

        @Override
        public Table getTable(ImmutableBytesPtr tablename) throws IOException {
            return this.getConnection().getTable(TableName.valueOf((byte[])tablename.copyBytesIfNecessary()));
        }

        @Override
        public synchronized void shutdown() {
        }

        @Override
        public Table getTable(ImmutableBytesPtr tablename, ExecutorService pool) throws IOException {
            return this.getConnection().getTable(TableName.valueOf((byte[])tablename.copyBytesIfNecessary()), pool);
        }
    }
}

