/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.covered.data;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.filter.SkipScanFilter;
import org.apache.phoenix.hbase.index.covered.data.LocalHBaseState;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.util.IndexManagementUtil;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.index.PhoenixIndexMetaData;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.collect.Sets;

public class CachedLocalTable
implements LocalHBaseState {
    private final Map<ImmutableBytesPtr, List<Cell>> rowKeyPtrToCells;
    private final Region region;

    private CachedLocalTable(Map<ImmutableBytesPtr, List<Cell>> rowKeyPtrToCells, Region region) {
        this.rowKeyPtrToCells = rowKeyPtrToCells;
        this.region = region;
    }

    @Override
    public List<Cell> getCurrentRowState(Mutation mutation, Collection<? extends ColumnReference> columnReferences, boolean ignoreNewerMutations) throws IOException {
        if (ignoreNewerMutations) {
            return this.doScan(mutation, columnReferences);
        }
        byte[] rowKey = mutation.getRow();
        return this.rowKeyPtrToCells.get((Object)new ImmutableBytesPtr(rowKey));
    }

    private List<Cell> doScan(Mutation mutation, Collection<? extends ColumnReference> columnReferences) throws IOException {
        byte[] rowKey = mutation.getRow();
        Scan scan = IndexManagementUtil.newLocalStateScan(Collections.singletonList(columnReferences));
        scan.setStartRow(rowKey);
        scan.setStopRow(rowKey);
        long ts = CachedLocalTable.getMutationTimestampWhenAllCellTimestampIsSame(mutation);
        scan.setTimeRange(0L, ts);
        try (RegionScanner regionScanner = this.region.getScanner(scan);){
            ArrayList<Cell> cells = new ArrayList<Cell>(1);
            boolean more = regionScanner.next(cells);
            assert (!more) : "Got more than one result when scanning a single row in the primary table!";
            ArrayList<Cell> arrayList = cells;
            return arrayList;
        }
    }

    @VisibleForTesting
    public static CachedLocalTable build(Map<ImmutableBytesPtr, List<Cell>> rowKeyPtrToCells) {
        return new CachedLocalTable(rowKeyPtrToCells, null);
    }

    public static CachedLocalTable build(Collection<? extends Mutation> dataTableMutationsWithSameRowKeyAndTimestamp, PhoenixIndexMetaData indexMetaData, Region region) throws IOException {
        if (indexMetaData.getReplayWrite() != null) {
            return new CachedLocalTable(Collections.emptyMap(), region);
        }
        return CachedLocalTable.preScanAllRequiredRows(dataTableMutationsWithSameRowKeyAndTimestamp, indexMetaData, region);
    }

    public static CachedLocalTable preScanAllRequiredRows(Collection<? extends Mutation> dataTableMutationsWithSameRowKeyAndTimestamp, PhoenixIndexMetaData indexMetaData, Region region) throws IOException {
        HashSet<KeyRange> keys = new HashSet<KeyRange>(dataTableMutationsWithSameRowKeyAndTimestamp.size());
        for (Mutation mutation : dataTableMutationsWithSameRowKeyAndTimestamp) {
            if (!indexMetaData.requiresPriorRowState(mutation)) continue;
            keys.add(PVarbinary.INSTANCE.getKeyRange(mutation.getRow()));
        }
        if (keys.isEmpty()) {
            return new CachedLocalTable(Collections.emptyMap(), region);
        }
        List<IndexMaintainer> indexTableMaintainers = indexMetaData.getIndexMaintainers();
        HashSet hashSet = Sets.newHashSet();
        for (IndexMaintainer indexTableMaintainer : indexTableMaintainers) {
            hashSet.addAll(indexTableMaintainer.getAllColumns());
        }
        hashSet.add(new ColumnReference(indexTableMaintainers.get(0).getDataEmptyKeyValueCF(), indexTableMaintainers.get(0).getEmptyKeyValueQualifier()));
        Scan scan = IndexManagementUtil.newLocalStateScan(Collections.singletonList(hashSet));
        ScanRanges scanRanges = ScanRanges.createPointLookup(new ArrayList<KeyRange>(keys));
        scanRanges.initializeScan(scan);
        SkipScanFilter skipScanFilter = scanRanges.getSkipScanFilter();
        if (indexMetaData.getReplayWrite() != null) {
            long timestamp = CachedLocalTable.getMaxTimestamp(dataTableMutationsWithSameRowKeyAndTimestamp);
            scan.setTimeRange(0L, timestamp);
            scan.setFilter((Filter)new SkipScanFilter(skipScanFilter, true));
        } else {
            assert (scan.isRaw());
            scan.setMaxVersions(1);
            scan.setFilter((Filter)skipScanFilter);
        }
        HashMap<ImmutableBytesPtr, List<Cell>> rowKeyPtrToCells = new HashMap<ImmutableBytesPtr, List<Cell>>();
        try (RegionScanner scanner = region.getScanner(scan);){
            boolean more = true;
            while (more) {
                ArrayList cells = new ArrayList();
                more = scanner.next(cells);
                if (cells.isEmpty()) continue;
                Cell cell = (Cell)cells.get(0);
                byte[] rowKey = CellUtil.cloneRow((Cell)cell);
                rowKeyPtrToCells.put(new ImmutableBytesPtr(rowKey), cells);
            }
        }
        return new CachedLocalTable(rowKeyPtrToCells, region);
    }

    private static long getMaxTimestamp(Collection<? extends Mutation> dataTableMutationsWithSameRowKeyAndTimestamp) {
        long maxTimestamp = Long.MIN_VALUE;
        for (Mutation mutation : dataTableMutationsWithSameRowKeyAndTimestamp) {
            long timestamp = CachedLocalTable.getMutationTimestampWhenAllCellTimestampIsSame(mutation);
            if (timestamp <= maxTimestamp) continue;
            maxTimestamp = timestamp;
        }
        return maxTimestamp;
    }

    private static long getMutationTimestampWhenAllCellTimestampIsSame(Mutation mutation) {
        return ((Cell)((List)mutation.getFamilyCellMap().values().iterator().next()).get(0)).getTimestamp();
    }
}

