/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index;

import java.io.IOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.hbase.index.ValueGetter;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;

public abstract class AbstractValueGetter
implements ValueGetter {
    @Override
    public KeyValue getLatestKeyValue(ColumnReference ref, long ts) throws IOException {
        ImmutableBytesWritable value = this.getLatestValue(ref, ts);
        byte[] rowKey = this.getRowKey();
        int valueOffset = 0;
        int valueLength = 0;
        byte[] valueBytes = HConstants.EMPTY_BYTE_ARRAY;
        if (value != null) {
            valueBytes = value.get();
            valueOffset = value.getOffset();
            valueLength = value.getLength();
        }
        return new KeyValue(rowKey, 0, rowKey.length, ref.getFamily(), 0, ref.getFamily().length, ref.getQualifier(), 0, ref.getQualifier().length, ts, KeyValue.Type.Put, valueBytes, valueOffset, valueLength);
    }
}

