/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.filter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Writable;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.ValueSchema;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.util.ByteUtil;

public class DistinctPrefixFilter
extends FilterBase
implements Writable {
    private static byte VERSION = 1;
    private int offset;
    private RowKeySchema schema;
    private int prefixLength;
    private boolean filterAll = false;
    private int lastPosition;
    private final ImmutableBytesWritable lastKey = new ImmutableBytesWritable(ByteUtil.EMPTY_BYTE_ARRAY, -1, -1);

    public DistinctPrefixFilter() {
    }

    public DistinctPrefixFilter(RowKeySchema schema, int prefixLength) {
        this.schema = schema;
        this.prefixLength = prefixLength;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public Filter.ReturnCode filterKeyValue(Cell v) throws IOException {
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        int maxOffset = this.schema.iterator(v.getRowArray(), v.getRowOffset() + this.offset, v.getRowLength() - this.offset, ptr);
        int position = this.schema.next(ptr, 0, maxOffset, this.prefixLength - 1);
        if (this.lastKey.getLength() != ptr.getLength() || !Bytes.equals((byte[])ptr.get(), (int)ptr.getOffset(), (int)ptr.getLength(), (byte[])this.lastKey.get(), (int)this.lastKey.getOffset(), (int)ptr.getLength())) {
            this.lastKey.set(ptr.get(), ptr.getOffset(), ptr.getLength());
            this.lastPosition = position - 1;
            return Filter.ReturnCode.INCLUDE;
        }
        return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
    }

    public Cell getNextCellHint(Cell v) throws IOException {
        ImmutableBytesWritable tmp;
        ValueSchema.Field field = this.schema.getField(this.prefixLength - 1);
        PDataType type = field.getDataType();
        if (this.offset > 0) {
            byte[] tmpKey = new byte[this.offset + this.lastKey.getLength() + (this.reversed || type.isFixedWidth() || field.getSortOrder() == SortOrder.DESC ? 0 : 1) + (this.prefixLength - 1 - this.lastPosition)];
            System.arraycopy(v.getRowArray(), v.getRowOffset(), tmpKey, 0, this.offset);
            System.arraycopy(this.lastKey.get(), this.lastKey.getOffset(), tmpKey, this.offset, this.lastKey.getLength());
            tmp = new ImmutableBytesWritable(tmpKey);
            if (!this.reversed && !ByteUtil.nextKey(tmp.get(), tmp.getOffset(), tmp.getLength())) {
                this.filterAll = true;
            }
        } else if (this.reversed) {
            tmp = this.lastKey;
        } else {
            if (type.isFixedWidth()) {
                tmp = new ImmutableBytesWritable(this.lastKey.copyBytes());
            } else {
                tmp = new ImmutableBytesWritable(this.lastKey);
                ByteUtil.nullPad(tmp, tmp.getLength() + this.prefixLength - this.lastPosition);
                if (field.getSortOrder() == SortOrder.DESC || this.prefixLength - this.lastPosition > 1) {
                    tmp.set(tmp.get(), tmp.getOffset(), tmp.getLength() - 1);
                }
            }
            if (!ByteUtil.nextKey(tmp.get(), tmp.getOffset(), tmp.getLength())) {
                this.filterAll = true;
            }
        }
        return KeyValueUtil.createFirstOnRow((byte[])tmp.get(), (int)tmp.getOffset(), (int)tmp.getLength(), null, (int)0, (int)0, null, (int)0, (int)0);
    }

    public boolean filterAllRemaining() throws IOException {
        return this.filterAll;
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(VERSION);
        this.schema.write(out);
        out.writeInt(this.prefixLength);
    }

    public void readFields(DataInput in) throws IOException {
        in.readByte();
        this.schema = new RowKeySchema();
        this.schema.readFields(in);
        this.prefixLength = in.readInt();
    }

    public byte[] toByteArray() throws IOException {
        return Writables.getBytes((Writable)this);
    }

    public static DistinctPrefixFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        try {
            return (DistinctPrefixFilter)Writables.getWritable((byte[])pbBytes, (Writable)new DistinctPrefixFilter());
        }
        catch (IOException e) {
            throw new DeserializationException((Throwable)e);
        }
    }
}

