/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.compile.KeyPart;
import org.apache.phoenix.expression.Determinism;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.FunctionExpression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.IllegalDataException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;

@FunctionParseNode.BuiltInFunction(name="ROUND", args={@FunctionParseNode.Argument(allowedTypes={PDecimal.class}), @FunctionParseNode.Argument(allowedTypes={PVarchar.class, PInteger.class}, defaultValue="null", isConstant=true), @FunctionParseNode.Argument(allowedTypes={PInteger.class}, defaultValue="1", isConstant=true)}, classType=FunctionParseNode.FunctionClassType.DERIVED)
public class RoundDecimalExpression
extends ScalarFunction {
    private int scale;

    public static Expression create(Expression expr, int scale) throws SQLException {
        if (expr.getDataType().isCoercibleTo(PLong.INSTANCE)) {
            return expr;
        }
        LiteralExpression scaleExpr = LiteralExpression.newConstant((Object)scale, (PDataType)PInteger.INSTANCE, Determinism.ALWAYS);
        ArrayList expressions = Lists.newArrayList((Object[])new Expression[]{expr, scaleExpr});
        return new RoundDecimalExpression(expressions);
    }

    public static Expression create(Expression expr) throws SQLException {
        return RoundDecimalExpression.create(expr, 0);
    }

    public static Expression create(List<Expression> exprs) throws SQLException {
        Expression expr = exprs.get(0);
        if (expr.getDataType().isCoercibleTo(PLong.INSTANCE)) {
            return expr;
        }
        if (exprs.size() == 1) {
            LiteralExpression scaleExpr = LiteralExpression.newConstant((Object)0, (PDataType)PInteger.INSTANCE, Determinism.ALWAYS);
            exprs = Lists.newArrayList((Object[])new Expression[]{expr, scaleExpr});
        }
        return new RoundDecimalExpression(exprs);
    }

    public RoundDecimalExpression() {
    }

    public RoundDecimalExpression(List<Expression> children) {
        super(children);
        LiteralExpression scaleChild = (LiteralExpression)children.get(1);
        PDataType scaleType = scaleChild.getDataType();
        Object scaleValue = scaleChild.getValue();
        if (scaleValue != null) {
            int scale;
            if (scaleType.isCoercibleTo(PInteger.INSTANCE, scaleValue) && (scale = ((Integer)PInteger.INSTANCE.toObject(scaleValue, scaleType)).intValue()) <= 38) {
                this.scale = scale;
                return;
            }
            throw new IllegalDataException("Invalid second argument for scale: " + scaleValue + ". The scale must be between 0 and " + 38 + " inclusive.");
        }
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        Expression childExpr = (Expression)this.children.get(0);
        if (childExpr.evaluate(tuple, ptr)) {
            if (ptr.getLength() == 0) {
                return true;
            }
            BigDecimal value = (BigDecimal)PDecimal.INSTANCE.toObject(ptr, childExpr.getDataType(), childExpr.getSortOrder());
            BigDecimal scaledValue = value.setScale(this.scale, this.getRoundingMode());
            ptr.set(PDecimal.INSTANCE.toBytes(scaledValue));
            return true;
        }
        return false;
    }

    @Override
    public PDataType getDataType() {
        return PDecimal.INSTANCE;
    }

    protected RoundingMode getRoundingMode() {
        return RoundingMode.HALF_UP;
    }

    protected final int getRoundingScale() {
        return this.scale;
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        this.scale = WritableUtils.readVInt((DataInput)input);
    }

    @Override
    public void write(DataOutput output) throws IOException {
        super.write(output);
        WritableUtils.writeVInt((DataOutput)output, (int)this.scale);
    }

    @Override
    public String getName() {
        return "ROUND";
    }

    @Override
    public FunctionExpression.OrderPreserving preservesOrder() {
        return FunctionExpression.OrderPreserving.YES;
    }

    @Override
    public int getKeyFormationTraversalIndex() {
        return 0;
    }

    @Override
    public KeyPart newKeyPart(final KeyPart childPart) {
        return new KeyPart(){
            private final List<Expression> extractNodes;
            {
                this.extractNodes = Collections.singletonList(RoundDecimalExpression.this);
            }

            @Override
            public PColumn getColumn() {
                return childPart.getColumn();
            }

            @Override
            public List<Expression> getExtractNodes() {
                return this.extractNodes;
            }

            @Override
            public KeyRange getKeyRange(CompareFilter.CompareOp op, Expression rhs) {
                BigDecimal rhsDecimal = (BigDecimal)PDecimal.INSTANCE.toObject(ScalarFunction.evaluateExpression(rhs));
                if (op == CompareFilter.CompareOp.EQUAL && !RoundDecimalExpression.this.hasEnoughPrecisionToProduce(rhsDecimal)) {
                    return KeyRange.EMPTY_RANGE;
                }
                BigDecimal roundedDecimal = this.roundAndPreserveOperator(rhsDecimal, op);
                KeyRange equalityRange = RoundDecimalExpression.this.getInputRangeProducing(roundedDecimal);
                boolean lowerInclusive = equalityRange.isLowerInclusive();
                boolean upperInclusive = equalityRange.isUpperInclusive();
                byte[] lowerRange = KeyRange.UNBOUND;
                byte[] upperRange = KeyRange.UNBOUND;
                switch (op) {
                    case EQUAL: {
                        return equalityRange;
                    }
                    case GREATER: {
                        lowerRange = equalityRange.getUpperRange();
                        lowerInclusive = !equalityRange.isUpperInclusive();
                        break;
                    }
                    case GREATER_OR_EQUAL: {
                        lowerRange = equalityRange.getLowerRange();
                        break;
                    }
                    case LESS: {
                        upperRange = equalityRange.getLowerRange();
                        upperInclusive = !equalityRange.isLowerInclusive();
                        break;
                    }
                    case LESS_OR_EQUAL: {
                        upperRange = equalityRange.getUpperRange();
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Invalid CompareOp: " + op));
                    }
                }
                KeyRange range = KeyRange.getKeyRange(lowerRange, lowerInclusive, upperRange, upperInclusive);
                if (this.getColumn().getSortOrder() == SortOrder.DESC) {
                    range = range.invert();
                }
                return range;
            }

            private BigDecimal roundAndPreserveOperator(BigDecimal decimal, CompareFilter.CompareOp op) {
                BigDecimal rounded = RoundDecimalExpression.this.roundToScale(decimal);
                if (!RoundDecimalExpression.this.hasEnoughPrecisionToProduce(decimal)) {
                    switch (op) {
                        case GREATER_OR_EQUAL: {
                            if (decimal.compareTo(rounded) <= 0) break;
                            return RoundDecimalExpression.this.stepNextInScale(rounded);
                        }
                        case GREATER: {
                            if (decimal.compareTo(rounded) >= 0) break;
                            return RoundDecimalExpression.this.stepPrevInScale(rounded);
                        }
                        case LESS_OR_EQUAL: {
                            if (decimal.compareTo(rounded) >= 0) break;
                            return RoundDecimalExpression.this.stepPrevInScale(rounded);
                        }
                        case LESS: {
                            if (decimal.compareTo(rounded) <= 0) break;
                            return RoundDecimalExpression.this.stepNextInScale(rounded);
                        }
                    }
                }
                return rounded;
            }

            @Override
            public PTable getTable() {
                return childPart.getTable();
            }
        };
    }

    protected KeyRange getInputRangeProducing(BigDecimal result) {
        if (!this.hasEnoughPrecisionToProduce(result)) {
            throw new IllegalArgumentException("Cannot produce input range for decimal " + result + ", not enough precision with scale " + this.getRoundingScale());
        }
        byte[] lowerRange = PDecimal.INSTANCE.toBytes(this.halfStepPrevInScale(result));
        byte[] upperRange = PDecimal.INSTANCE.toBytes(this.halfStepNextInScale(result));
        boolean lowerInclusive = result.signum() > 0;
        boolean upperInclusive = result.signum() < 0;
        return KeyRange.getKeyRange(lowerRange, lowerInclusive, upperRange, upperInclusive);
    }

    protected final boolean hasEnoughPrecisionToProduce(BigDecimal result) {
        return this.roundToScale(result).compareTo(result) == 0;
    }

    protected final BigDecimal roundToScale(BigDecimal decimal) {
        return decimal.setScale(this.getRoundingScale(), this.getRoundingMode());
    }

    protected final BigDecimal halfStepPrevInScale(BigDecimal decimal) {
        BigDecimal step = BigDecimal.ONE.scaleByPowerOfTen(-this.getRoundingScale());
        BigDecimal halfStep = step.divide(BigDecimal.valueOf(2L));
        return decimal.subtract(halfStep);
    }

    protected final BigDecimal halfStepNextInScale(BigDecimal decimal) {
        BigDecimal step = BigDecimal.ONE.scaleByPowerOfTen(-this.getRoundingScale());
        BigDecimal halfStep = step.divide(BigDecimal.valueOf(2L));
        return decimal.add(halfStep);
    }

    protected final BigDecimal stepPrevInScale(BigDecimal decimal) {
        BigDecimal step = BigDecimal.ONE.scaleByPowerOfTen(-this.getRoundingScale());
        return decimal.subtract(step);
    }

    protected final BigDecimal stepNextInScale(BigDecimal decimal) {
        BigDecimal step = BigDecimal.ONE.scaleByPowerOfTen(-this.getRoundingScale());
        return decimal.add(step);
    }
}

