/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.CoerceExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.CeilDateExpression;
import org.apache.phoenix.expression.function.TimeUnit;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PUnsignedDate;
import org.apache.phoenix.schema.types.PUnsignedTimestamp;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;

@FunctionParseNode.BuiltInFunction(name="CEIL", args={@FunctionParseNode.Argument(allowedTypes={PTimestamp.class}), @FunctionParseNode.Argument(allowedTypes={PVarchar.class, PInteger.class}, defaultValue="null", isConstant=true), @FunctionParseNode.Argument(allowedTypes={PInteger.class}, defaultValue="1", isConstant=true)}, classType=FunctionParseNode.FunctionClassType.DERIVED)
public class CeilTimestampExpression
extends CeilDateExpression {
    public CeilTimestampExpression() {
    }

    public CeilTimestampExpression(List<Expression> children) {
        super(children);
    }

    public static CeilTimestampExpression create(Expression expr, int multiplier) throws SQLException {
        ArrayList childExprs = Lists.newArrayList((Object[])new Expression[]{expr, CeilTimestampExpression.getTimeUnitExpr(TimeUnit.MILLISECOND), CeilTimestampExpression.getMultiplierExpr(multiplier)});
        return new CeilTimestampExpression(childExprs);
    }

    public static Expression create(List<Expression> children) throws SQLException {
        Expression firstChild = children.get(0);
        PDataType firstChildDataType = firstChild.getDataType();
        String timeUnit = (String)((LiteralExpression)children.get(1)).getValue();
        if (TimeUnit.MILLISECOND.toString().equalsIgnoreCase(timeUnit)) {
            return new CeilTimestampExpression(children);
        }
        ArrayList newChildren = Lists.newArrayListWithExpectedSize((int)children.size());
        newChildren.add(CoerceExpression.create(firstChild, firstChildDataType == PTimestamp.INSTANCE ? PDate.INSTANCE : PUnsignedDate.INSTANCE));
        newChildren.addAll(children.subList(1, children.size()));
        return CeilDateExpression.create(newChildren);
    }

    public static CeilTimestampExpression create(Expression expr) throws SQLException {
        return CeilTimestampExpression.create(expr, 1);
    }

    @Override
    protected PDataType.PDataCodec getKeyRangeCodec(PDataType columnDataType) {
        return columnDataType == PTimestamp.INSTANCE ? PDate.INSTANCE.getCodec() : (columnDataType == PUnsignedTimestamp.INSTANCE ? PUnsignedDate.INSTANCE.getCodec() : super.getKeyRangeCodec(columnDataType));
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (((Expression)this.children.get(0)).evaluate(tuple, ptr)) {
            if (ptr.getLength() == 0) {
                return true;
            }
            SortOrder sortOrder = ((Expression)this.children.get(0)).getSortOrder();
            PDataType dataType = this.getDataType();
            int nanos = dataType.getNanos(ptr, sortOrder);
            if (nanos > 0) {
                long millis = dataType.getMillis(ptr, sortOrder);
                Timestamp roundedTs = new Timestamp(millis + 1L);
                byte[] byteValue = dataType.toBytes(roundedTs);
                ptr.set(byteValue);
            }
            return true;
        }
        return false;
    }
}

