/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.execute;

import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.execute.visitor.QueryPlanVisitor;
import org.apache.phoenix.iterate.ConcatResultIterator;
import org.apache.phoenix.iterate.DefaultParallelScanGrouper;
import org.apache.phoenix.iterate.LimitingResultIterator;
import org.apache.phoenix.iterate.MergeSortTopNResultIterator;
import org.apache.phoenix.iterate.OffsetResultIterator;
import org.apache.phoenix.iterate.ParallelScanGrouper;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.iterate.UnionResultIterators;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.optimize.Cost;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.thirdparty.com.google.common.collect.Sets;
import org.apache.phoenix.util.NumberUtil;

public class UnionPlan
implements QueryPlan {
    private static final long DEFAULT_ESTIMATED_SIZE = 10240L;
    private final TableRef tableRef;
    private final FilterableStatement statement;
    private final ParameterMetaData paramMetaData;
    private final OrderByCompiler.OrderBy orderBy;
    private final StatementContext parentContext;
    private final Integer limit;
    private final Integer offset;
    private final GroupByCompiler.GroupBy groupBy;
    private final RowProjector projector;
    private final boolean isDegenerate;
    private final List<QueryPlan> plans;
    private UnionResultIterators iterators;
    private Long estimatedRows;
    private Long estimatedBytes;
    private Long estimateInfoTs;
    private boolean getEstimatesCalled;

    public UnionPlan(StatementContext context, FilterableStatement statement, TableRef table, RowProjector projector, Integer limit, Integer offset, OrderByCompiler.OrderBy orderBy, GroupByCompiler.GroupBy groupBy, List<QueryPlan> plans, ParameterMetaData paramMetaData) throws SQLException {
        this.parentContext = context;
        this.statement = statement;
        this.tableRef = table;
        this.projector = projector;
        this.limit = limit;
        this.orderBy = orderBy;
        this.groupBy = groupBy;
        this.plans = plans;
        this.offset = offset;
        this.paramMetaData = paramMetaData;
        boolean isDegen = true;
        for (QueryPlan plan : plans) {
            if (plan.getContext().getScanRanges() == ScanRanges.NOTHING) continue;
            isDegen = false;
            break;
        }
        this.isDegenerate = isDegen;
    }

    @Override
    public boolean isDegenerate() {
        return this.isDegenerate;
    }

    @Override
    public List<KeyRange> getSplits() {
        if (this.iterators == null) {
            return null;
        }
        return this.iterators.getSplits();
    }

    @Override
    public List<List<Scan>> getScans() {
        if (this.iterators == null) {
            return null;
        }
        return this.iterators.getScans();
    }

    public List<QueryPlan> getSubPlans() {
        return this.plans;
    }

    @Override
    public GroupByCompiler.GroupBy getGroupBy() {
        return this.groupBy;
    }

    @Override
    public OrderByCompiler.OrderBy getOrderBy() {
        return this.orderBy;
    }

    @Override
    public TableRef getTableRef() {
        return this.tableRef;
    }

    @Override
    public Integer getLimit() {
        return this.limit;
    }

    @Override
    public Integer getOffset() {
        return this.offset;
    }

    @Override
    public RowProjector getProjector() {
        return this.projector;
    }

    @Override
    public ResultIterator iterator() throws SQLException {
        return this.iterator(DefaultParallelScanGrouper.getInstance());
    }

    @Override
    public ResultIterator iterator(ParallelScanGrouper scanGrouper) throws SQLException {
        return this.iterator(scanGrouper, null);
    }

    @Override
    public final ResultIterator iterator(ParallelScanGrouper scanGrouper, Scan scan) throws SQLException {
        ResultIterator scanner;
        boolean isOrdered;
        this.iterators = new UnionResultIterators(this.plans, this.parentContext);
        boolean bl = isOrdered = !this.orderBy.getOrderByExpressions().isEmpty();
        if (isOrdered) {
            scanner = new MergeSortTopNResultIterator(this.iterators, this.limit, this.offset, this.orderBy.getOrderByExpressions());
        } else {
            scanner = new ConcatResultIterator(this.iterators);
            if (this.offset != null) {
                scanner = new OffsetResultIterator(scanner, this.offset);
            }
            if (this.limit != null) {
                scanner = new LimitingResultIterator(scanner, this.limit);
            }
        }
        return scanner;
    }

    @Override
    public ExplainPlan getExplainPlan() throws SQLException {
        ArrayList<String> steps = new ArrayList<String>();
        ExplainPlanAttributes.ExplainPlanAttributesBuilder builder = new ExplainPlanAttributes.ExplainPlanAttributesBuilder();
        String abstractExplainPlan = "UNION ALL OVER " + this.plans.size() + " QUERIES";
        builder.setAbstractExplainPlan(abstractExplainPlan);
        steps.add(abstractExplainPlan);
        ResultIterator iterator = this.iterator();
        iterator.explain(steps, builder);
        int offset = !this.orderBy.getOrderByExpressions().isEmpty() && this.limit != null ? 2 : (this.limit != null ? 1 : 0);
        for (int i = 1; i < steps.size() - offset; ++i) {
            steps.set(i, "    " + (String)steps.get(i));
        }
        return new ExplainPlan(steps, builder.build());
    }

    @Override
    public long getEstimatedSize() {
        return 10240L;
    }

    @Override
    public Cost getCost() {
        Cost cost = Cost.ZERO;
        for (QueryPlan plan : this.plans) {
            cost = cost.plus(plan.getCost());
        }
        return cost;
    }

    @Override
    public ParameterMetaData getParameterMetaData() {
        return this.paramMetaData;
    }

    @Override
    public FilterableStatement getStatement() {
        return this.statement;
    }

    @Override
    public StatementContext getContext() {
        return this.parentContext;
    }

    @Override
    public boolean isRowKeyOrdered() {
        return this.groupBy.isEmpty() ? this.orderBy.getOrderByExpressions().isEmpty() : this.groupBy.isOrderPreserving();
    }

    public List<QueryPlan> getPlans() {
        return this.plans;
    }

    @Override
    public boolean useRoundRobinIterator() throws SQLException {
        return false;
    }

    @Override
    public <T> T accept(QueryPlanVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public PhoenixStatement.Operation getOperation() {
        return this.statement.getOperation();
    }

    @Override
    public Set<TableRef> getSourceRefs() {
        HashSet sources = Sets.newHashSetWithExpectedSize((int)this.plans.size());
        for (QueryPlan plan : this.plans) {
            sources.addAll(plan.getSourceRefs());
        }
        return sources;
    }

    @Override
    public Long getEstimatedRowsToScan() throws SQLException {
        if (!this.getEstimatesCalled) {
            this.getEstimates();
        }
        return this.estimatedRows;
    }

    @Override
    public Long getEstimatedBytesToScan() throws SQLException {
        if (!this.getEstimatesCalled) {
            this.getEstimates();
        }
        return this.estimatedBytes;
    }

    @Override
    public Long getEstimateInfoTimestamp() throws SQLException {
        if (!this.getEstimatesCalled) {
            this.getEstimates();
        }
        return this.estimateInfoTs;
    }

    private void getEstimates() throws SQLException {
        this.getEstimatesCalled = true;
        for (QueryPlan plan : this.plans) {
            if (plan.getEstimatedBytesToScan() == null || plan.getEstimatedRowsToScan() == null || plan.getEstimateInfoTimestamp() == null) {
                this.estimatedBytes = null;
                this.estimatedRows = null;
                this.estimateInfoTs = null;
                break;
            }
            this.estimatedBytes = NumberUtil.add(this.estimatedBytes, plan.getEstimatedBytesToScan());
            this.estimatedRows = NumberUtil.add(this.estimatedRows, plan.getEstimatedRowsToScan());
            this.estimateInfoTs = NumberUtil.getMin(this.estimateInfoTs, plan.getEstimateInfoTimestamp());
        }
    }

    @Override
    public List<OrderByCompiler.OrderBy> getOutputOrderBys() {
        assert (this.groupBy == GroupByCompiler.GroupBy.EMPTY_GROUP_BY);
        assert (this.orderBy != OrderByCompiler.OrderBy.FWD_ROW_KEY_ORDER_BY && this.orderBy != OrderByCompiler.OrderBy.REV_ROW_KEY_ORDER_BY);
        if (!this.orderBy.isEmpty()) {
            return Collections.singletonList(OrderByCompiler.OrderBy.convertCompiledOrderByToOutputOrderBy(this.orderBy));
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isApplicable() {
        return true;
    }
}

