/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.coprocessor.BaseRegionScanner;
import org.apache.phoenix.coprocessor.BaseScannerRegionObserver;
import org.apache.phoenix.coprocessor.metrics.MetricsPhoenixCoprocessorSourceFactory;
import org.apache.phoenix.coprocessor.metrics.MetricsPhoenixTTLSource;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.ServerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixTTLRegionObserver
extends BaseScannerRegionObserver
implements RegionCoprocessor {
    private static final Logger LOG = LoggerFactory.getLogger(PhoenixTTLRegionObserver.class);
    private MetricsPhoenixTTLSource metricSource;

    public Optional<RegionObserver> getRegionObserver() {
        return Optional.of(this);
    }

    public void start(CoprocessorEnvironment e) throws IOException {
        this.metricSource = MetricsPhoenixCoprocessorSourceFactory.getInstance().getPhoenixTTLSource();
    }

    @Override
    protected boolean isRegionObserverFor(Scan scan) {
        return ScanUtil.isMaskTTLExpiredRows(scan) || ScanUtil.isDeleteTTLExpiredRows(scan);
    }

    @Override
    protected RegionScanner doPostScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan, RegionScanner s) throws IOException, SQLException {
        if (ScanUtil.isMaskTTLExpiredRows(scan) && ScanUtil.isDeleteTTLExpiredRows(scan)) {
            throw new IOException("Both mask and delete expired rows property cannot be set");
        }
        if (ScanUtil.isMaskTTLExpiredRows(scan)) {
            this.metricSource.incrementMaskExpiredRequestCount();
            scan.setAttribute("MASK_PHOENIX_TTL_EXPIRED_REQUEST_ID", Bytes.toBytes((String)String.format("MASK-EXPIRED-%d", this.metricSource.getMaskExpiredRequestCount())));
        } else if (ScanUtil.isDeleteTTLExpiredRows(scan)) {
            this.metricSource.incrementDeleteExpiredRequestCount();
            scan.setAttribute("MASK_PHOENIX_TTL_EXPIRED_REQUEST_ID", Bytes.toBytes((String)String.format("DELETE-EXPIRED-%d", this.metricSource.getDeleteExpiredRequestCount())));
        }
        LOG.trace(String.format("********** PHOENIX-TTL: PhoenixTTLRegionObserver::postScannerOpen TTL for table = [%s], scan = [%s], PHOENIX_TTL = %d ***************, numMaskExpiredRequestCount=%d, numDeleteExpiredRequestCount=%d", s.getRegionInfo().getTable().getNameAsString(), scan.toJSON(Integer.MAX_VALUE), ScanUtil.getPhoenixTTL(scan), this.metricSource.getMaskExpiredRequestCount(), this.metricSource.getDeleteExpiredRequestCount()));
        return new PhoenixTTLRegionScanner((RegionCoprocessorEnvironment)c.getEnvironment(), scan, s);
    }

    private static class PhoenixTTLRegionScanner
    extends BaseRegionScanner {
        private static final String MASK_PHOENIX_TTL_EXPIRED_REQUEST_ID_ATTR = "MASK_PHOENIX_TTL_EXPIRED_REQUEST_ID";
        private final RegionCoprocessorEnvironment env;
        private final RegionScanner scanner;
        private final Scan scan;
        private final byte[] emptyCF;
        private final byte[] emptyCQ;
        private final Region region;
        private final long minTimestamp;
        private final long maxTimestamp;
        private final long now;
        private final boolean deleteIfExpired;
        private final boolean maskIfExpired;
        private final String requestId;
        private final byte[] scanTableName;
        private long numRowsExpired;
        private long numRowsScanned;
        private long numRowsDeleted;
        private boolean reported = false;
        private long pageSizeMs;

        public PhoenixTTLRegionScanner(RegionCoprocessorEnvironment env, Scan scan, RegionScanner scanner) throws IOException {
            super(scanner);
            this.env = env;
            this.scan = scan;
            this.scanner = scanner;
            byte[] requestIdBytes = scan.getAttribute(MASK_PHOENIX_TTL_EXPIRED_REQUEST_ID_ATTR);
            this.requestId = Bytes.toString((byte[])requestIdBytes);
            this.deleteIfExpired = ScanUtil.isDeleteTTLExpiredRows(scan);
            this.maskIfExpired = !this.deleteIfExpired && ScanUtil.isMaskTTLExpiredRows(scan);
            this.region = env.getRegion();
            this.emptyCF = scan.getAttribute("_EmptyCFName");
            this.emptyCQ = scan.getAttribute("_EmptyCQName");
            this.scanTableName = scan.getAttribute("_PhoenixTTLScanTableName");
            byte[] txnScn = scan.getAttribute("_TxScn");
            if (txnScn != null) {
                TimeRange timeRange = scan.getTimeRange();
                scan.setTimeRange(timeRange.getMin(), Bytes.toLong((byte[])txnScn));
            }
            this.minTimestamp = scan.getTimeRange().getMin();
            this.maxTimestamp = scan.getTimeRange().getMax();
            this.now = this.maxTimestamp != Long.MAX_VALUE ? this.maxTimestamp : EnvironmentEdgeManager.currentTimeMillis();
            this.pageSizeMs = ScanUtil.getPageSizeMsForRegionScanner(scan);
        }

        @Override
        public int getBatch() {
            return this.scanner.getBatch();
        }

        @Override
        public long getMaxResultSize() {
            return this.scanner.getMaxResultSize();
        }

        @Override
        public boolean next(List<Cell> result) throws IOException {
            return this.doNext(result, false);
        }

        @Override
        public boolean next(List<Cell> result, ScannerContext scannerContext) throws IOException {
            throw new IOException("next with scannerContext should not be called in Phoenix environment");
        }

        @Override
        public boolean nextRaw(List<Cell> result, ScannerContext scannerContext) throws IOException {
            throw new IOException("NextRaw with scannerContext should not be called in Phoenix environment");
        }

        @Override
        public void close() throws IOException {
            if (!this.reported) {
                LOG.debug(String.format("PHOENIX-TTL-SCAN-STATS-ON-CLOSE: request-id:[%s,%s] = [%d, %d, %d]", this.requestId, Bytes.toString((byte[])this.scanTableName), this.numRowsScanned, this.numRowsExpired, this.numRowsDeleted));
                this.reported = true;
            }
            this.scanner.close();
        }

        @Override
        public RegionInfo getRegionInfo() {
            return this.scanner.getRegionInfo();
        }

        @Override
        public boolean reseek(byte[] row) throws IOException {
            return this.scanner.reseek(row);
        }

        @Override
        public long getMvccReadPoint() {
            return this.scanner.getMvccReadPoint();
        }

        @Override
        public boolean nextRaw(List<Cell> result) throws IOException {
            return this.doNext(result, true);
        }

        private boolean doNext(List<Cell> result, boolean raw) throws IOException {
            try {
                boolean hasMore;
                long startTime = EnvironmentEdgeManager.currentTimeMillis();
                do {
                    boolean bl = hasMore = raw ? this.scanner.nextRaw(result) : this.scanner.next(result);
                    if (result.isEmpty()) break;
                    if (ScanUtil.isDummy(result)) {
                        return true;
                    }
                    ++this.numRowsScanned;
                    if (this.maskIfExpired && this.checkRowNotExpired(result)) break;
                    if (this.deleteIfExpired && this.deleteRowIfExpired(result)) {
                        ++this.numRowsDeleted;
                        break;
                    }
                    if (this.maskIfExpired) {
                        ++this.numRowsExpired;
                    }
                    if (hasMore && EnvironmentEdgeManager.currentTimeMillis() - startTime >= this.pageSizeMs) {
                        byte[] rowKey = CellUtil.cloneRow((Cell)result.get(0));
                        result.clear();
                        ScanUtil.getDummyResult(rowKey, result);
                        return true;
                    }
                    result.clear();
                } while (hasMore);
                return hasMore;
            }
            catch (Throwable t) {
                ServerUtil.throwIOException(this.region.getRegionInfo().getRegionNameAsString(), t);
                return false;
            }
        }

        private boolean deleteRowIfExpired(List<Cell> cellList) throws IOException {
            boolean isRowExpired;
            long cellListSize = cellList.size();
            if (cellListSize == 0L) {
                return true;
            }
            Iterator<Cell> cellIterator = cellList.iterator();
            Cell firstCell = cellIterator.next();
            byte[] rowKey = new byte[firstCell.getRowLength()];
            System.arraycopy(firstCell.getRowArray(), firstCell.getRowOffset(), rowKey, 0, firstCell.getRowLength());
            boolean bl = isRowExpired = !this.checkRowNotExpired(cellList);
            if (isRowExpired) {
                long ttl = ScanUtil.getPhoenixTTL(this.scan);
                long ts = ScanUtil.getMaxTimestamp(cellList);
                LOG.trace(String.format("PHOENIX-TTL: Deleting row = [%s] belonging to table = %s, scn = %s, now = %d, delete-ts = %d, max-ts = %d", Bytes.toString((byte[])rowKey), Bytes.toString((byte[])this.scanTableName), this.maxTimestamp != Long.MAX_VALUE, this.now, this.now - ttl, ts));
                Delete del = new Delete(rowKey, this.now - ttl);
                Mutation[] mutations = new Mutation[]{del};
                this.region.batchMutate(mutations);
                return true;
            }
            return false;
        }

        private boolean checkRowNotExpired(List<Cell> cellList) throws IOException {
            long cellListSize = cellList.size();
            Cell cell = null;
            if (cellListSize == 0L) {
                return true;
            }
            Iterator<Cell> cellIterator = cellList.iterator();
            while (cellIterator.hasNext()) {
                cell = cellIterator.next();
                if (!ScanUtil.isEmptyColumn(cell, this.emptyCF, this.emptyCQ)) continue;
                LOG.trace(String.format("** PHOENIX-TTL: Row expired for [%s], expired = %s **", cell.toString(), ScanUtil.isTTLExpired(cell, this.scan, this.now)));
                if (cellListSize > 1L) {
                    cellIterator.remove();
                }
                return !ScanUtil.isTTLExpired(cell, this.scan, this.now);
            }
            LOG.warn("The empty column does not exist in a row in " + this.region.getRegionInfo().getTable().getNameAsString());
            return true;
        }

        @Override
        public RegionScanner getNewRegionScanner(Scan scan) throws IOException {
            return new PhoenixTTLRegionScanner(this.env, scan, ((BaseRegionScanner)this.delegate).getNewRegionScanner(scan));
        }
    }
}

