/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.aggregator.ClientAggregators;
import org.apache.phoenix.expression.aggregator.ServerAggregators;
import org.apache.phoenix.expression.function.SingleAggregateFunction;
import org.apache.phoenix.expression.visitor.SingleAggregateFunctionVisitor;
import org.apache.phoenix.thirdparty.com.google.common.collect.Sets;

public class AggregationManager {
    private ClientAggregators aggregators;
    private int position = 0;

    public ClientAggregators getAggregators() {
        return this.aggregators;
    }

    public boolean isEmpty() {
        return this.aggregators == null || this.aggregators.getAggregatorCount() == 0;
    }

    protected int nextPosition() {
        return this.position++;
    }

    public void setAggregators(ClientAggregators clientAggregator) {
        this.aggregators = clientAggregator;
    }

    public void compile(StatementContext context, GroupByCompiler.GroupBy groupBy) throws SQLException {
        final HashSet aggFuncSet = Sets.newHashSetWithExpectedSize((int)context.getExpressionManager().getExpressionCount());
        Iterator<Expression> expressions = context.getExpressionManager().getExpressions();
        while (expressions.hasNext()) {
            Expression expression = expressions.next();
            expression.accept(new SingleAggregateFunctionVisitor(){

                @Override
                public Iterator<Expression> visitEnter(SingleAggregateFunction function) {
                    aggFuncSet.add(function);
                    return Collections.emptyIterator();
                }
            });
        }
        if (aggFuncSet.isEmpty() && groupBy.isEmpty()) {
            return;
        }
        ArrayList<SingleAggregateFunction> aggFuncs = new ArrayList<SingleAggregateFunction>(aggFuncSet);
        Collections.sort(aggFuncs, SingleAggregateFunction.SCHEMA_COMPARATOR);
        int minNullableIndex = AggregationManager.getMinNullableIndex(aggFuncs, groupBy.isEmpty());
        context.getScan().setAttribute("_Aggs", ServerAggregators.serialize(aggFuncs, minNullableIndex));
        ClientAggregators clientAggregators = new ClientAggregators(aggFuncs, minNullableIndex);
        context.getAggregationManager().setAggregators(clientAggregators);
    }

    private static int getMinNullableIndex(List<SingleAggregateFunction> aggFuncs, boolean isUngroupedAggregation) {
        int minNullableIndex = aggFuncs.size();
        for (int i = 0; i < aggFuncs.size(); ++i) {
            SingleAggregateFunction aggFunc = aggFuncs.get(i);
            if (!(isUngroupedAggregation ? aggFunc.getAggregator().isNullable() : aggFunc.getAggregatorExpression().isNullable())) continue;
            minNullableIndex = i;
            break;
        }
        return minNullableIndex;
    }
}

