/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.json.impl;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.ojai.Document;
import org.ojai.DocumentConstants;
import org.ojai.DocumentReader;
import org.ojai.FieldPath;
import org.ojai.FieldSegment;
import org.ojai.Value;
import org.ojai.annotation.API;
import org.ojai.beans.BeanCodec;
import org.ojai.exceptions.DecodingException;
import org.ojai.json.Json;
import org.ojai.json.JsonOptions;
import org.ojai.json.impl.JsonDOMDocumentReader;
import org.ojai.json.impl.JsonList;
import org.ojai.json.impl.JsonStreamDocumentReader;
import org.ojai.json.impl.JsonValue;
import org.ojai.json.impl.JsonValueBuilder;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;
import org.ojai.util.DocumentReaders;
import org.ojai.util.Documents;

@API.Internal
public class JsonDocument
extends JsonValue
implements Document,
Map<String, Object> {
    private final JsonStreamDocumentReader jsonDocumentReader;

    public JsonDocument() {
        this((JsonStreamDocumentReader)null);
    }

    @Override
    public JsonDocument setId(Value value) {
        this.set(DocumentConstants.ID_FIELD, value);
        return this;
    }

    @Override
    public Value getId() {
        return this.getValue(DocumentConstants.ID_FIELD);
    }

    @Override
    public Document setId(String _id) {
        return this.setId(JsonValueBuilder.initFrom(_id));
    }

    @Override
    public String getIdString() {
        return this.getId().getString();
    }

    @Override
    public Document setId(ByteBuffer _id) {
        return this.setId(JsonValueBuilder.initFrom(_id));
    }

    @Override
    public ByteBuffer getIdBinary() {
        return this.getId().getBinary();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    JsonDocument(JsonStreamDocumentReader reader) {
        this.jsonDocumentReader = reader;
        this.valueType = Value.Type.MAP;
    }

    public void checkForArrayNotation(String fieldPath) {
        if (fieldPath.contains("[]")) {
            throw new IllegalArgumentException("[] cannot be used to get/set/delete a value in a Document");
        }
    }

    JsonDocument createOrInsert(Iterator<FieldSegment> iter, JsonValue newKeyValue) {
        FieldSegment field = iter.next();
        String key = field.getNameSegment().getName();
        JsonValue oldKeyValue = this.getRootMap().get(key);
        if (field.isLastPath()) {
            newKeyValue.setKey(key);
            this.getRootMap().put(key, newKeyValue);
            return this;
        }
        if (field.isMap()) {
            if (oldKeyValue == null || oldKeyValue.getType() != Value.Type.MAP) {
                JsonDocument newDocument = new JsonDocument();
                newDocument.createOrInsert(iter, newKeyValue);
                newDocument.setKey(key);
                this.getRootMap().put(key, newDocument);
                return this;
            }
            JsonDocument newDocument = (JsonDocument)oldKeyValue;
            return newDocument.createOrInsert(iter, newKeyValue);
        }
        if (oldKeyValue == null || oldKeyValue.getType() != Value.Type.ARRAY) {
            JsonList newList = new JsonList();
            newList.createOrInsert(iter, newKeyValue);
            newList.setKey(key);
            this.getRootMap().put(key, newList);
            return this;
        }
        JsonList newList = (JsonList)oldKeyValue;
        newList.createOrInsert(iter, newKeyValue);
        return this;
    }

    private void testNoSuchElement(FieldPath fieldPath, JsonValue value) {
        if (value == null) {
            throw new NoSuchElementException("Field '" + fieldPath.asPathString() + "' not found in the document.");
        }
    }

    private JsonDocument setCommon(FieldPath fieldPath, JsonValue value) {
        this.checkForArrayNotation(fieldPath.toString());
        Iterator<FieldSegment> iter = fieldPath.iterator();
        this.createOrInsert(iter, value);
        return this;
    }

    @Override
    public Document set(FieldPath fieldPath, String value) {
        return this.setCommon(fieldPath, new JsonValue(value, Value.Type.STRING));
    }

    @Override
    public Document set(FieldPath fieldPath, boolean value) {
        return this.setCommon(fieldPath, new JsonValue(value, Value.Type.BOOLEAN));
    }

    @Override
    public Document set(FieldPath fieldPath, byte value) {
        return this.setCommon(fieldPath, new JsonValue(value, Value.Type.BYTE));
    }

    @Override
    public Document set(FieldPath fieldPath, short value) {
        return this.setCommon(fieldPath, new JsonValue(value, Value.Type.SHORT));
    }

    @Override
    public Document set(FieldPath fieldPath, int value) {
        return this.setCommon(fieldPath, new JsonValue(value, Value.Type.INT));
    }

    @Override
    public Document set(FieldPath fieldPath, long value) {
        return this.setCommon(fieldPath, new JsonValue(value, Value.Type.LONG));
    }

    @Override
    public Document set(FieldPath fieldPath, float value) {
        return this.setCommon(fieldPath, JsonValueBuilder.initFrom(value));
    }

    @Override
    public Document set(FieldPath fieldPath, double value) {
        return this.setCommon(fieldPath, JsonValueBuilder.initFrom(value));
    }

    @Override
    public Document set(FieldPath fieldPath, BigDecimal value) {
        return this.setCommon(fieldPath, JsonValueBuilder.initFrom(value));
    }

    @Override
    public Document set(String fieldPath, OTimestamp value) {
        return this.set(FieldPath.parseFrom(fieldPath), value);
    }

    @Override
    public Document set(FieldPath fieldPath, OTimestamp value) {
        return this.setCommon(fieldPath, JsonValueBuilder.initFrom(value));
    }

    @Override
    public Document set(String fieldPath, OInterval value) {
        return this.set(FieldPath.parseFrom(fieldPath), value);
    }

    @Override
    public Document set(FieldPath fieldPath, OInterval value) {
        return this.setCommon(fieldPath, JsonValueBuilder.initFrom(value));
    }

    @Override
    public Document set(FieldPath fieldPath, OTime value) {
        return this.setCommon(fieldPath, JsonValueBuilder.initFrom(value));
    }

    @Override
    public Document set(FieldPath fieldPath, ODate value) {
        return this.setCommon(fieldPath, JsonValueBuilder.initFrom(value));
    }

    @Override
    public JsonDocument set(String field, Document value) {
        return this.setCommon(FieldPath.parseFrom(field), JsonValueBuilder.initFrom(value));
    }

    @Override
    public JsonDocument set(FieldPath field, Document value) {
        return this.setCommon(field, JsonValueBuilder.initFrom(value));
    }

    @Override
    public JsonDocument set(String field, Value value) {
        return this.setCommon(FieldPath.parseFrom(field), JsonValueBuilder.initFrom(value));
    }

    @Override
    public JsonDocument set(FieldPath field, Value value) {
        return this.setCommon(field, JsonValueBuilder.initFrom(value));
    }

    @Override
    public Document setNull(FieldPath fieldPath) {
        return this.setCommon(fieldPath, JsonValueBuilder.initFromNull());
    }

    Document delete(Iterator<FieldSegment> iter) {
        FieldSegment field = iter.next();
        if (field == null) {
            return null;
        }
        String key = field.getNameSegment().getName();
        JsonValue kv = this.getRootMap().get(key);
        if (kv == null) {
            return null;
        }
        if (field.isLastPath()) {
            this.getRootMap().remove(kv.key);
            return null;
        }
        if (field.isMap()) {
            if (kv.getType() != Value.Type.MAP) {
                return null;
            }
            return ((JsonDocument)kv).delete(iter);
        }
        if (kv.getType() != Value.Type.ARRAY) {
            return null;
        }
        ((JsonList)kv).delete(iter);
        return this;
    }

    @Override
    public Document delete(String field) {
        this.delete(FieldPath.parseFrom(field));
        return this;
    }

    @Override
    public Document delete(FieldPath path) {
        this.checkForArrayNotation(path.toString());
        this.delete(path.iterator());
        return this;
    }

    public JsonValue getKeyValueAt(Iterator<FieldSegment> iter) {
        FieldSegment field = iter.next();
        if (field == null) {
            return null;
        }
        String key = field.getNameSegment().getName();
        JsonValue kv = this.getRootMap().get(key);
        if (kv == null) {
            return null;
        }
        if (field.isLastPath()) {
            return kv;
        }
        if (field.isMap()) {
            if (kv.getType() != Value.Type.MAP) {
                return null;
            }
            return ((JsonDocument)kv).getKeyValueAt(iter);
        }
        if (kv.getType() != Value.Type.ARRAY) {
            return null;
        }
        return ((JsonList)kv).getJsonValueAt(iter);
    }

    @Override
    public String getString(FieldPath fieldPath) {
        this.checkForArrayNotation(fieldPath.toString());
        JsonValue value = this.getKeyValueAt(fieldPath.iterator());
        if (value != null) {
            return value.getString();
        }
        return null;
    }

    @Override
    public boolean getBoolean(String fieldPath) {
        return this.getBoolean(FieldPath.parseFrom(fieldPath));
    }

    @Override
    public boolean getBoolean(FieldPath fieldPath) {
        this.checkForArrayNotation(fieldPath.toString());
        JsonValue value = this.getKeyValueAt(fieldPath.iterator());
        this.testNoSuchElement(fieldPath, value);
        return value.getBoolean();
    }

    @Override
    public Boolean getBooleanObj(String fieldPath) {
        return this.getBooleanObj(FieldPath.parseFrom(fieldPath));
    }

    @Override
    public Boolean getBooleanObj(FieldPath fieldPath) {
        JsonValue value = this.getKeyValueAt(fieldPath.iterator());
        if (value != null) {
            return value.getBoolean();
        }
        return null;
    }

    @Override
    public byte getByte(String fieldPath) {
        return this.getByte(FieldPath.parseFrom(fieldPath));
    }

    @Override
    public byte getByte(FieldPath fieldPath) {
        this.checkForArrayNotation(fieldPath.toString());
        JsonValue value = this.getKeyValueAt(fieldPath.iterator());
        this.testNoSuchElement(fieldPath, value);
        return value.getByte();
    }

    @Override
    public Byte getByteObj(String fieldPath) {
        return this.getByteObj(FieldPath.parseFrom(fieldPath));
    }

    @Override
    public Byte getByteObj(FieldPath fieldPath) {
        this.checkForArrayNotation(fieldPath.toString());
        JsonValue value = this.getKeyValueAt(fieldPath.iterator());
        if (value != null) {
            return value.getByte();
        }
        return null;
    }

    @Override
    public short getShort(String fieldPath) {
        return this.getShort(FieldPath.parseFrom(fieldPath));
    }

    @Override
    public short getShort(FieldPath fieldPath) {
        this.checkForArrayNotation(fieldPath.toString());
        JsonValue value = this.getKeyValueAt(fieldPath.iterator());
        this.testNoSuchElement(fieldPath, value);
        return value.getShort();
    }

    @Override
    public Short getShortObj(String fieldPath) {
        return this.getShortObj(FieldPath.parseFrom(fieldPath));
    }

    @Override
    public Short getShortObj(FieldPath fieldPath) {
        this.checkForArrayNotation(fieldPath.toString());
        JsonValue value = this.getKeyValueAt(fieldPath.iterator());
        if (value != null) {
            return value.getShort();
        }
        return null;
    }

    @Override
    public int getInt(String fieldPath) {
        return this.getInt(FieldPath.parseFrom(fieldPath));
    }

    @Override
    public int getInt(FieldPath fieldPath) {
        this.checkForArrayNotation(fieldPath.toString());
        JsonValue value = this.getKeyValueAt(fieldPath.iterator());
        this.testNoSuchElement(fieldPath, value);
        return value.getInt();
    }

    @Override
    public Integer getIntObj(String fieldPath) {
        return this.getIntObj(FieldPath.parseFrom(fieldPath));
    }

    @Override
    public Integer getIntObj(FieldPath fieldPath) {
        this.checkForArrayNotation(fieldPath.toString());
        JsonValue value = this.getKeyValueAt(fieldPath.iterator());
        if (value != null) {
            return value.getInt();
        }
        return null;
    }

    @Override
    public long getLong(String fieldPath) {
        return this.getLong(FieldPath.parseFrom(fieldPath));
    }

    @Override
    public long getLong(FieldPath fieldPath) {
        this.checkForArrayNotation(fieldPath.toString());
        JsonValue value = this.getKeyValueAt(fieldPath.iterator());
        this.testNoSuchElement(fieldPath, value);
        return value.getLong();
    }

    @Override
    public Long getLongObj(String fieldPath) {
        return this.getLongObj(FieldPath.parseFrom(fieldPath));
    }

    @Override
    public Long getLongObj(FieldPath fieldPath) {
        this.checkForArrayNotation(fieldPath.toString());
        JsonValue value = this.getKeyValueAt(fieldPath.iterator());
        if (value != null) {
            return value.getLong();
        }
        return null;
    }

    @Override
    public float getFloat(String fieldPath) {
        return this.getFloat(FieldPath.parseFrom(fieldPath));
    }

    @Override
    public float getFloat(FieldPath fieldPath) {
        this.checkForArrayNotation(fieldPath.toString());
        JsonValue value = this.getKeyValueAt(fieldPath.iterator());
        this.testNoSuchElement(fieldPath, value);
        return value.getFloat();
    }

    @Override
    public Float getFloatObj(String fieldPath) {
        return this.getFloatObj(FieldPath.parseFrom(fieldPath));
    }

    @Override
    public Float getFloatObj(FieldPath fieldPath) {
        this.checkForArrayNotation(fieldPath.toString());
        JsonValue value = this.getKeyValueAt(fieldPath.iterator());
        if (value != null) {
            return Float.valueOf(value.getFloat());
        }
        return null;
    }

    @Override
    public double getDouble(String fieldPath) {
        return this.getDouble(FieldPath.parseFrom(fieldPath));
    }

    @Override
    public double getDouble(FieldPath fieldPath) {
        this.checkForArrayNotation(fieldPath.toString());
        JsonValue value = this.getKeyValueAt(fieldPath.iterator());
        this.testNoSuchElement(fieldPath, value);
        return value.getDouble();
    }

    @Override
    public Double getDoubleObj(String fieldPath) {
        return this.getDoubleObj(FieldPath.parseFrom(fieldPath));
    }

    @Override
    public Double getDoubleObj(FieldPath fieldPath) {
        this.checkForArrayNotation(fieldPath.toString());
        JsonValue value = this.getKeyValueAt(fieldPath.iterator());
        if (value != null) {
            return value.getDouble();
        }
        return null;
    }

    @Override
    public BigDecimal getDecimal(FieldPath fieldPath) {
        this.checkForArrayNotation(fieldPath.toString());
        JsonValue v = this.getKeyValueAt(fieldPath.iterator());
        if (v != null) {
            return v.getDecimal();
        }
        return null;
    }

    @Override
    public JsonValue getValue(FieldPath fieldPath) {
        this.checkForArrayNotation(fieldPath.toString());
        return this.getKeyValueAt(fieldPath.iterator());
    }

    @Override
    public Map<String, Object> getMap(FieldPath fieldPath) {
        this.checkForArrayNotation(fieldPath.toString());
        JsonValue v = this.getKeyValueAt(fieldPath.iterator());
        if (v != null) {
            return v.getMap();
        }
        return null;
    }

    @Override
    public List<Object> getList(String fieldPath) {
        return this.getList(FieldPath.parseFrom(fieldPath));
    }

    @Override
    public List<Object> getList(FieldPath fieldPath) {
        this.checkForArrayNotation(fieldPath.toString());
        JsonValue v = this.getKeyValueAt(fieldPath.iterator());
        if (v != null) {
            return v.getList();
        }
        return null;
    }

    @Override
    public JsonDocument empty() {
        this.getRootMap().clear();
        return this;
    }

    @Override
    public DocumentReader asReader() {
        if (this.jsonDocumentReader == null) {
            return new JsonDOMDocumentReader(this);
        }
        return this.jsonDocumentReader;
    }

    @Override
    public DocumentReader asReader(FieldPath fieldPath) {
        JsonValue val = this.getValue(fieldPath);
        return new JsonDOMDocumentReader(val);
    }

    @Override
    public DocumentReader asReader(String fieldPath) {
        return this.asReader(FieldPath.parseFrom(fieldPath));
    }

    @Override
    public Iterator<Map.Entry<String, Value>> iterator() {
        return new JsonDocumentIterator();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getRootMap().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        JsonValue v = JsonValueBuilder.initFromObject(value);
        return this.getRootMap().containsValue(v);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        LinkedHashSet<Map.Entry<String, Object>> s = new LinkedHashSet<Map.Entry<String, Object>>();
        for (String k : this.getRootMap().keySet()) {
            AbstractMap.SimpleImmutableEntry<String, Object> newEntry = new AbstractMap.SimpleImmutableEntry<String, Object>(k, this.getRootMap().get(k).getObject());
            s.add(newEntry);
        }
        return s;
    }

    @Override
    public Object get(Object key) {
        JsonValue value = this.getRootMap().get(key);
        if (value != null) {
            return value.getObject();
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.getRootMap().isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.getRootMap().keySet();
    }

    @Override
    public Object put(String arg0, Object arg1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(Object arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.getRootMap().size();
    }

    @Override
    public Collection<Object> values() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (JsonValue v : this.getRootMap().values()) {
            list.add(v.getObject());
        }
        return list;
    }

    @Override
    public Document set(String fieldPath, String value) {
        return this.set(FieldPath.parseFrom(fieldPath), value);
    }

    @Override
    public Document set(String fieldPath, boolean value) {
        return this.set(FieldPath.parseFrom(fieldPath), value);
    }

    @Override
    public Document set(String fieldPath, byte value) {
        return this.set(FieldPath.parseFrom(fieldPath), value);
    }

    @Override
    public Document set(String fieldPath, short value) {
        return this.set(FieldPath.parseFrom(fieldPath), value);
    }

    @Override
    public Document set(String fieldPath, int value) {
        return this.set(FieldPath.parseFrom(fieldPath), value);
    }

    @Override
    public Document set(String fieldPath, long value) {
        return this.set(FieldPath.parseFrom(fieldPath), value);
    }

    @Override
    public Document set(String fieldPath, float value) {
        return this.setCommon(FieldPath.parseFrom(fieldPath), JsonValueBuilder.initFrom(value));
    }

    @Override
    public Document set(String fieldPath, double value) {
        return this.setCommon(FieldPath.parseFrom(fieldPath), JsonValueBuilder.initFrom(value));
    }

    @Override
    public Document set(String fieldPath, BigDecimal value) {
        return this.setCommon(FieldPath.parseFrom(fieldPath), JsonValueBuilder.initFrom(value));
    }

    @Override
    public Document set(String fieldPath, OTime value) {
        return this.setCommon(FieldPath.parseFrom(fieldPath), JsonValueBuilder.initFrom(value));
    }

    @Override
    public Document set(String fieldPath, ODate value) {
        return this.setCommon(FieldPath.parseFrom(fieldPath), JsonValueBuilder.initFrom(value));
    }

    @Override
    public JsonDocument set(String field, byte[] value) {
        return this.setCommon(FieldPath.parseFrom(field), JsonValueBuilder.initFrom(ByteBuffer.wrap(value)));
    }

    @Override
    public JsonDocument set(FieldPath field, byte[] value) {
        return this.setCommon(field, JsonValueBuilder.initFrom(ByteBuffer.wrap(value)));
    }

    @Override
    public JsonDocument set(String field, byte[] value, int off, int len) {
        return this.setCommon(FieldPath.parseFrom(field), JsonValueBuilder.initFrom(ByteBuffer.wrap(value, off, len)));
    }

    @Override
    public JsonDocument set(FieldPath field, byte[] value, int off, int len) {
        return this.setCommon(field, JsonValueBuilder.initFrom(ByteBuffer.wrap(value, off, len)));
    }

    @Override
    public JsonDocument set(String field, ByteBuffer value) {
        return this.setCommon(FieldPath.parseFrom(field), JsonValueBuilder.initFrom(value));
    }

    @Override
    public JsonDocument set(FieldPath field, ByteBuffer value) {
        return this.setCommon(field, JsonValueBuilder.initFrom(value));
    }

    private Document setCommonFromObjectArray(FieldPath field, Object[] values) {
        return this.setCommon(field, JsonValueBuilder.initFromArray((Object)values));
    }

    @Override
    public Document setArray(String fieldPath, byte[] values) {
        return this.setArray(FieldPath.parseFrom(fieldPath), values);
    }

    @Override
    public Document setArray(FieldPath fieldPath, byte[] values) {
        return this.setCommon(fieldPath, JsonValueBuilder.initFromArray((Object)values));
    }

    @Override
    public Document setArray(String fieldPath, short[] values) {
        return this.setArray(FieldPath.parseFrom(fieldPath), values);
    }

    @Override
    public Document setArray(FieldPath fieldPath, short[] values) {
        return this.setCommon(fieldPath, JsonValueBuilder.initFromArray((Object)values));
    }

    @Override
    public Document setArray(String fieldPath, int[] values) {
        return this.setArray(FieldPath.parseFrom(fieldPath), values);
    }

    @Override
    public Document setArray(FieldPath fieldPath, int[] values) {
        return this.setCommon(fieldPath, JsonValueBuilder.initFromArray((Object)values));
    }

    @Override
    public Document setArray(String fieldPath, long[] values) {
        return this.setArray(FieldPath.parseFrom(fieldPath), values);
    }

    @Override
    public Document setArray(FieldPath fieldPath, long[] values) {
        return this.setCommon(fieldPath, JsonValueBuilder.initFromArray((Object)values));
    }

    @Override
    public Document setArray(String fieldPath, float[] values) {
        return this.setArray(FieldPath.parseFrom(fieldPath), values);
    }

    @Override
    public Document setArray(FieldPath fieldPath, float[] values) {
        return this.setCommon(fieldPath, JsonValueBuilder.initFromArray((Object)values));
    }

    @Override
    public Document setArray(String fieldPath, double[] values) {
        return this.setArray(FieldPath.parseFrom(fieldPath), values);
    }

    @Override
    public Document setArray(FieldPath fieldPath, double[] values) {
        return this.setCommon(fieldPath, JsonValueBuilder.initFromArray((Object)values));
    }

    @Override
    public Document setArray(String fieldPath, String[] values) {
        return this.setArray(FieldPath.parseFrom(fieldPath), values);
    }

    @Override
    public Document setArray(FieldPath fieldPath, String[] values) {
        return this.setCommonFromObjectArray(fieldPath, values);
    }

    @Override
    public Document setArray(String fieldPath, Object ... values) {
        return this.setArray(FieldPath.parseFrom(fieldPath), values);
    }

    @Override
    public Document setArray(FieldPath fieldPath, Object ... values) {
        return this.setCommonFromObjectArray(fieldPath, values);
    }

    @Override
    public Document setNull(String fieldPath) {
        return this.setNull(FieldPath.parseFrom(fieldPath));
    }

    @Override
    public String getString(String fieldPath) {
        return this.getString(FieldPath.parseFrom(fieldPath));
    }

    @Override
    public BigDecimal getDecimal(String fieldPath) {
        return this.getDecimal(FieldPath.parseFrom(fieldPath));
    }

    @Override
    public ByteBuffer getBinary(String field) {
        return this.getBinary(FieldPath.parseFrom(field));
    }

    @Override
    public ByteBuffer getBinary(FieldPath field) {
        JsonValue v = this.getKeyValueAt(field.iterator());
        if (v != null) {
            return v.getBinary();
        }
        return null;
    }

    @Override
    public OTimestamp getTimestamp(String fieldPath) {
        return this.getTimestamp(FieldPath.parseFrom(fieldPath));
    }

    @Override
    public OTimestamp getTimestamp(FieldPath fieldPath) {
        JsonValue v = this.getKeyValueAt(fieldPath.iterator());
        if (v != null) {
            return v.getTimestamp();
        }
        return null;
    }

    @Override
    public OInterval getInterval(String fieldPath) {
        return this.getInterval(FieldPath.parseFrom(fieldPath));
    }

    @Override
    public OInterval getInterval(FieldPath fieldPath) {
        JsonValue v = this.getKeyValueAt(fieldPath.iterator());
        if (v != null) {
            return v.getInterval();
        }
        return null;
    }

    @Override
    public Map<String, Object> getMap(String fieldPath) {
        return this.getMap(FieldPath.parseFrom(fieldPath));
    }

    @Override
    public OTime getTime(String field) {
        return this.getTime(FieldPath.parseFrom(field));
    }

    @Override
    public OTime getTime(FieldPath field) {
        JsonValue v = this.getKeyValueAt(field.iterator());
        if (v != null) {
            return v.getTime();
        }
        return null;
    }

    @Override
    public ODate getDate(String field) {
        return this.getDate(FieldPath.parseFrom(field));
    }

    @Override
    public ODate getDate(FieldPath field) {
        JsonValue v = this.getKeyValueAt(field.iterator());
        if (v != null) {
            return v.getDate();
        }
        return null;
    }

    @Override
    public Value getValue(String fieldPath) {
        return this.getValue(FieldPath.parseFrom(fieldPath));
    }

    @Override
    public Document set(String fieldPath, Map<String, ? extends Object> value) {
        return this.set(FieldPath.parseFrom(fieldPath), value);
    }

    @Override
    public Document set(FieldPath fieldPath, Map<String, ? extends Object> value) {
        return this.setCommon(fieldPath, JsonValueBuilder.initFrom(value));
    }

    @Override
    public Document set(String fieldPath, List<? extends Object> value) {
        return this.set(FieldPath.parseFrom(fieldPath), value);
    }

    @Override
    public Document set(FieldPath fieldPath, List<? extends Object> value) {
        return this.setCommon(fieldPath, JsonValueBuilder.initFrom(value));
    }

    @Override
    public JsonDocument shallowCopy() {
        JsonDocument rec = new JsonDocument();
        rec.objValue = this.objValue;
        rec.jsonValue = this.jsonValue;
        return rec;
    }

    Map<String, JsonValue> getRootMap() {
        if (this.objValue == null) {
            this.objValue = new LinkedHashMap();
        }
        return (Map)this.objValue;
    }

    @Override
    public Document setArray(String fieldPath, boolean[] values) {
        return this.setArray(FieldPath.parseFrom(fieldPath), values);
    }

    @Override
    public Document setArray(FieldPath fieldPath, boolean[] values) {
        return this.setCommon(fieldPath, JsonValueBuilder.initFromArray((Object)values));
    }

    @Override
    public String toString() {
        return this.asJsonString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof Document) {
            return Documents.equals(this, (Document)obj);
        }
        if (obj instanceof Map) {
            return obj.equals(this);
        }
        return false;
    }

    @Override
    public String asJsonString() {
        return this.asJsonString(JsonOptions.DEFAULT);
    }

    @Override
    public String asJsonString(JsonOptions options) {
        return Json.toJsonString(this, options);
    }

    @Override
    public <T> T toJavaBean(Class<T> beanClass) throws DecodingException {
        return BeanCodec.encode(this.asReader(), beanClass);
    }

    @Override
    public Map<String, Object> asMap() throws DecodingException {
        return DocumentReaders.encode(this.asReader());
    }

    class JsonDocumentIterator
    implements Iterator<Map.Entry<String, Value>> {
        Iterator<String> keyIter;

        JsonDocumentIterator() {
            this.keyIter = JsonDocument.this.getRootMap().keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.keyIter.hasNext();
        }

        @Override
        public Map.Entry<String, Value> next() {
            String key = this.keyIter.next();
            JsonValue kv = JsonDocument.this.getRootMap().get(key);
            return new AbstractMap.SimpleImmutableEntry<String, Value>(key, kv);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

