/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iceberg.BaseCombinedScanTask;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.DataTask;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.data.GenericReader;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.io.CloseableGroup;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructProjection;

public class ScanTaskTableScanIterable
extends CloseableGroup
implements CloseableIterable<Record> {
    private final GenericReader reader;
    private final CombinedScanTask genericTask;
    private final List<DataTask> dataTasks;
    private final Types.StructType schema;

    public ScanTaskTableScanIterable(TableScan scan, CombinedScanTask task) {
        this.reader = new GenericReader(scan, false);
        this.dataTasks = new ArrayList<DataTask>();
        this.schema = scan.schema().asStruct();
        ArrayList fileScanTasks = new ArrayList();
        task.files().forEach(scanTask -> {
            if (scanTask.isDataTask()) {
                this.dataTasks.add(scanTask.asDataTask());
            } else {
                fileScanTasks.add(scanTask);
            }
        });
        this.genericTask = new BaseCombinedScanTask(fileScanTasks);
    }

    public CloseableIterator<Record> iterator() {
        List dataTasksIterators = this.dataTasks.stream().map(DataTask::rows).map(rows -> CloseableIterable.transform((CloseableIterable)rows, sl -> ScanTaskTableScanIterable.structLikeToRecord(sl, this.schema))).collect(Collectors.toList());
        dataTasksIterators.add(this.reader.open(this.genericTask));
        CloseableIterator iterator = CloseableIterable.concat(dataTasksIterators).iterator();
        this.addCloseable((Closeable)iterator);
        return iterator;
    }

    private static Record structLikeToRecord(StructLike structLike, Types.StructType schema) {
        GenericRecord genericRecord = GenericRecord.create((Types.StructType)schema);
        for (int i = 0; i < schema.fields().size(); ++i) {
            Object value = structLike.get(i, Object.class);
            if (value instanceof StructProjection) {
                value = ScanTaskTableScanIterable.structLikeToRecord((StructLike)value, ((Types.NestedField)schema.fields().get(i)).type().asStructType());
            }
            genericRecord.set(i, value);
        }
        return genericRecord;
    }
}

