/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.iceberg.read;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.ops.ExecutorFragmentContext;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.impl.BatchCreator;
import org.apache.drill.exec.physical.impl.scan.framework.BasicScanFactory;
import org.apache.drill.exec.physical.impl.scan.framework.ManagedReader;
import org.apache.drill.exec.physical.impl.scan.framework.ManagedScanFramework;
import org.apache.drill.exec.physical.impl.scan.framework.SchemaNegotiator;
import org.apache.drill.exec.record.CloseableRecordBatch;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.store.iceberg.IcebergSubScan;
import org.apache.drill.exec.store.iceberg.IcebergWork;
import org.apache.drill.exec.store.iceberg.read.IcebergRecordReader;
import org.apache.iceberg.TableScan;

public class IcebergScanBatchCreator
implements BatchCreator<IcebergSubScan> {
    public CloseableRecordBatch getBatch(ExecutorFragmentContext context, IcebergSubScan subScan, List<RecordBatch> children) throws ExecutionSetupException {
        Preconditions.checkArgument((boolean)children.isEmpty());
        try {
            ManagedScanFramework.ScanFrameworkBuilder builder = this.createBuilder(subScan);
            return builder.buildScanOperator((FragmentContext)context, (PhysicalOperator)subScan);
        }
        catch (UserException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ExecutionSetupException(e);
        }
    }

    private ManagedScanFramework.ScanFrameworkBuilder createBuilder(IcebergSubScan subScan) {
        ManagedScanFramework.ScanFrameworkBuilder builder = new ManagedScanFramework.ScanFrameworkBuilder();
        builder.projection(subScan.getColumns());
        builder.setUserName(subScan.getUserName());
        builder.providedSchema(subScan.getSchema());
        BasicScanFactory readerFactory = new BasicScanFactory(subScan.getWorkList().stream().map(icebergWork -> IcebergScanBatchCreator.getRecordReader(subScan.getTableScan(), icebergWork, subScan.getMaxRecords())).iterator());
        builder.setReaderFactory((ManagedScanFramework.ReaderFactory)readerFactory);
        builder.nullType(Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.VARCHAR));
        return builder;
    }

    private static ManagedReader<SchemaNegotiator> getRecordReader(TableScan tableScan, IcebergWork icebergWork, int maxRecords) {
        return new IcebergRecordReader(tableScan, icebergWork, maxRecords);
    }
}

