/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.kudu;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.drill.exec.planner.logical.DrillTableSelection;
import org.apache.drill.exec.planner.logical.DynamicDrillTable;
import org.apache.drill.exec.store.StoragePlugin;
import org.apache.drill.exec.store.kudu.KuduScanSpec;
import org.apache.drill.exec.store.kudu.KuduStoragePlugin;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Schema;
import org.apache.kudu.Type;

public class DrillKuduTable
extends DynamicDrillTable {
    private final Schema schema;

    public DrillKuduTable(String storageEngineName, KuduStoragePlugin plugin, Schema schema, KuduScanSpec scanSpec) {
        super((StoragePlugin)plugin, storageEngineName, (DrillTableSelection)scanSpec);
        this.schema = schema;
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        ArrayList names = Lists.newArrayList();
        ArrayList types = Lists.newArrayList();
        for (ColumnSchema column : this.schema.getColumns()) {
            names.add(column.getName());
            RelDataType type = this.getSqlTypeFromKuduType(typeFactory, column.getType());
            type = typeFactory.createTypeWithNullability(type, column.isNullable());
            types.add(type);
        }
        return typeFactory.createStructType((List)types, (List)names);
    }

    private RelDataType getSqlTypeFromKuduType(RelDataTypeFactory typeFactory, Type type) {
        switch (type) {
            case BOOL: {
                return typeFactory.createSqlType(SqlTypeName.BOOLEAN);
            }
            case DOUBLE: {
                return typeFactory.createSqlType(SqlTypeName.DOUBLE);
            }
            case FLOAT: {
                return typeFactory.createSqlType(SqlTypeName.FLOAT);
            }
            case INT16: 
            case INT32: 
            case INT64: 
            case INT8: {
                return typeFactory.createSqlType(SqlTypeName.INTEGER);
            }
            case STRING: {
                return typeFactory.createSqlType(SqlTypeName.VARCHAR);
            }
            case UNIXTIME_MICROS: {
                return typeFactory.createSqlType(SqlTypeName.TIMESTAMP);
            }
            case BINARY: {
                return typeFactory.createSqlType(SqlTypeName.VARBINARY, Integer.MAX_VALUE);
            }
        }
        throw new UnsupportedOperationException("Unsupported type.");
    }
}

