/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.rdbms.operate;

import java.util.List;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface RdbmsOperation {
    public void execute(DSLContext var1);

    public static class Delete
    implements RdbmsOperation {
        private static final Logger logger = LoggerFactory.getLogger(Delete.class);
        private final Table<? extends Record> table;
        private final Condition condition;

        public Delete(Table<? extends Record> table) {
            this(table, (Condition)DSL.trueCondition());
        }

        public Delete(Table<? extends Record> table, Condition condition) {
            this.table = table;
            this.condition = condition;
        }

        public Table<? extends Record> table() {
            return this.table;
        }

        public Condition condition() {
            return this.condition;
        }

        @Override
        public void execute(DSLContext executor) {
            logger.debug("Deleting data from RDBMS Metastore table {} using condition: {}", this.table, (Object)this.condition);
            executor.deleteFrom(this.table).where(this.condition).execute();
        }
    }

    public static class Overwrite
    implements RdbmsOperation {
        private static final Logger logger = LoggerFactory.getLogger(Overwrite.class);
        private final Table<? extends Record> table;
        private final List<Condition> deleteConditions;
        private final List<? extends Record> records;

        public Overwrite(Table<? extends Record> table, List<Condition> deleteConditions, List<? extends Record> records) {
            this.table = table;
            this.deleteConditions = deleteConditions;
            this.records = records;
        }

        public Table<? extends Record> table() {
            return this.table;
        }

        public List<Condition> deleteConditions() {
            return this.deleteConditions;
        }

        public List<? extends Record> records() {
            return this.records;
        }

        @Override
        public void execute(DSLContext executor) {
            this.deleteConditions.forEach(condition -> {
                logger.debug("Deleting data from RDBMS Metastore table {} during overwrite using condition: {}", this.table, condition);
                executor.deleteFrom(this.table).where(condition).execute();
            });
            this.records.forEach(record -> {
                logger.debug("Inserting data into RDBMS Metastore table {}:\n{}", this.table, record);
                executor.insertInto(this.table).set(record).execute();
            });
        }
    }
}

