/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.transfer.internal;

import com.oracle.bmc.io.DuplicatableInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamChunkCreator {
    private static final Logger LOG = LoggerFactory.getLogger(StreamChunkCreator.class);
    private final InputStream source;
    private final long chunkLength;
    private final long sourceLength;
    private long startPosition = 0L;
    private long endPosition = 0L;

    public StreamChunkCreator(InputStream stream, long contentLength, long chunkLength) {
        this.source = stream;
        this.sourceLength = contentLength;
        this.chunkLength = chunkLength;
    }

    public boolean supportsParallelReads() {
        return this.isSrcStreamDuplicable();
    }

    private boolean isSrcStreamDuplicable() {
        return this.source instanceof DuplicatableInputStream;
    }

    public boolean hasMore() {
        return this.startPosition < this.sourceLength;
    }

    public SubRangeInputStream next() {
        if (!this.hasMore()) {
            throw new IllegalStateException("No more chunks can be created");
        }
        this.endPosition = this.sourceLength - this.chunkLength > this.startPosition ? (this.endPosition += this.chunkLength) : this.sourceLength;
        SubRangeInputStream rangeInputStream = null;
        rangeInputStream = this.isSrcStreamDuplicable() ? new DuplicatedSubRangeInputStream((DuplicatableInputStream)this.source, this.startPosition, this.endPosition) : new SubRangeInputStream(this.source, this.startPosition, this.endPosition, this.startPosition, false);
        this.startPosition = this.endPosition;
        return rangeInputStream;
    }

    public static class SubRangeInputStream
    extends InputStream {
        private static final int MAX_SKIP_ATTEMPTS = 50;
        protected final InputStream source;
        private final long desiredStartPositionInSource;
        private final long desiredEndPositionInSource;
        private final boolean closeSource;
        protected long currentStartPositionInSource;
        private long totalBytesRead = 0L;

        public SubRangeInputStream(InputStream source, long desiredStartPositionInSource, long desiredEndPositionInSource, long currentStartPositionInSource, boolean closeSource) {
            this.source = source;
            this.desiredStartPositionInSource = desiredStartPositionInSource;
            this.desiredEndPositionInSource = desiredEndPositionInSource;
            this.currentStartPositionInSource = currentStartPositionInSource;
            this.closeSource = closeSource;
        }

        @Override
        public int read() throws IOException {
            byte[] bytes = new byte[1];
            int bytesRead = this.read(bytes, 0, 1);
            if (bytesRead == -1) {
                return bytesRead;
            }
            return bytes[0];
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int remainingSkipAttempts = 50;
            while (this.currentStartPositionInSource < this.desiredStartPositionInSource) {
                long bytesSkipped = this.source.skip(this.desiredStartPositionInSource - this.currentStartPositionInSource);
                if (bytesSkipped == 0L && --remainingSkipAttempts == 0) {
                    throw new IllegalStateException("Could not set stream to start byte of " + this.desiredStartPositionInSource);
                }
                this.currentStartPositionInSource += bytesSkipped;
            }
            long bytesRemaining = this.desiredEndPositionInSource - this.currentStartPositionInSource;
            if (bytesRemaining <= 0L) {
                return -1;
            }
            if (bytesRemaining < (long)len) {
                len = (int)bytesRemaining;
            }
            int bytesRead = this.source.read(b, off, len);
            this.currentStartPositionInSource += (long)bytesRead;
            this.totalBytesRead += (long)bytesRead;
            return bytesRead;
        }

        public long length() {
            return this.desiredEndPositionInSource - this.desiredStartPositionInSource;
        }

        @Override
        public int available() throws IOException {
            if (this.currentStartPositionInSource < this.desiredEndPositionInSource) {
                long diff = this.desiredEndPositionInSource - this.currentStartPositionInSource;
                if (diff > Integer.MAX_VALUE) {
                    return Integer.MAX_VALUE;
                }
                return (int)diff;
            }
            return 0;
        }

        @Override
        public void close() throws IOException {
            LOG.debug("Total bytes read {}, expected bytes {}", (Object)this.totalBytesRead, (Object)this.length());
            if (this.closeSource) {
                this.source.close();
            }
        }
    }

    public static class DuplicatedSubRangeInputStream
    extends SubRangeInputStream
    implements DuplicatableInputStream {
        private final long desiredStartPositionInSource;
        private final long desiredEndPositionInSource;
        private final DuplicatableInputStream duplicatableInputStream;
        private long markPosition;

        public DuplicatedSubRangeInputStream(DuplicatableInputStream source, long desiredStartPositionInSource, long desiredEndPositionInSource) {
            super(source.duplicate(), desiredStartPositionInSource, desiredEndPositionInSource, 0L, true);
            this.markPosition = this.currentStartPositionInSource;
            this.duplicatableInputStream = source;
            this.desiredStartPositionInSource = desiredStartPositionInSource;
            this.desiredEndPositionInSource = desiredEndPositionInSource;
        }

        @Override
        public boolean markSupported() {
            return this.source.markSupported();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.source.mark(readlimit);
            this.markPosition = this.currentStartPositionInSource;
        }

        @Override
        public synchronized void reset() throws IOException {
            this.source.reset();
            this.currentStartPositionInSource = this.markPosition;
        }

        public InputStream duplicate() {
            LOG.info("Creating a duplicate");
            return new DuplicatedSubRangeInputStream(this.duplicatableInputStream, this.desiredStartPositionInSource, this.desiredEndPositionInSource);
        }
    }
}

