/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.transfer;

import com.oracle.bmc.objectstorage.ObjectStorage;
import com.oracle.bmc.objectstorage.internal.ObjectStorageUtils;
import com.oracle.bmc.objectstorage.model.CommitMultipartUploadDetails;
import com.oracle.bmc.objectstorage.model.CreateMultipartUploadDetails;
import com.oracle.bmc.objectstorage.model.MultipartUpload;
import com.oracle.bmc.objectstorage.model.MultipartUploadPartSummary;
import com.oracle.bmc.objectstorage.model.StorageTier;
import com.oracle.bmc.objectstorage.requests.AbortMultipartUploadRequest;
import com.oracle.bmc.objectstorage.requests.CommitMultipartUploadRequest;
import com.oracle.bmc.objectstorage.requests.CreateMultipartUploadRequest;
import com.oracle.bmc.objectstorage.requests.ListMultipartUploadPartsRequest;
import com.oracle.bmc.objectstorage.requests.ListMultipartUploadsRequest;
import com.oracle.bmc.objectstorage.requests.UploadPartRequest;
import com.oracle.bmc.objectstorage.responses.AbortMultipartUploadResponse;
import com.oracle.bmc.objectstorage.responses.CommitMultipartUploadResponse;
import com.oracle.bmc.objectstorage.responses.CreateMultipartUploadResponse;
import com.oracle.bmc.objectstorage.responses.ListMultipartUploadPartsResponse;
import com.oracle.bmc.objectstorage.responses.ListMultipartUploadsResponse;
import com.oracle.bmc.objectstorage.transfer.MultipartManifest;
import com.oracle.bmc.objectstorage.transfer.UploadManager;
import com.oracle.bmc.objectstorage.transfer.internal.MultipartManifestImpl;
import com.oracle.bmc.objectstorage.transfer.internal.MultipartTransferManager;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.StreamUtils;
import com.oracle.bmc.util.internal.Consumer;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.ws.rs.client.Invocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipartObjectAssembler {
    private static final Logger LOG = LoggerFactory.getLogger(MultipartObjectAssembler.class);
    private static final int MAX_CLIENT_REQUEST_ID_LENGTH = 40;
    private final ObjectStorage service;
    private final String namespaceName;
    private final String bucketName;
    private final String objectName;
    private final StorageTier storageTier;
    private final Consumer<Invocation.Builder> invocationCallback;
    private final boolean allowOverwrite;
    private final ExecutorService executorService;
    private final String cacheControl;
    private final String contentDisposition;
    private MultipartTransferManager transferManager;
    private MultipartManifestImpl manifest;
    private boolean initialized = false;
    private RetryConfiguration retryConfiguration;
    private String opcClientRequestId = null;

    @Deprecated
    public MultipartObjectAssembler(ObjectStorage service, String namespaceName, String bucketName, String objectName, boolean allowOverwrite, ExecutorService executorService) {
        this(service, namespaceName, bucketName, objectName, StorageTier.Standard, allowOverwrite, executorService, null, null, UploadManager.RETRY_CONFIGURATION, null, null);
    }

    private MultipartObjectAssembler(ObjectStorage service, String namespaceName, String bucketName, String objectName, StorageTier storageTier, boolean allowOverwrite, ExecutorService executorService, String opcClientRequestId, Consumer<Invocation.Builder> invocationCallback, RetryConfiguration retryConfiguration, String cacheControl, String contentDisposition) {
        this.service = service;
        this.namespaceName = namespaceName;
        this.bucketName = bucketName;
        this.objectName = objectName;
        this.storageTier = storageTier;
        this.allowOverwrite = allowOverwrite;
        this.executorService = executorService;
        this.opcClientRequestId = opcClientRequestId;
        this.invocationCallback = invocationCallback;
        this.retryConfiguration = retryConfiguration;
        this.cacheControl = cacheControl;
        this.contentDisposition = contentDisposition;
    }

    public synchronized MultipartManifest newRequest(String contentType, String contentLanguage, String contentEncoding, Map<String, String> opcMeta) {
        this.checkInitialized();
        String ifNoneMatch = ObjectStorageUtils.getIfNoneMatchHeader(this.allowOverwrite);
        CreateMultipartUploadResponse createUploadResponse = this.service.createMultipartUpload(CreateMultipartUploadRequest.builder().invocationCallback(this.invocationCallback).bucketName(this.bucketName).ifNoneMatch(ifNoneMatch).namespaceName(this.namespaceName).createMultipartUploadDetails(CreateMultipartUploadDetails.builder().object(this.objectName).contentEncoding(contentEncoding).contentLanguage(contentLanguage).contentType(contentType).metadata(opcMeta).cacheControl(this.cacheControl).contentDisposition(this.contentDisposition).storageTier(this.storageTier).build()).opcClientRequestId(this.createClientRequestId("-create")).build());
        this.manifest = new MultipartManifestImpl(createUploadResponse.getMultipartUpload().getUploadId());
        this.transferManager = new MultipartTransferManager(this.executorService, this.manifest, this.service);
        this.initialized = true;
        return this.manifest;
    }

    public synchronized MultipartManifest resumeRequest(String uploadId) {
        ListMultipartUploadPartsResponse parts;
        this.checkInitialized();
        MultipartUpload existingUpload = this.find(uploadId);
        if (existingUpload == null) {
            throw new IllegalArgumentException("Could not find existing upload with ID " + uploadId + " in namespace/bucket " + this.namespaceName + "/" + this.bucketName);
        }
        MultipartManifestImpl manifest = new MultipartManifestImpl(uploadId);
        String nextPageToken = null;
        do {
            parts = this.service.listMultipartUploadParts(ListMultipartUploadPartsRequest.builder().invocationCallback(this.invocationCallback).namespaceName(this.namespaceName).bucketName(this.bucketName).objectName(this.objectName).uploadId(uploadId).opcClientRequestId(this.createClientRequestId("-list")).limit(Integer.valueOf(100)).page(nextPageToken).build());
            for (MultipartUploadPartSummary part : parts.getItems()) {
                manifest.registerExisting(part);
            }
        } while ((nextPageToken = parts.getOpcNextPage()) != null);
        this.manifest = manifest;
        this.transferManager = new MultipartTransferManager(this.executorService, this.manifest, this.service);
        this.initialized = true;
        return manifest;
    }

    private void checkInitialized() {
        if (this.initialized) {
            throw new IllegalStateException("Assembler has already been initialized");
        }
    }

    public int addPart(File file, String md5) {
        InputStream stream = StreamUtils.toInputStream((File)file);
        return this.addPart(stream, file.length(), md5);
    }

    public int addPart(InputStream stream, long contentLength, String md5) {
        int nextPartNumber = this.manifest.nextPartNumber();
        return this.doUploadPart(stream, contentLength, md5, nextPartNumber);
    }

    public void setPart(File file, String md5, int partNum) {
        InputStream stream = StreamUtils.toInputStream((File)file);
        this.setPart(stream, file.length(), md5, partNum);
    }

    public void setPart(InputStream stream, long contentLength, String md5, int partNum) {
        this.doUploadPart(stream, contentLength, md5, partNum);
    }

    private int doUploadPart(InputStream stream, long contentLength, String md5, int partNumber) {
        this.validateState();
        UploadPartRequest request = UploadPartRequest.builder().invocationCallback(this.invocationCallback).namespaceName(this.namespaceName).bucketName(this.bucketName).objectName(this.objectName).contentMD5(md5).contentLength(Long.valueOf(contentLength)).uploadId(this.manifest.getUploadId()).uploadPartNum(Integer.valueOf(partNumber)).uploadPartBody(stream).opcClientRequestId(this.createClientRequestId("-" + partNumber)).build();
        request.setRetryConfiguration(this.retryConfiguration);
        this.transferManager.startTransfer(request);
        return partNumber;
    }

    public AbortMultipartUploadResponse abort() {
        this.validateState(true);
        this.transferManager.abortAll();
        this.manifest.markUploadAborted();
        return this.service.abortMultipartUpload(AbortMultipartUploadRequest.builder().invocationCallback(this.invocationCallback).namespaceName(this.namespaceName).bucketName(this.bucketName).objectName(this.objectName).uploadId(this.manifest.getUploadId()).opcClientRequestId(this.createClientRequestId("-abort")).build());
    }

    public CommitMultipartUploadResponse commit() {
        this.validateState();
        this.transferManager.awaitCompletion();
        if (!this.manifest.isUploadSuccessful()) {
            throw new IllegalStateException("One or more parts were have not completed upload successfully");
        }
        return this.service.commitMultipartUpload(CommitMultipartUploadRequest.builder().invocationCallback(this.invocationCallback).namespaceName(this.namespaceName).bucketName(this.bucketName).objectName(this.objectName).uploadId(this.manifest.getUploadId()).commitMultipartUploadDetails(CommitMultipartUploadDetails.builder().partsToCommit(this.manifest.listCompletedParts()).partsToExclude(new ArrayList(0)).build()).opcClientRequestId(this.createClientRequestId("-commit")).build());
    }

    private MultipartUpload find(String uploadId) {
        ListMultipartUploadsResponse uploads;
        String nextPageToken = null;
        do {
            uploads = this.service.listMultipartUploads(ListMultipartUploadsRequest.builder().invocationCallback(this.invocationCallback).namespaceName(this.namespaceName).bucketName(this.bucketName).limit(Integer.valueOf(100)).page(nextPageToken).opcClientRequestId(this.createClientRequestId("-find")).build());
            for (MultipartUpload upload : uploads.getItems()) {
                if (!uploadId.equals(upload.getUploadId())) continue;
                return upload;
            }
        } while ((nextPageToken = uploads.getOpcNextPage()) != null);
        return null;
    }

    private synchronized void validateState(boolean allowAborted) {
        if (this.manifest == null) {
            throw new IllegalStateException("Assember has not been initialized, must call newRequest or resumeRequest first");
        }
        if (!allowAborted && this.manifest.isUploadAborted()) {
            throw new IllegalStateException("Cannot complete request, upload has already been aborted");
        }
    }

    private synchronized void validateState() {
        this.validateState(false);
    }

    private String createClientRequestId(String suffix) {
        if (this.opcClientRequestId == null) {
            return suffix;
        }
        if (this.opcClientRequestId.length() > 40) {
            String truncatedUserId = this.opcClientRequestId.substring(0, 40);
            LOG.debug("Client request ID too long, truncating to '{}' to avoid errors", (Object)truncatedUserId);
            return truncatedUserId;
        }
        String newClientRequestId = this.opcClientRequestId + suffix;
        if (newClientRequestId.length() > 40) {
            newClientRequestId = newClientRequestId.substring(0, 40);
        }
        LOG.debug("Converted client request ID to '{}'", (Object)newClientRequestId);
        return newClientRequestId;
    }

    public static MultipartObjectAssemblerBuilder builder() {
        return new MultipartObjectAssemblerBuilder();
    }

    public void setOpcClientRequestId(String opcClientRequestId) {
        this.opcClientRequestId = opcClientRequestId;
    }

    public static class MultipartObjectAssemblerBuilder {
        private ObjectStorage service;
        private String namespaceName;
        private String bucketName;
        private String objectName;
        private StorageTier storageTier;
        private boolean allowOverwrite;
        private ExecutorService executorService;
        private String opcClientRequestId;
        private Consumer<Invocation.Builder> invocationCallback;
        private RetryConfiguration retryConfiguration;
        private String cacheControl;
        private String contentDisposition;

        MultipartObjectAssemblerBuilder() {
        }

        public MultipartObjectAssemblerBuilder service(ObjectStorage service) {
            this.service = service;
            return this;
        }

        public MultipartObjectAssemblerBuilder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public MultipartObjectAssemblerBuilder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public MultipartObjectAssemblerBuilder objectName(String objectName) {
            this.objectName = objectName;
            return this;
        }

        public MultipartObjectAssemblerBuilder storageTier(StorageTier storageTier) {
            this.storageTier = storageTier;
            return this;
        }

        public MultipartObjectAssemblerBuilder allowOverwrite(boolean allowOverwrite) {
            this.allowOverwrite = allowOverwrite;
            return this;
        }

        public MultipartObjectAssemblerBuilder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public MultipartObjectAssemblerBuilder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public MultipartObjectAssemblerBuilder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public MultipartObjectAssemblerBuilder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public MultipartObjectAssemblerBuilder cacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
            return this;
        }

        public MultipartObjectAssemblerBuilder contentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
            return this;
        }

        public MultipartObjectAssembler build() {
            return new MultipartObjectAssembler(this.service, this.namespaceName, this.bucketName, this.objectName, this.storageTier, this.allowOverwrite, this.executorService, this.opcClientRequestId, this.invocationCallback, this.retryConfiguration, this.cacheControl, this.contentDisposition);
        }

        public String toString() {
            return "MultipartObjectAssembler.MultipartObjectAssemblerBuilder(service=" + this.service + ", namespaceName=" + this.namespaceName + ", bucketName=" + this.bucketName + ", objectName=" + this.objectName + ", storageTier=" + this.storageTier + ", allowOverwrite=" + this.allowOverwrite + ", executorService=" + this.executorService + ", opcClientRequestId=" + this.opcClientRequestId + ", invocationCallback=" + this.invocationCallback + ", retryConfiguration=" + this.retryConfiguration + ", cacheControl=" + this.cacheControl + ", contentDisposition=" + this.contentDisposition + ")";
        }
    }
}

