/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.shaded.org.apache.twill.zookeeper;

import javax.annotation.Nullable;
import org.apache.tephra.shaded.org.apache.twill.common.Cancellable;
import org.apache.tephra.shaded.org.apache.twill.zookeeper.ACLData;
import org.apache.tephra.shaded.org.apache.twill.zookeeper.ForwardingZKClient;
import org.apache.tephra.shaded.org.apache.twill.zookeeper.ForwardingZKClientService;
import org.apache.tephra.shaded.org.apache.twill.zookeeper.NodeChildren;
import org.apache.tephra.shaded.org.apache.twill.zookeeper.NodeData;
import org.apache.tephra.shaded.org.apache.twill.zookeeper.OperationFuture;
import org.apache.tephra.shaded.org.apache.twill.zookeeper.ZKClient;
import org.apache.tephra.shaded.org.apache.twill.zookeeper.ZKClientService;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

public final class ZKClientServices {
    public static ZKClientService delegate(ZKClient client) {
        ZKClient zkClient = client;
        while (!(zkClient instanceof ZKClientService) && zkClient instanceof ForwardingZKClient) {
            zkClient = ((ForwardingZKClient)zkClient).getDelegate();
        }
        if (zkClient instanceof ZKClientService) {
            return ZKClientServices.delegate(client, (ZKClientService)zkClient);
        }
        throw new IllegalArgumentException("No ZKClientService found from the delegation hierarchy");
    }

    public static ZKClientService delegate(final ZKClient client, ZKClientService clientService) {
        return new ForwardingZKClientService(clientService){

            @Override
            public Long getSessionId() {
                return client.getSessionId();
            }

            @Override
            public String getConnectString() {
                return client.getConnectString();
            }

            @Override
            public Cancellable addConnectionWatcher(Watcher watcher) {
                return client.addConnectionWatcher(watcher);
            }

            @Override
            public OperationFuture<String> create(String path, @Nullable byte[] data, CreateMode createMode, boolean createParent, Iterable<ACL> acl) {
                return client.create(path, data, createMode, createParent, acl);
            }

            @Override
            public OperationFuture<Stat> exists(String path, @Nullable Watcher watcher) {
                return client.exists(path, watcher);
            }

            @Override
            public OperationFuture<NodeChildren> getChildren(String path, @Nullable Watcher watcher) {
                return client.getChildren(path, watcher);
            }

            @Override
            public OperationFuture<NodeData> getData(String path, @Nullable Watcher watcher) {
                return client.getData(path, watcher);
            }

            @Override
            public OperationFuture<Stat> setData(String dataPath, byte[] data, int version) {
                return client.setData(dataPath, data, version);
            }

            @Override
            public OperationFuture<String> delete(String deletePath, int version) {
                return client.delete(deletePath, version);
            }

            @Override
            public OperationFuture<ACLData> getACL(String path) {
                return client.getACL(path);
            }

            @Override
            public OperationFuture<Stat> setACL(String path, Iterable<ACL> acl, int version) {
                return client.setACL(path, acl, version);
            }
        };
    }

    private ZKClientServices() {
    }
}

