/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.shaded.org.apache.twill.internal.zookeeper;

import javax.annotation.Nullable;
import org.apache.tephra.shaded.com.google.common.util.concurrent.FutureCallback;
import org.apache.tephra.shaded.com.google.common.util.concurrent.Futures;
import org.apache.tephra.shaded.org.apache.twill.common.Cancellable;
import org.apache.tephra.shaded.org.apache.twill.common.Threads;
import org.apache.tephra.shaded.org.apache.twill.internal.zookeeper.SettableOperationFuture;
import org.apache.tephra.shaded.org.apache.twill.zookeeper.ACLData;
import org.apache.tephra.shaded.org.apache.twill.zookeeper.ForwardingZKClient;
import org.apache.tephra.shaded.org.apache.twill.zookeeper.NodeChildren;
import org.apache.tephra.shaded.org.apache.twill.zookeeper.NodeData;
import org.apache.tephra.shaded.org.apache.twill.zookeeper.OperationFuture;
import org.apache.tephra.shaded.org.apache.twill.zookeeper.ZKClient;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

public final class NamespaceZKClient
extends ForwardingZKClient {
    private final String namespace;
    private final ZKClient delegate;
    private final String connectString;

    public NamespaceZKClient(ZKClient delegate, String namespace) {
        super(delegate);
        this.namespace = namespace;
        this.delegate = delegate;
        this.connectString = delegate.getConnectString() + namespace;
    }

    @Override
    public Long getSessionId() {
        return this.delegate.getSessionId();
    }

    @Override
    public String getConnectString() {
        return this.connectString;
    }

    @Override
    public Cancellable addConnectionWatcher(Watcher watcher) {
        return this.delegate.addConnectionWatcher(watcher);
    }

    @Override
    public OperationFuture<String> create(String path, @Nullable byte[] data, CreateMode createMode, boolean createParent, Iterable<ACL> acl) {
        return this.relayPath(this.delegate.create(this.getNamespacedPath(path), data, createMode, createParent, acl), this.createFuture(path));
    }

    @Override
    public OperationFuture<Stat> exists(String path, @Nullable Watcher watcher) {
        return this.relayFuture(this.delegate.exists(this.getNamespacedPath(path), watcher), this.createFuture(path));
    }

    @Override
    public OperationFuture<NodeChildren> getChildren(String path, @Nullable Watcher watcher) {
        return this.relayFuture(this.delegate.getChildren(this.getNamespacedPath(path), watcher), this.createFuture(path));
    }

    @Override
    public OperationFuture<NodeData> getData(String path, @Nullable Watcher watcher) {
        return this.relayFuture(this.delegate.getData(this.getNamespacedPath(path), watcher), this.createFuture(path));
    }

    @Override
    public OperationFuture<Stat> setData(String dataPath, byte[] data, int version) {
        return this.relayFuture(this.delegate.setData(this.getNamespacedPath(dataPath), data, version), this.createFuture(dataPath));
    }

    @Override
    public OperationFuture<String> delete(String deletePath, int version) {
        return this.relayPath(this.delegate.delete(this.getNamespacedPath(deletePath), version), this.createFuture(deletePath));
    }

    @Override
    public OperationFuture<ACLData> getACL(String path) {
        return this.relayFuture(this.delegate.getACL(this.getNamespacedPath(path)), this.createFuture(path));
    }

    @Override
    public OperationFuture<Stat> setACL(String path, Iterable<ACL> acl, int version) {
        return this.relayFuture(this.delegate.setACL(this.getNamespacedPath(path), acl, version), this.createFuture(path));
    }

    private String getNamespacedPath(String path) {
        if ("/".equals(path)) {
            return this.namespace;
        }
        return this.namespace + path;
    }

    private <V> SettableOperationFuture<V> createFuture(String path) {
        return SettableOperationFuture.create(path, Threads.SAME_THREAD_EXECUTOR);
    }

    private <V> OperationFuture<V> relayFuture(OperationFuture<V> from, final SettableOperationFuture<V> to) {
        Futures.addCallback(from, new FutureCallback<V>(){

            @Override
            public void onSuccess(V result) {
                to.set(result);
            }

            @Override
            public void onFailure(Throwable t) {
                to.setException(t);
            }
        });
        return to;
    }

    private OperationFuture<String> relayPath(final OperationFuture<String> from, final SettableOperationFuture<String> to) {
        from.addListener(new Runnable(){

            @Override
            public void run() {
                try {
                    String relativePath = ((String)from.get()).substring(NamespaceZKClient.this.namespace.length());
                    to.set(relativePath.isEmpty() ? "/" : relativePath);
                }
                catch (Exception e) {
                    to.setException(e.getCause());
                }
            }
        }, Threads.SAME_THREAD_EXECUTOR);
        return to;
    }
}

