/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.shaded.org.apache.twill.internal.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.tephra.shaded.org.apache.twill.api.ResourceSpecification;
import org.apache.tephra.shaded.org.apache.twill.internal.DefaultResourceSpecification;

final class ResourceSpecificationCodec
implements JsonSerializer<ResourceSpecification>,
JsonDeserializer<ResourceSpecification> {
    ResourceSpecificationCodec() {
    }

    public JsonElement serialize(ResourceSpecification src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        json.addProperty("cores", (Number)src.getVirtualCores());
        json.addProperty("memorySize", (Number)src.getMemorySize());
        json.addProperty("instances", (Number)src.getInstances());
        json.addProperty("uplink", (Number)src.getUplink());
        json.addProperty("downlink", (Number)src.getDownlink());
        return json;
    }

    public ResourceSpecification deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObj = json.getAsJsonObject();
        List hosts = (List)context.deserialize((JsonElement)jsonObj.getAsJsonArray("hosts"), List.class);
        List racks = (List)context.deserialize((JsonElement)jsonObj.getAsJsonArray("racks"), List.class);
        return new DefaultResourceSpecification(jsonObj.get("cores").getAsInt(), jsonObj.get("memorySize").getAsInt(), jsonObj.get("instances").getAsInt(), jsonObj.get("uplink").getAsInt(), jsonObj.get("downlink").getAsInt());
    }
}

