/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.shaded.org.apache.twill.internal.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.tephra.shaded.org.apache.twill.api.ResourceReport;
import org.apache.tephra.shaded.org.apache.twill.api.TwillRunResources;
import org.apache.tephra.shaded.org.apache.twill.internal.DefaultResourceReport;

public final class ResourceReportCodec
implements JsonSerializer<ResourceReport>,
JsonDeserializer<ResourceReport> {
    public JsonElement serialize(ResourceReport src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        json.addProperty("appMasterId", src.getApplicationId());
        json.add("appMasterResources", context.serialize((Object)src.getAppMasterResources(), new TypeToken<TwillRunResources>(){}.getType()));
        json.add("runnableResources", context.serialize(src.getResources(), new TypeToken<Map<String, Collection<TwillRunResources>>>(){}.getType()));
        json.add("services", context.serialize(src.getServices(), new TypeToken<List<String>>(){}.getType()));
        return json;
    }

    public ResourceReport deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObj = json.getAsJsonObject();
        String appMasterId = jsonObj.get("appMasterId").getAsString();
        TwillRunResources masterResources = (TwillRunResources)context.deserialize(jsonObj.get("appMasterResources"), TwillRunResources.class);
        Map resources = (Map)context.deserialize(jsonObj.get("runnableResources"), new TypeToken<Map<String, Collection<TwillRunResources>>>(){}.getType());
        List services = (List)context.deserialize(jsonObj.get("services"), new TypeToken<List<String>>(){}.getType());
        return new DefaultResourceReport(appMasterId, masterResources, resources, services);
    }
}

