/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.shaded.org.apache.twill.internal;

import org.apache.tephra.shaded.com.google.common.util.concurrent.FutureCallback;
import org.apache.tephra.shaded.com.google.common.util.concurrent.Futures;
import org.apache.tephra.shaded.com.google.common.util.concurrent.ListenableFuture;
import org.apache.tephra.shaded.com.google.common.util.concurrent.SettableFuture;
import org.apache.tephra.shaded.org.apache.twill.internal.state.Message;
import org.apache.tephra.shaded.org.apache.twill.internal.state.MessageCodec;
import org.apache.tephra.shaded.org.apache.twill.zookeeper.ZKClient;
import org.apache.tephra.shaded.org.apache.twill.zookeeper.ZKOperations;
import org.apache.zookeeper.CreateMode;

public final class ZKMessages {
    public static <V> ListenableFuture<V> sendMessage(ZKClient zkClient, String messagePathPrefix, Message message, V completionResult) {
        SettableFuture result = SettableFuture.create();
        ZKMessages.sendMessage(zkClient, messagePathPrefix, message, result, completionResult);
        return result;
    }

    public static <V> void sendMessage(final ZKClient zkClient, String messagePathPrefix, Message message, final SettableFuture<V> completion, final V completionResult) {
        Futures.addCallback(zkClient.create(messagePathPrefix, MessageCodec.encode(message), CreateMode.PERSISTENT_SEQUENTIAL), new FutureCallback<String>(){

            @Override
            public void onSuccess(String path) {
                Futures.addCallback(ZKOperations.watchDeleted(zkClient, path), new FutureCallback<String>(){

                    @Override
                    public void onSuccess(String result) {
                        completion.set(completionResult);
                    }

                    @Override
                    public void onFailure(Throwable t) {
                        completion.setException(t);
                    }
                });
            }

            @Override
            public void onFailure(Throwable t) {
                completion.setException(t);
            }
        });
    }

    private ZKMessages() {
    }
}

