/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.coprocessor;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tephra.shaded.com.google.common.base.Supplier;
import org.apache.tephra.shaded.com.google.common.util.concurrent.Service;

public class ReferenceCountedSupplier<T extends Service> {
    private static final Log LOG = LogFactory.getLog(ReferenceCountedSupplier.class);
    private final AtomicReference<T> instance = new AtomicReference<Object>(null);
    private final AtomicInteger refCount = new AtomicInteger(0);
    private final Object lock = new Object();
    private final String instanceName;

    public ReferenceCountedSupplier(String instanceName) {
        this.instanceName = instanceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getOrCreate(Supplier<T> instanceSupplier) {
        Object object = this.lock;
        synchronized (object) {
            if (this.instance.get() == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("Creating and starting Service %s.", this.instanceName));
                }
                Service serviceInstance = (Service)instanceSupplier.get();
                serviceInstance.startAndWait();
                this.instance.set(serviceInstance);
            }
            int newCount = this.refCount.incrementAndGet();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Incrementing reference count for Service %s: %d", this.instanceName, newCount));
            }
            return (T)((Service)this.instance.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.lock;
        synchronized (object) {
            if (this.refCount.get() <= 0) {
                LOG.warn((Object)String.format("Reference Count for Service %s is already zero.", this.instanceName));
                return;
            }
            int newCount = this.refCount.decrementAndGet();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Decrementing reference count for Service %s: %d", this.instanceName, newCount));
            }
            if (newCount == 0) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)String.format("Reference Count for Service is 0. Stopping Service %s.", this.instanceName));
                    }
                    Service serviceInstance = (Service)this.instance.get();
                    serviceInstance.stopAndWait();
                    this.instance.set(null);
                }
                catch (Exception ex) {
                    LOG.warn((Object)String.format("Exception while trying to stop Service %s.", this.instanceName), (Throwable)ex);
                }
            }
        }
    }
}

