/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.registry.impl;

import hive.com.google.common.base.Joiner;
import hive.com.google.common.base.Preconditions;
import hive.com.google.common.collect.Lists;
import hive.com.google.common.collect.Sets;
import hive.com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.framework.recipes.nodes.PersistentEphemeralNode;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.CloseableUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.LlapUtil;
import org.apache.hadoop.hive.registry.RegistryUtilities;
import org.apache.hadoop.hive.registry.ServiceInstance;
import org.apache.hadoop.hive.registry.ServiceInstanceStateChangeListener;
import org.apache.hadoop.hive.registry.impl.ZookeeperUtils;
import org.apache.hadoop.registry.client.binding.RegistryUtils;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ZkRegistryBase<InstanceType extends ServiceInstance> {
    private static final Logger LOG = LoggerFactory.getLogger(ZkRegistryBase.class);
    private static final String SASL_NAMESPACE = "sasl";
    private static final String UNSECURE_NAMESPACE = "unsecure";
    protected static final String USER_SCOPE_PATH_PREFIX = "user-";
    protected static final String WORKER_PREFIX = "worker-";
    protected static final String WORKER_GROUP = "workers";
    public static final String UNIQUE_IDENTIFIER = "registry.unique.id";
    protected static final UUID UNIQUE_ID = UUID.randomUUID();
    private static final Joiner PATH_JOINER = Joiner.on("/").skipNulls();
    protected final Configuration conf;
    protected final CuratorFramework zooKeeperClient;
    protected final String workersPath;
    private final String workerNodePrefix;
    protected final RegistryUtils.ServiceRecordMarshal encoder;
    private final Set<ServiceInstanceStateChangeListener<InstanceType>> stateChangeListeners;
    protected final boolean doCheckAcls;
    private final String zkPrincipal;
    private final String zkKeytab;
    private final String saslLoginContextName;
    private String userNameFromPrincipal;
    private final String disableMessage;
    private final Lock instanceCacheLock = new ReentrantLock();
    private final Map<String, InstanceType> pathToInstanceCache;
    private final Map<String, Set<InstanceType>> nodeToInstanceCache;
    private PersistentEphemeralNode znode;
    private String znodePath;
    private PathChildrenCache instancesCache;
    protected static final String hostname = RegistryUtilities.getCanonicalHostName();

    public ZkRegistryBase(String instanceName, Configuration conf, String rootNs, String nsPrefix, String userScopePathPrefix, String workerPrefix, String workerGroup, String zkSaslLoginContextName, String zkPrincipal, String zkKeytab, HiveConf.ConfVars aclsConfig) {
        this.conf = new Configuration(conf);
        this.saslLoginContextName = zkSaslLoginContextName;
        this.zkPrincipal = zkPrincipal;
        this.zkKeytab = zkKeytab;
        if (aclsConfig != null) {
            this.doCheckAcls = HiveConf.getBoolVar(conf, aclsConfig);
            this.disableMessage = "Set " + aclsConfig.varname + " to false to disable ACL validation";
        } else {
            this.doCheckAcls = true;
            this.disableMessage = "";
        }
        this.conf.addResource("yarn-site.xml");
        this.encoder = new RegistryUtils.ServiceRecordMarshal();
        String userPathPrefix = userScopePathPrefix == null ? null : userScopePathPrefix + this.getZkPathUser(conf);
        this.workerNodePrefix = workerPrefix == null ? WORKER_PREFIX : workerPrefix;
        this.workersPath = "/" + PATH_JOINER.join(userPathPrefix, instanceName, workerGroup);
        this.instancesCache = null;
        this.stateChangeListeners = new HashSet<ServiceInstanceStateChangeListener<InstanceType>>();
        this.pathToInstanceCache = new ConcurrentHashMap<String, InstanceType>();
        this.nodeToInstanceCache = new ConcurrentHashMap<String, Set<InstanceType>>();
        String namespace = ZkRegistryBase.getRootNamespace(rootNs, nsPrefix);
        ACLProvider aclProvider = userPathPrefix == null ? (instanceName == null ? (workerGroup == null ? this.getACLProviderForZKPath(namespace) : this.getACLProviderForZKPath(workerGroup)) : this.getACLProviderForZKPath(instanceName)) : this.getACLProviderForZKPath(userScopePathPrefix);
        this.zooKeeperClient = this.getZookeeperClient(conf, namespace, aclProvider);
        this.zooKeeperClient.getConnectionStateListenable().addListener((Object)new ZkConnectionStateListener());
    }

    public static String getRootNamespace(String userProvidedNamespace, String defaultNamespacePrefix) {
        boolean isSecure = UserGroupInformation.isSecurityEnabled();
        Object rootNs = userProvidedNamespace;
        if (rootNs == null) {
            rootNs = defaultNamespacePrefix + (isSecure ? SASL_NAMESPACE : UNSECURE_NAMESPACE);
        }
        return rootNs;
    }

    private ACLProvider getACLProviderForZKPath(final String zkPath) {
        final boolean isSecure = UserGroupInformation.isSecurityEnabled();
        return new ACLProvider(){

            public List<ACL> getDefaultAcl() {
                LOG.warn("getDefaultAcl was called");
                return Lists.newArrayList(ZooDefs.Ids.OPEN_ACL_UNSAFE);
            }

            public List<ACL> getAclForPath(String path) {
                if (!isSecure || path == null || !path.contains(zkPath)) {
                    return Lists.newArrayList(ZooDefs.Ids.OPEN_ACL_UNSAFE);
                }
                return ZkRegistryBase.createSecureAcls();
            }
        };
    }

    private CuratorFramework getZookeeperClient(Configuration conf, String namespace, ACLProvider zooKeeperAclProvider) {
        String zkEnsemble = ZkRegistryBase.getQuorumServers(conf);
        int sessionTimeout = (int)HiveConf.getTimeVar(conf, HiveConf.ConfVars.HIVE_ZOOKEEPER_SESSION_TIMEOUT, TimeUnit.MILLISECONDS);
        int connectionTimeout = (int)HiveConf.getTimeVar(conf, HiveConf.ConfVars.HIVE_ZOOKEEPER_CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS);
        int baseSleepTime = (int)HiveConf.getTimeVar(conf, HiveConf.ConfVars.HIVE_ZOOKEEPER_CONNECTION_BASESLEEPTIME, TimeUnit.MILLISECONDS);
        int maxRetries = HiveConf.getIntVar(conf, HiveConf.ConfVars.HIVE_ZOOKEEPER_CONNECTION_MAX_RETRIES);
        LOG.info("Creating curator client with connectString: {} sessionTimeoutMs: {} connectionTimeoutMs: {} namespace: {} exponentialBackoff - sleepTime: {} maxRetries: {}", new Object[]{zkEnsemble, sessionTimeout, connectionTimeout, namespace, baseSleepTime, maxRetries});
        return CuratorFrameworkFactory.builder().connectString(zkEnsemble).sessionTimeoutMs(sessionTimeout).connectionTimeoutMs(connectionTimeout).aclProvider(zooKeeperAclProvider).namespace(namespace).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(baseSleepTime, maxRetries)).build();
    }

    private static List<ACL> createSecureAcls() {
        ArrayList<ACL> nodeAcls = new ArrayList<ACL>(ZooDefs.Ids.READ_ACL_UNSAFE);
        nodeAcls.addAll(ZooDefs.Ids.CREATOR_ALL_ACL);
        return nodeAcls;
    }

    private static String getQuorumServers(Configuration conf) {
        String[] hosts = conf.getTrimmedStrings(HiveConf.ConfVars.HIVE_ZOOKEEPER_QUORUM.varname);
        String port = conf.get(HiveConf.ConfVars.HIVE_ZOOKEEPER_CLIENT_PORT.varname, HiveConf.ConfVars.HIVE_ZOOKEEPER_CLIENT_PORT.getDefaultValue());
        StringBuilder quorum = new StringBuilder();
        for (int i = 0; i < hosts.length; ++i) {
            quorum.append(hosts[i].trim());
            if (!hosts[i].contains(":")) {
                quorum.append(":");
                quorum.append(port);
            }
            if (i == hosts.length - 1) continue;
            quorum.append(",");
        }
        return quorum.toString();
    }

    protected abstract String getZkPathUser(Configuration var1);

    protected final String registerServiceRecord(ServiceRecord srv) throws IOException {
        return this.registerServiceRecord(srv, UNIQUE_ID.toString());
    }

    protected final String registerServiceRecord(ServiceRecord srv, String uniqueId) throws IOException {
        srv.set(UNIQUE_IDENTIFIER, (Object)uniqueId);
        try {
            this.znode = new PersistentEphemeralNode(this.zooKeeperClient, PersistentEphemeralNode.Mode.EPHEMERAL_SEQUENTIAL, this.workersPath + "/" + this.workerNodePrefix, this.encoder.toBytes((Object)srv));
            this.znode.start();
            long znodeCreationTimeout = 120L;
            if (!this.znode.waitForInitialCreate(znodeCreationTimeout, TimeUnit.SECONDS)) {
                throw new Exception("Max znode creation wait time: " + znodeCreationTimeout + "s exhausted");
            }
            this.znodePath = this.znode.getActualPath();
            if (this.doCheckAcls) {
                try {
                    this.checkAndSetAcls();
                }
                catch (Exception ex) {
                    throw new IOException("Error validating or setting ACLs. " + this.disableMessage, ex);
                }
            }
            if (this.zooKeeperClient.checkExists().forPath(this.znodePath) == null) {
                throw new Exception("Unable to create znode for this instance on ZooKeeper.");
            }
        }
        catch (Exception e) {
            LOG.error("Unable to create a znode for this server instance", (Throwable)e);
            CloseableUtils.closeQuietly((Closeable)this.znode);
            throw e instanceof IOException ? (IOException)e : new IOException(e);
        }
        return uniqueId;
    }

    protected final void updateServiceRecord(ServiceRecord srv, boolean doCheckAcls, boolean closeOnFailure) throws IOException {
        block6: {
            if (srv.get(UNIQUE_IDENTIFIER) == null) {
                srv.set(UNIQUE_IDENTIFIER, (Object)UNIQUE_ID.toString());
            }
            try {
                this.znode.setData(this.encoder.toBytes((Object)srv));
                if (!doCheckAcls) break block6;
                try {
                    this.checkAndSetAcls();
                }
                catch (Exception ex) {
                    throw new IOException("Error validating or setting ACLs. " + this.disableMessage, ex);
                }
            }
            catch (Exception e) {
                LOG.error("Unable to update znode with new service record", (Throwable)e);
                if (closeOnFailure) {
                    CloseableUtils.closeQuietly((Closeable)this.znode);
                }
                throw e instanceof IOException ? (IOException)e : new IOException(e);
            }
        }
    }

    final void initializeWithoutRegisteringInternal() throws IOException {
        block6: {
            try {
                try {
                    this.zooKeeperClient.create().creatingParentsIfNeeded().forPath(this.workersPath);
                }
                catch (KeeperException.NodeExistsException nodeExistsException) {
                    // empty catch block
                }
                if (!this.doCheckAcls) break block6;
                try {
                    this.checkAndSetAcls();
                }
                catch (Exception ex) {
                    throw new IOException("Error validating or setting ACLs. " + this.disableMessage, ex);
                }
            }
            catch (Exception e) {
                LOG.error("Unable to create a parent znode for the registry", (Throwable)e);
                throw e instanceof IOException ? (IOException)e : new IOException(e);
            }
        }
    }

    private void checkAndSetAcls() throws Exception {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        String pathToCheck = this.workersPath;
        List acls = (List)this.zooKeeperClient.getACL().forPath(pathToCheck);
        if (acls == null || acls.isEmpty()) {
            LOG.warn("No ACLs on " + pathToCheck + "; setting up ACLs. " + this.disableMessage);
            this.setUpAcls(pathToCheck);
            return;
        }
        assert (this.userNameFromPrincipal != null);
        Id currentUser = new Id(SASL_NAMESPACE, this.userNameFromPrincipal);
        for (ACL acl : acls) {
            if ((acl.getPerms() & 0xFFFFFFFE) == 0 || currentUser.equals((Object)acl.getId())) continue;
            LOG.warn("The ACL " + acl + " is unnacceptable for " + pathToCheck + "; setting up ACLs. " + this.disableMessage);
            this.setUpAcls(pathToCheck);
            return;
        }
    }

    private void setUpAcls(String path) throws Exception {
        List<ACL> acls = ZkRegistryBase.createSecureAcls();
        LinkedList<Object> paths = new LinkedList<Object>();
        paths.add(path);
        while (!paths.isEmpty()) {
            String currentPath = (String)paths.poll();
            List children = (List)this.zooKeeperClient.getChildren().forPath(currentPath);
            if (children != null) {
                for (String child : children) {
                    paths.add(currentPath + "/" + child);
                }
            }
            ((BackgroundPathable)this.zooKeeperClient.setACL().withACL(acls)).forPath(currentPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToCache(String path, String host, InstanceType instance) {
        this.instanceCacheLock.lock();
        try {
            this.putInInstanceCache(path, this.pathToInstanceCache, instance);
            this.putInNodeCache(host, this.nodeToInstanceCache, instance);
        }
        finally {
            this.instanceCacheLock.unlock();
        }
        LOG.debug("Added path={}, host={} instance={} to cache. pathToInstanceCache:size={}, nodeToInstanceCache:size={}", new Object[]{path, host, instance, this.pathToInstanceCache.size(), this.nodeToInstanceCache.size()});
    }

    private void removeFromCache(String path, String host) {
        this.instanceCacheLock.lock();
        try {
            this.pathToInstanceCache.remove(path);
            this.nodeToInstanceCache.remove(host);
        }
        finally {
            this.instanceCacheLock.unlock();
        }
        LOG.debug("Removed path={}, host={} from cache. pathToInstanceCache:size={}, nodeToInstanceCache:size={}", new Object[]{path, host, this.pathToInstanceCache.size(), this.nodeToInstanceCache.size()});
    }

    private void putInInstanceCache(String key, Map<String, InstanceType> cache, InstanceType instance) {
        cache.put(key, instance);
    }

    private void putInNodeCache(String key, Map<String, Set<InstanceType>> cache, InstanceType instance) {
        Set<InstanceType> instanceSet = cache.get(key);
        if (instanceSet == null) {
            instanceSet = new HashSet<InstanceType>();
            instanceSet.add(instance);
        }
        cache.put(key, instanceSet);
    }

    protected final void populateCache(PathChildrenCache instancesCache, boolean doInvokeListeners) {
        for (ChildData childData : instancesCache.getCurrentData()) {
            String nodeName;
            byte[] data = ZkRegistryBase.getWorkerData(childData, this.workerNodePrefix);
            if (data == null || !(nodeName = ZkRegistryBase.extractNodeName(childData)).startsWith(this.workerNodePrefix)) continue;
            int ephSeqVersion = this.extractSeqNum(nodeName);
            try {
                ServiceRecord srv = (ServiceRecord)this.encoder.fromBytes(childData.getPath(), data);
                InstanceType instance = this.createServiceInstance(srv);
                this.addToCache(childData.getPath(), instance.getHost(), instance);
                if (!doInvokeListeners) continue;
                for (ServiceInstanceStateChangeListener<InstanceType> listener : this.stateChangeListeners) {
                    listener.onCreate(instance, ephSeqVersion);
                }
            }
            catch (IOException e) {
                LOG.error("Unable to decode data for zkpath: {}. Ignoring from current instances list..", (Object)childData.getPath());
            }
        }
    }

    protected abstract InstanceType createServiceInstance(ServiceRecord var1) throws IOException;

    protected static byte[] getWorkerData(ChildData childData, String workerNodePrefix) {
        if (childData == null) {
            return null;
        }
        byte[] data = childData.getData();
        if (data == null) {
            return null;
        }
        if (!ZkRegistryBase.extractNodeName(childData).startsWith(workerNodePrefix)) {
            return null;
        }
        return data;
    }

    protected final int sizeInternal() {
        return this.nodeToInstanceCache.size();
    }

    protected final Set<InstanceType> getByHostInternal(String host) {
        Set<InstanceType> byHost = this.nodeToInstanceCache.get(host);
        Set<Object> set = byHost = byHost == null ? Sets.newHashSet() : byHost;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Returning " + byHost.size() + " hosts for locality allocation on " + host);
        }
        return byHost;
    }

    protected final Collection<InstanceType> getAllInternal() {
        return new HashSet<InstanceType>(this.pathToInstanceCache.values());
    }

    private static String extractNodeName(ChildData childData) {
        String nodeName = childData.getPath();
        int ix = nodeName.lastIndexOf("/");
        if (ix >= 0) {
            nodeName = nodeName.substring(ix + 1);
        }
        return nodeName;
    }

    private InstanceType extractServiceInstance(PathChildrenCacheEvent event, ChildData childData) {
        byte[] data = childData.getData();
        if (data == null) {
            return null;
        }
        try {
            ServiceRecord srv = (ServiceRecord)this.encoder.fromBytes(event.getData().getPath(), data);
            return this.createServiceInstance(srv);
        }
        catch (IOException e) {
            LOG.error("Unable to decode data for zknode: {}. Dropping notification of type: {}", (Object)childData.getPath(), (Object)event.getType());
            return null;
        }
    }

    public synchronized void registerStateChangeListener(ServiceInstanceStateChangeListener<InstanceType> listener) throws IOException {
        this.ensureInstancesCache(0L);
        this.stateChangeListeners.add(listener);
    }

    protected final synchronized PathChildrenCache ensureInstancesCache(long clusterReadyTimeoutMs) throws IOException {
        Preconditions.checkArgument(this.zooKeeperClient != null && this.zooKeeperClient.getState() == CuratorFrameworkState.STARTED, "client is not started");
        PathChildrenCache instancesCache = this.instancesCache;
        if (instancesCache != null) {
            return instancesCache;
        }
        ExecutorService tp = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("StateChangeNotificationHandler").build());
        long startTimeNs = System.nanoTime();
        long deltaNs = clusterReadyTimeoutMs * 1000000L;
        long sleepTimeMs = Math.min(16L, clusterReadyTimeoutMs);
        while (true) {
            instancesCache = new PathChildrenCache(this.zooKeeperClient, this.workersPath, true);
            instancesCache.getListenable().addListener((Object)new InstanceStateChangeListener(), (Executor)tp);
            try {
                instancesCache.start(PathChildrenCache.StartMode.BUILD_INITIAL_CACHE);
                this.instancesCache = instancesCache;
                return instancesCache;
            }
            catch (KeeperException.InvalidACLException e) {
                CloseableUtils.closeQuietly((Closeable)instancesCache);
                long elapsedNs = System.nanoTime() - startTimeNs;
                if (deltaNs == 0L || deltaNs <= elapsedNs) {
                    LOG.error("Unable to start curator PathChildrenCache", (Throwable)e);
                    throw new IOException(e);
                }
                LOG.warn("The cluster is not started yet (InvalidACL); will retry");
                try {
                    Thread.sleep(Math.min(sleepTimeMs, (deltaNs - elapsedNs) / 1000000L));
                }
                catch (InterruptedException e1) {
                    LOG.error("Interrupted while retrying the PathChildrenCache startup");
                    throw new IOException(e1);
                }
                sleepTimeMs <<= 1;
                continue;
            }
            catch (Exception e) {
                CloseableUtils.closeQuietly((Closeable)instancesCache);
                LOG.error("Unable to start curator PathChildrenCache", (Throwable)e);
                throw new IOException(e);
            }
            break;
        }
    }

    public void start() throws IOException {
        if (this.zooKeeperClient != null) {
            String principal = ZookeeperUtils.setupZookeeperAuth(this.conf, this.saslLoginContextName, this.zkPrincipal, this.zkKeytab);
            if (principal != null) {
                this.userNameFromPrincipal = LlapUtil.getUserNameFromPrincipal(principal);
            }
            this.zooKeeperClient.start();
        }
        CloseableUtils.class.getName();
    }

    protected void unregisterInternal() {
        CloseableUtils.closeQuietly((Closeable)this.znode);
    }

    public void stop() {
        CloseableUtils.closeQuietly((Closeable)this.znode);
        CloseableUtils.closeQuietly((Closeable)this.instancesCache);
        CloseableUtils.closeQuietly((Closeable)this.zooKeeperClient);
    }

    protected final InstanceType getInstanceByPath(String path) {
        return (InstanceType)((ServiceInstance)this.pathToInstanceCache.get(path));
    }

    protected final String getRegistrationZnodePath() {
        return this.znodePath;
    }

    private int extractSeqNum(String nodeName) {
        String ephSeqVersionStr = nodeName.substring(this.workerNodePrefix.length() + 1);
        try {
            return Integer.parseInt(ephSeqVersionStr);
        }
        catch (NumberFormatException e) {
            LOG.error("Cannot parse " + ephSeqVersionStr + " from " + nodeName, (Throwable)e);
            throw e;
        }
    }

    private class ZkConnectionStateListener
    implements ConnectionStateListener {
        private ZkConnectionStateListener() {
        }

        public void stateChanged(CuratorFramework curatorFramework, ConnectionState connectionState) {
            LOG.info("Connection state change notification received. State: {}", (Object)connectionState);
        }
    }

    private class InstanceStateChangeListener
    implements PathChildrenCacheListener {
        private final Logger LOG = LoggerFactory.getLogger(InstanceStateChangeListener.class);

        private InstanceStateChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) {
            block14: {
                Preconditions.checkArgument(client != null && client.getState() == CuratorFrameworkState.STARTED, "client is not started");
                InstanceStateChangeListener instanceStateChangeListener = this;
                synchronized (instanceStateChangeListener) {
                    ChildData childData;
                    block13: {
                        childData = event.getData();
                        if (childData == null) {
                            return;
                        }
                        String nodeName = ZkRegistryBase.extractNodeName(childData);
                        if (!nodeName.startsWith(ZkRegistryBase.this.workerNodePrefix)) {
                            return;
                        }
                        this.LOG.info("{} for zknode {}", (Object)event.getType(), (Object)childData.getPath());
                        Object instance = ZkRegistryBase.this.extractServiceInstance(event, childData);
                        if (instance == null) break block13;
                        int ephSeqVersion = ZkRegistryBase.this.extractSeqNum(nodeName);
                        switch (event.getType()) {
                            case CHILD_ADDED: {
                                ZkRegistryBase.this.addToCache(childData.getPath(), instance.getHost(), instance);
                                for (ServiceInstanceStateChangeListener listener : ZkRegistryBase.this.stateChangeListeners) {
                                    listener.onCreate(instance, ephSeqVersion);
                                }
                                break block14;
                            }
                            case CHILD_UPDATED: {
                                ZkRegistryBase.this.addToCache(childData.getPath(), instance.getHost(), instance);
                                for (ServiceInstanceStateChangeListener listener : ZkRegistryBase.this.stateChangeListeners) {
                                    listener.onUpdate(instance, ephSeqVersion);
                                }
                                break block14;
                            }
                            case CHILD_REMOVED: {
                                ZkRegistryBase.this.removeFromCache(childData.getPath(), instance.getHost());
                                for (ServiceInstanceStateChangeListener listener : ZkRegistryBase.this.stateChangeListeners) {
                                    listener.onRemove(instance, ephSeqVersion);
                                }
                                break block14;
                            }
                        }
                        break block14;
                    }
                    this.LOG.info("instance is null for event: {} childData: {}", (Object)event.getType(), (Object)childData);
                }
            }
        }
    }
}

