/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events;

import hive.org.apache.commons.lang3.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.events.PreEventContext;
import org.apache.hadoop.hive.metastore.events.PreReadDatabaseEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthorizableEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthzInfo;

public class ReadDatabaseEvent
extends HiveMetaStoreAuthorizableEvent {
    private static final Log LOG = LogFactory.getLog(ReadDatabaseEvent.class);
    private String COMMAND_STR = "use/show databases or tables";

    public ReadDatabaseEvent(PreEventContext preEventContext) {
        super(preEventContext);
    }

    @Override
    public HiveMetaStoreAuthzInfo getAuthzContext() {
        HiveMetaStoreAuthzInfo ret = new HiveMetaStoreAuthzInfo(this.preEventContext, HiveOperationType.QUERY, this.getInputHObjs(), this.getOutputHObjs(), this.COMMAND_STR);
        return ret;
    }

    private List<HivePrivilegeObject> getInputHObjs() {
        LOG.debug((Object)"==> ReadDatabaseEvent.getInputHObjs()");
        ArrayList<HivePrivilegeObject> ret = new ArrayList<HivePrivilegeObject>();
        PreReadDatabaseEvent preReadDatabaseEvent = (PreReadDatabaseEvent)this.preEventContext;
        Database database = preReadDatabaseEvent.getDatabase();
        if (database != null) {
            ret.add(this.getHivePrivilegeObject(database));
            this.COMMAND_STR = this.buildCommandString(this.COMMAND_STR, database);
            LOG.debug((Object)("<== ReadDatabaseEvent.getInputHObjs(): ret=" + ret));
        }
        return ret;
    }

    private List<HivePrivilegeObject> getOutputHObjs() {
        return Collections.emptyList();
    }

    private String buildCommandString(String cmdStr, Database db) {
        Object ret = cmdStr;
        if (db != null) {
            String dbName = db.getName();
            ret = (String)ret + (String)(StringUtils.isNotEmpty(dbName) ? " " + dbName : "");
        }
        return ret;
    }
}

