/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ppd;

import hive.com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.LateralViewJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.PTFOperator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.HiveStoragePredicateHandler;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.WindowingSpec;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.JoinCondDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PTFDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.ptf.BoundaryDef;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFunctionDef;
import org.apache.hadoop.hive.ql.plan.ptf.WindowTableFunctionDef;
import org.apache.hadoop.hive.ql.ppd.ExprWalkerInfo;
import org.apache.hadoop.hive.ql.ppd.ExprWalkerProcFactory;
import org.apache.hadoop.hive.ql.ppd.OpWalkerInfo;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFDenseRank;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFLead;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFRank;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.mapred.JobConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OpProcFactory {
    protected static final Logger LOG = LoggerFactory.getLogger((String)OpProcFactory.class.getName());

    private static ExprWalkerInfo getChildWalkerInfo(Operator<?> current, OpWalkerInfo owi) throws SemanticException {
        if (current.getNumChild() == 0) {
            return null;
        }
        if (current.getNumChild() > 1) {
            ArrayList<Operator<OperatorDesc>> children = Lists.newArrayList(current.getChildOperators());
            for (Operator operator : children) {
                ExprWalkerInfo childInfo = owi.getPrunedPreds(operator);
                OpProcFactory.createFilter(operator, childInfo, owi);
            }
            return null;
        }
        return owi.getPrunedPreds(current.getChildOperators().get(0));
    }

    private static void removeCandidates(Operator<?> operator, OpWalkerInfo owi) {
        if (operator instanceof FilterOperator) {
            if (owi.getCandidateFilterOps().contains(operator)) {
                OpProcFactory.removeOperator(operator);
            }
            owi.getCandidateFilterOps().remove(operator);
        }
        if (operator.getChildOperators() != null) {
            ArrayList<Operator<OperatorDesc>> children = Lists.newArrayList(operator.getChildOperators());
            for (Operator operator2 : children) {
                OpProcFactory.removeCandidates(operator2, owi);
            }
        }
    }

    private static void removeAllCandidates(OpWalkerInfo owi) {
        for (FilterOperator operator : owi.getCandidateFilterOps()) {
            OpProcFactory.removeOperator(operator);
        }
        owi.getCandidateFilterOps().clear();
    }

    private static void removeOperator(Operator<? extends OperatorDesc> operator) {
        ArrayList<Operator<OperatorDesc>> children = new ArrayList<Operator<OperatorDesc>>(operator.getChildOperators());
        ArrayList<Operator<OperatorDesc>> parents = new ArrayList<Operator<OperatorDesc>>(operator.getParentOperators());
        for (Operator operator2 : parents) {
            operator2.getChildOperators().addAll(children);
            operator2.removeChild(operator);
        }
        for (Operator operator3 : children) {
            operator3.getParentOperators().addAll(parents);
            operator3.removeParent(operator);
        }
    }

    protected static Object createFilter(Operator op, ExprWalkerInfo pushDownPreds, OpWalkerInfo owi) throws SemanticException {
        if (pushDownPreds != null && pushDownPreds.hasAnyCandidates()) {
            return OpProcFactory.createFilter(op, pushDownPreds.getFinalCandidates(), owi);
        }
        return null;
    }

    protected static Object createFilter(Operator op, Map<String, List<ExprNodeDesc>> predicates, OpWalkerInfo owi) throws SemanticException {
        ExprWalkerInfo walkerInfo;
        HiveConf hiveConf;
        boolean pushFilterToStorage;
        RowSchema inputRS = op.getSchema();
        List<ExprNodeDesc> preds = new ArrayList<ExprNodeDesc>();
        Iterator<List<ExprNodeDesc>> iterator = predicates.values().iterator();
        while (iterator.hasNext()) {
            for (ExprNodeDesc pred : iterator.next()) {
                preds = ExprNodeDescUtils.split(pred, preds);
            }
        }
        if (preds.isEmpty()) {
            return null;
        }
        ExprNodeDesc condn = ExprNodeDescUtils.mergePredicates(preds);
        if (op instanceof TableScanOperator && condn instanceof ExprNodeGenericFuncDesc && (pushFilterToStorage = (hiveConf = owi.getParseContext().getConf()).getBoolVar(HiveConf.ConfVars.HIVEOPTPPD_STORAGE)) && (condn = OpProcFactory.pushFilterToStorageHandler((TableScanOperator)op, (ExprNodeGenericFuncDesc)condn, owi, hiveConf)) == null) {
            return null;
        }
        List<Operator<? extends OperatorDesc>> originalChilren = op.getChildOperators();
        op.setChildOperators(null);
        Operator<FilterDesc> output = OperatorFactory.getAndMakeChild(new FilterDesc(condn, false), new RowSchema(inputRS.getSignature()), op, new Operator[0]);
        output.setChildOperators(originalChilren);
        for (Operator<? extends OperatorDesc> ch : originalChilren) {
            List<Operator<OperatorDesc>> parentOperators = ch.getParentOperators();
            int pos = parentOperators.indexOf(op);
            assert (pos != -1);
            parentOperators.remove(pos);
            parentOperators.add(pos, output);
        }
        if (HiveConf.getBoolVar(owi.getParseContext().getConf(), HiveConf.ConfVars.HIVEPPDREMOVEDUPLICATEFILTERS)) {
            OpProcFactory.removeCandidates(op, owi);
        }
        if ((walkerInfo = owi.getPrunedPreds(op)) != null) {
            walkerInfo.getNonFinalCandidates().clear();
            owi.putPrunedPreds(output, walkerInfo);
        }
        return output;
    }

    private static ExprNodeGenericFuncDesc pushFilterToStorageHandler(TableScanOperator tableScanOp, ExprNodeGenericFuncDesc originalPredicate, OpWalkerInfo owi, HiveConf hiveConf) throws SemanticException {
        TableScanDesc tableScanDesc = (TableScanDesc)tableScanOp.getConf();
        Table tbl = tableScanDesc.getTableMetadata();
        if (HiveConf.getBoolVar(hiveConf, HiveConf.ConfVars.HIVEOPTINDEXFILTER)) {
            tableScanDesc.setFilterExpr(originalPredicate);
        }
        if (!tbl.isNonNative()) {
            return originalPredicate;
        }
        HiveStorageHandler storageHandler = tbl.getStorageHandler();
        if (!(storageHandler instanceof HiveStoragePredicateHandler)) {
            tableScanDesc.setFilterExpr(originalPredicate);
            return originalPredicate;
        }
        HiveStoragePredicateHandler predicateHandler = (HiveStoragePredicateHandler)((Object)storageHandler);
        JobConf jobConf = new JobConf((Configuration)owi.getParseContext().getConf());
        Utilities.setColumnNameList(jobConf, tableScanOp);
        Utilities.setColumnTypeList(jobConf, tableScanOp);
        try {
            Utilities.copyTableJobPropertiesToConf(Utilities.getTableDesc(tbl), jobConf);
        }
        catch (Exception e) {
            throw new SemanticException(e);
        }
        Deserializer deserializer = tbl.getDeserializer();
        HiveStoragePredicateHandler.DecomposedPredicate decomposed = predicateHandler.decomposePredicate(jobConf, deserializer, originalPredicate);
        if (decomposed == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No pushdown possible for predicate:  " + originalPredicate.getExprString());
            }
            return originalPredicate;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Original predicate:  " + originalPredicate.getExprString());
            if (decomposed.pushedPredicate != null) {
                LOG.debug("Pushed predicate:  " + decomposed.pushedPredicate.getExprString());
            }
            if (decomposed.residualPredicate != null) {
                LOG.debug("Residual predicate:  " + decomposed.residualPredicate.getExprString());
            }
        }
        tableScanDesc.setFilterExpr(decomposed.pushedPredicate);
        tableScanDesc.setFilterObject(decomposed.pushedPredicateObject);
        return decomposed.residualPredicate;
    }

    public static NodeProcessor getFilterProc() {
        return new FilterPPD();
    }

    public static NodeProcessor getFilterSyntheticJoinPredicateProc() {
        return new SimpleFilterPPD();
    }

    public static NodeProcessor getJoinProc() {
        return new JoinPPD();
    }

    public static NodeProcessor getTSProc() {
        return new TableScanPPD();
    }

    public static NodeProcessor getDefaultProc() {
        return new DefaultPPD();
    }

    public static NodeProcessor getPTFProc() {
        return new PTFPPD();
    }

    public static NodeProcessor getSCRProc() {
        return new ScriptPPD();
    }

    public static NodeProcessor getLIMProc() {
        return new ScriptPPD();
    }

    public static NodeProcessor getLVFProc() {
        return new LateralViewForwardPPD();
    }

    public static NodeProcessor getUDTFProc() {
        return new UDTFPPD();
    }

    public static NodeProcessor getLVJProc() {
        return new JoinerPPD();
    }

    public static NodeProcessor getRSProc() {
        return new ReduceSinkPPD();
    }

    private OpProcFactory() {
    }

    public static class DefaultPPD
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            LOG.info("Processing for " + nd.getName() + "(" + ((Operator)nd).getIdentifier() + ")");
            OpWalkerInfo owi = (OpWalkerInfo)procCtx;
            Set<String> includes = this.getQualifiedAliases((Operator)nd, owi);
            boolean hasUnpushedPredicates = this.mergeWithChildrenPred(nd, owi, null, includes);
            if (hasUnpushedPredicates && HiveConf.getBoolVar(owi.getParseContext().getConf(), HiveConf.ConfVars.HIVEPPDREMOVEDUPLICATEFILTERS)) {
                if (includes != null || nd instanceof ReduceSinkOperator) {
                    owi.getCandidateFilterOps().clear();
                } else {
                    ExprWalkerInfo pruned = owi.getPrunedPreds((Operator)nd);
                    Map<String, List<ExprNodeDesc>> residual = pruned.getResidualPredicates(true);
                    if (residual != null && !residual.isEmpty()) {
                        OpProcFactory.createFilter((Operator)nd, residual, owi);
                        pruned.getNonFinalCandidates().clear();
                    }
                }
            }
            return null;
        }

        private Set<String> getQualifiedAliases(Operator<?> operator, OpWalkerInfo owi) {
            if (operator.getNumChild() != 1) {
                return null;
            }
            Operator<OperatorDesc> child = operator.getChildOperators().get(0);
            if (!(child instanceof JoinOperator) && !(child instanceof LateralViewJoinOperator)) {
                return null;
            }
            if (operator instanceof ReduceSinkOperator && ((ReduceSinkOperator)operator).getInputAliases() != null) {
                String[] aliases = ((ReduceSinkOperator)operator).getInputAliases();
                return new HashSet<String>(Arrays.asList(aliases));
            }
            Set<String> includes = operator.getSchema().getTableNames();
            if (includes.size() == 1 && includes.contains("")) {
                return null;
            }
            return includes;
        }

        protected void logExpr(Node nd, ExprWalkerInfo ewi) {
            if (!LOG.isDebugEnabled()) {
                return;
            }
            for (Map.Entry<String, List<ExprNodeDesc>> e : ewi.getFinalCandidates().entrySet()) {
                StringBuilder sb = new StringBuilder("Pushdown predicates of ").append(nd.getName()).append(" for alias ").append(e.getKey()).append(": ");
                boolean isFirst = true;
                for (ExprNodeDesc n : e.getValue()) {
                    if (!isFirst) {
                        sb.append("; ");
                    }
                    isFirst = false;
                    sb.append(n.getExprString());
                }
                LOG.debug(sb.toString());
            }
        }

        protected boolean mergeWithChildrenPred(Node nd, OpWalkerInfo owi, ExprWalkerInfo ewi, Set<String> aliases) throws SemanticException {
            Operator op = (Operator)nd;
            ExprWalkerInfo childPreds = OpProcFactory.getChildWalkerInfo(op, owi);
            if (childPreds == null) {
                return false;
            }
            if (ewi == null) {
                ewi = new ExprWalkerInfo();
            }
            boolean hasUnpushedPredicates = false;
            for (Map.Entry<String, List<ExprNodeDesc>> e : childPreds.getFinalCandidates().entrySet()) {
                if (aliases != null && e.getKey() != null && !aliases.contains(e.getKey())) continue;
                ExprWalkerInfo extractPushdownPreds = ExprWalkerProcFactory.extractPushdownPreds(owi, (Operator<? extends OperatorDesc>)op, e.getValue());
                if (!extractPushdownPreds.getNonFinalCandidates().isEmpty()) {
                    hasUnpushedPredicates = true;
                }
                ewi.merge(extractPushdownPreds);
                this.logExpr(nd, extractPushdownPreds);
            }
            owi.putPrunedPreds((Operator)nd, ewi);
            return hasUnpushedPredicates;
        }

        protected ExprWalkerInfo mergeChildrenPred(Node nd, OpWalkerInfo owi, Set<String> excludedAliases, boolean ignoreAliases) throws SemanticException {
            if (nd.getChildren() == null) {
                return null;
            }
            Operator op = (Operator)nd;
            ExprWalkerInfo ewi = new ExprWalkerInfo();
            for (Operator<OperatorDesc> child : op.getChildOperators()) {
                ExprWalkerInfo childPreds = owi.getPrunedPreds(child);
                if (childPreds == null) continue;
                for (Map.Entry<String, List<ExprNodeDesc>> e : childPreds.getFinalCandidates().entrySet()) {
                    if (!ignoreAliases && excludedAliases != null && excludedAliases.contains(e.getKey()) && e.getKey() != null) continue;
                    ewi.addPushDowns(e.getKey(), e.getValue());
                    this.logExpr(nd, ewi);
                }
            }
            return ewi;
        }
    }

    public static class ReduceSinkPPD
    extends DefaultPPD
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            super.process(nd, stack, procCtx, nodeOutputs);
            Operator operator = (Operator)nd;
            OpWalkerInfo owi = (OpWalkerInfo)procCtx;
            if (operator.getNumChild() == 1 && operator.getChildOperators().get(0) instanceof JoinOperator && HiveConf.getBoolVar(owi.getParseContext().getConf(), HiveConf.ConfVars.HIVEPPDRECOGNIZETRANSITIVITY)) {
                JoinOperator child = (JoinOperator)operator.getChildOperators().get(0);
                int targetPos = child.getParentOperators().indexOf(operator);
                this.applyFilterTransitivity(child, targetPos, owi);
            }
            return null;
        }

        private void applyFilterTransitivity(JoinOperator join, int targetPos, OpWalkerInfo owi) throws SemanticException {
            ExprWalkerInfo joinPreds = owi.getPrunedPreds(join);
            if (joinPreds == null || !joinPreds.hasAnyCandidates()) {
                return;
            }
            Map<String, List<ExprNodeDesc>> oldFilters = joinPreds.getFinalCandidates();
            HashMap newFilters = new HashMap();
            List<Operator<OperatorDesc>> parentOperators = join.getParentOperators();
            ReduceSinkOperator target = (ReduceSinkOperator)parentOperators.get(targetPos);
            ArrayList<ExprNodeDesc> targetKeys = ((ReduceSinkDesc)target.getConf()).getKeyCols();
            ExprWalkerInfo rsPreds = owi.getPrunedPreds(target);
            for (int sourcePos = 0; sourcePos < parentOperators.size(); ++sourcePos) {
                ReduceSinkOperator source = (ReduceSinkOperator)parentOperators.get(sourcePos);
                ArrayList<ExprNodeDesc> sourceKeys = ((ReduceSinkDesc)source.getConf()).getKeyCols();
                HashSet<String> sourceAliases = new HashSet<String>(Arrays.asList(source.getInputAliases()));
                for (Map.Entry<String, List<ExprNodeDesc>> entry : oldFilters.entrySet()) {
                    if (entry.getKey() == null && ExprNodeDescUtils.isAllConstants(entry.getValue())) {
                        for (String targetAlias : target.getInputAliases()) {
                            rsPreds.addPushDowns(targetAlias, entry.getValue());
                        }
                        continue;
                    }
                    if (!sourceAliases.contains(entry.getKey())) continue;
                    for (ExprNodeDesc predicate : entry.getValue()) {
                        ExprNodeDesc replaced;
                        ExprNodeDesc backtrack = ExprNodeDescUtils.backtrack(predicate, join, source);
                        if (backtrack == null || (replaced = ExprNodeDescUtils.replace(backtrack, sourceKeys, targetKeys)) == null) continue;
                        for (String targetAlias : target.getInputAliases()) {
                            rsPreds.addFinalCandidate(targetAlias, replaced);
                        }
                    }
                }
            }
        }
    }

    public static class JoinPPD
    extends JoinerPPD {
        @Override
        protected Set<String> getAliases(Node nd) {
            return this.getQualifiedAliases((JoinOperator)nd, ((JoinOperator)nd).getSchema());
        }

        private Set<String> getQualifiedAliases(JoinOperator op, RowSchema rs) {
            int i;
            HashSet<String> aliases = new HashSet<String>();
            JoinCondDesc[] conds = ((JoinDesc)op.getConf()).getConds();
            Map<Integer, Set<String>> posToAliasMap = op.getPosToAliasMap();
            for (i = conds.length - 1; i >= 0; --i) {
                if (conds[i].getType() == 0) {
                    aliases.addAll((Collection<String>)posToAliasMap.get(i + 1));
                    continue;
                }
                if (conds[i].getType() == 3) break;
                if (conds[i].getType() == 2) {
                    aliases.addAll((Collection<String>)posToAliasMap.get(i + 1));
                    break;
                }
                if (conds[i].getType() != 1) continue;
            }
            if (i == -1) {
                aliases.addAll((Collection)posToAliasMap.get(0));
            }
            Set<String> aliases2 = rs.getTableNames();
            aliases.retainAll(aliases2);
            return aliases;
        }
    }

    public static class JoinerPPD
    extends DefaultPPD
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            LOG.info("Processing for " + nd.getName() + "(" + ((Operator)nd).getIdentifier() + ")");
            OpWalkerInfo owi = (OpWalkerInfo)procCtx;
            Set<String> aliases = this.getAliases(nd);
            this.mergeWithChildrenPred(nd, owi, null, null);
            ExprWalkerInfo prunePreds = owi.getPrunedPreds((Operator)nd);
            if (prunePreds != null) {
                HashSet<String> toRemove = new HashSet<String>();
                for (Map.Entry<String, List<ExprNodeDesc>> entry : prunePreds.getFinalCandidates().entrySet()) {
                    String key = entry.getKey();
                    List<ExprNodeDesc> value = entry.getValue();
                    if (key == null && ExprNodeDescUtils.isAllConstants(value) || aliases.contains(key)) continue;
                    toRemove.add(key);
                }
                for (String alias : toRemove) {
                    for (ExprNodeDesc expr : prunePreds.getFinalCandidates().get(alias)) {
                        ExprWalkerInfo.ExprInfo exprInfo;
                        if (alias != null) {
                            exprInfo = prunePreds.addOrGetExprInfo(expr);
                            exprInfo.alias = alias;
                        } else {
                            exprInfo = prunePreds.getExprInfo(expr);
                        }
                        prunePreds.addNonFinalCandidate(exprInfo != null ? exprInfo.alias : null, expr);
                    }
                    prunePreds.getFinalCandidates().remove(alias);
                }
                return this.handlePredicates(nd, prunePreds, owi);
            }
            return null;
        }

        protected Set<String> getAliases(Node nd) throws SemanticException {
            return ((Operator)nd).getSchema().getTableNames();
        }

        protected Object handlePredicates(Node nd, ExprWalkerInfo prunePreds, OpWalkerInfo owi) throws SemanticException {
            if (HiveConf.getBoolVar(owi.getParseContext().getConf(), HiveConf.ConfVars.HIVEPPDREMOVEDUPLICATEFILTERS)) {
                return OpProcFactory.createFilter((Operator)nd, prunePreds.getResidualPredicates(true), owi);
            }
            return null;
        }
    }

    public static class SimpleFilterPPD
    extends FilterPPD
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            FilterOperator filterOp = (FilterOperator)nd;
            boolean parentTableScan = filterOp.getParentOperators().get(0) instanceof TableScanOperator;
            boolean ancestorPTF = false;
            if (!parentTableScan) {
                Operator parent = filterOp;
                do {
                    assert (parent.getParentOperators().size() == 1);
                } while ((parent = parent.getParentOperators().get(0)) instanceof SelectOperator);
                if (parent instanceof PTFOperator) {
                    ancestorPTF = true;
                }
            }
            return this.process(nd, stack, procCtx, !parentTableScan && !ancestorPTF, nodeOutputs);
        }
    }

    public static class FilterPPD
    extends DefaultPPD
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            return this.process(nd, stack, procCtx, false, nodeOutputs);
        }

        Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, boolean onlySyntheticJoinPredicate, Object ... nodeOutputs) throws SemanticException {
            LOG.info("Processing for " + nd.getName() + "(" + ((Operator)nd).getIdentifier() + ")");
            OpWalkerInfo owi = (OpWalkerInfo)procCtx;
            Operator op = (Operator)nd;
            ExprWalkerInfo ewi = owi.getPrunedPreds(op);
            if (!(ewi != null || ((FilterDesc)((FilterOperator)op).getConf()).getIsSamplingPred() || onlySyntheticJoinPredicate && !((FilterDesc)((FilterOperator)op).getConf()).isSyntheticJoinPredicate())) {
                ExprNodeDesc predicate = ((FilterDesc)((FilterOperator)nd).getConf()).getPredicate();
                ewi = ExprWalkerProcFactory.extractPushdownPreds(owi, (Operator<? extends OperatorDesc>)op, predicate);
                if (!ewi.isDeterministic()) {
                    if (op.getChildren() != null && ((ArrayList)op.getChildren()).size() == 1) {
                        OpProcFactory.createFilter(op, owi.getPrunedPreds((Operator)((ArrayList)op.getChildren()).get(0)), owi);
                    }
                    return null;
                }
                this.logExpr(nd, ewi);
                owi.putPrunedPreds((Operator)nd, ewi);
                if (HiveConf.getBoolVar(owi.getParseContext().getConf(), HiveConf.ConfVars.HIVEPPDREMOVEDUPLICATEFILTERS)) {
                    owi.addCandidateFilterOp((FilterOperator)op);
                    Map<String, List<ExprNodeDesc>> residual = ewi.getResidualPredicates(true);
                    OpProcFactory.createFilter(op, residual, owi);
                }
            }
            boolean hasUnpushedPredicates = this.mergeWithChildrenPred(nd, owi, ewi, null);
            if (HiveConf.getBoolVar(owi.getParseContext().getConf(), HiveConf.ConfVars.HIVEPPDREMOVEDUPLICATEFILTERS) && hasUnpushedPredicates) {
                ExprWalkerInfo unpushedPreds = this.mergeChildrenPred(nd, owi, null, false);
                return OpProcFactory.createFilter((Operator)nd, unpushedPreds, owi);
            }
            return null;
        }
    }

    public static class TableScanPPD
    extends DefaultPPD
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            LOG.info("Processing for " + nd.getName() + "(" + ((Operator)nd).getIdentifier() + ")");
            OpWalkerInfo owi = (OpWalkerInfo)procCtx;
            TableScanOperator tsOp = (TableScanOperator)nd;
            this.mergeWithChildrenPred(tsOp, owi, null, null);
            if (HiveConf.getBoolVar(owi.getParseContext().getConf(), HiveConf.ConfVars.HIVEPPDREMOVEDUPLICATEFILTERS)) {
                OpProcFactory.removeAllCandidates(owi);
            }
            ExprWalkerInfo pushDownPreds = owi.getPrunedPreds(tsOp);
            assert (pushDownPreds == null || !pushDownPreds.hasNonFinalCandidates());
            return OpProcFactory.createFilter((Operator)tsOp, pushDownPreds, owi);
        }
    }

    public static class LateralViewForwardPPD
    extends DefaultPPD
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            LOG.info("Processing for " + nd.getName() + "(" + ((Operator)nd).getIdentifier() + ")");
            OpWalkerInfo owi = (OpWalkerInfo)procCtx;
            ExprWalkerInfo childPreds = owi.getPrunedPreds((Operator)nd.getChildren().get(0));
            owi.putPrunedPreds((Operator)nd, childPreds);
            return null;
        }
    }

    public static class UDTFPPD
    extends DefaultPPD
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            super.process(nd, stack, procCtx, nodeOutputs);
            OpWalkerInfo owi = (OpWalkerInfo)procCtx;
            ExprWalkerInfo prunedPred = owi.getPrunedPreds((Operator)nd);
            if (prunedPred == null || !prunedPred.hasAnyCandidates()) {
                return null;
            }
            Map<String, List<ExprNodeDesc>> candidates = prunedPred.getFinalCandidates();
            OpProcFactory.createFilter((Operator)nd, prunedPred, owi);
            candidates.clear();
            return null;
        }
    }

    public static class PTFPPD
    extends ScriptPPD {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            LOG.info("Processing for " + nd.getName() + "(" + ((Operator)nd).getIdentifier() + ")");
            OpWalkerInfo owi = (OpWalkerInfo)procCtx;
            PTFOperator ptfOp = (PTFOperator)nd;
            this.pushRankLimit(ptfOp, owi);
            return super.process(nd, stack, procCtx, nodeOutputs);
        }

        private void pushRankLimit(PTFOperator ptfOp, OpWalkerInfo owi) throws SemanticException {
            PTFDesc conf = (PTFDesc)ptfOp.getConf();
            if (!conf.forWindowing()) {
                return;
            }
            float threshold = owi.getParseContext().getConf().getFloatVar(HiveConf.ConfVars.HIVELIMITPUSHDOWNMEMORYUSAGE);
            if (threshold <= 0.0f || threshold >= 1.0f) {
                return;
            }
            WindowTableFunctionDef wTFn = (WindowTableFunctionDef)conf.getFuncDef();
            List<Integer> rFnIdxs = this.rankingFunctions(wTFn);
            if (rFnIdxs.size() == 0) {
                return;
            }
            ExprWalkerInfo childInfo = OpProcFactory.getChildWalkerInfo(ptfOp, owi);
            if (childInfo == null) {
                return;
            }
            List<ExprNodeDesc> preds = new ArrayList<ExprNodeDesc>();
            Iterator<List<ExprNodeDesc>> iterator = childInfo.getFinalCandidates().values().iterator();
            while (iterator.hasNext()) {
                for (ExprNodeDesc pred : iterator.next()) {
                    preds = ExprNodeDescUtils.split(pred, preds);
                }
            }
            int rLimit = -1;
            int fnIdx = -1;
            for (ExprNodeDesc pred : preds) {
                int[] pLimit = this.getLimit(wTFn, rFnIdxs, pred);
                if (pLimit == null || rLimit != -1 && rLimit < pLimit[0]) continue;
                rLimit = pLimit[0];
                fnIdx = pLimit[1];
            }
            if (rLimit != -1) {
                wTFn.setRankLimit(rLimit);
                wTFn.setRankLimitFunction(fnIdx);
                if (this.canPushLimitToReduceSink(wTFn)) {
                    this.pushRankLimitToRedSink(ptfOp, owi.getParseContext().getConf(), rLimit);
                }
            }
        }

        private List<Integer> rankingFunctions(WindowTableFunctionDef wTFn) {
            ArrayList<Integer> rFns = new ArrayList<Integer>();
            for (int i = 0; i < wTFn.getWindowFunctions().size(); ++i) {
                WindowFunctionDef wFnDef = wTFn.getWindowFunctions().get(i);
                if (!(wFnDef.getWFnEval() instanceof GenericUDAFRank.GenericUDAFRankEvaluator) && !(wFnDef.getWFnEval() instanceof GenericUDAFDenseRank.GenericUDAFDenseRankEvaluator)) continue;
                rFns.add(i);
            }
            return rFns;
        }

        private int[] getLimit(WindowTableFunctionDef wTFn, List<Integer> rFnIdxs, ExprNodeDesc expr) {
            if (!(expr instanceof ExprNodeGenericFuncDesc)) {
                return null;
            }
            ExprNodeGenericFuncDesc fExpr = (ExprNodeGenericFuncDesc)expr;
            if (!(fExpr.getGenericUDF() instanceof GenericUDFOPLessThan) && !(fExpr.getGenericUDF() instanceof GenericUDFOPEqualOrLessThan)) {
                return null;
            }
            if (!(fExpr.getChildren().get(0) instanceof ExprNodeColumnDesc)) {
                return null;
            }
            if (!(fExpr.getChildren().get(1) instanceof ExprNodeConstantDesc)) {
                return null;
            }
            ExprNodeConstantDesc constantExpr = (ExprNodeConstantDesc)fExpr.getChildren().get(1);
            if (constantExpr.getTypeInfo() != TypeInfoFactory.intTypeInfo) {
                return null;
            }
            int limit = (Integer)constantExpr.getValue();
            if (fExpr.getGenericUDF() instanceof GenericUDFOPEqualOrLessThan) {
                ++limit;
            }
            String colName = ((ExprNodeColumnDesc)fExpr.getChildren().get(0)).getColumn();
            for (int i = 0; i < rFnIdxs.size(); ++i) {
                String fAlias = wTFn.getWindowFunctions().get(i).getAlias();
                if (!fAlias.equals(colName)) continue;
                return new int[]{limit, i};
            }
            return null;
        }

        private boolean canPushLimitToReduceSink(WindowTableFunctionDef wTFn) {
            for (WindowFunctionDef wFnDef : wTFn.getWindowFunctions()) {
                if (wFnDef.getWFnEval() instanceof GenericUDAFRank.GenericUDAFRankEvaluator || wFnDef.getWFnEval() instanceof GenericUDAFDenseRank.GenericUDAFDenseRankEvaluator || wFnDef.getWFnEval() instanceof GenericUDAFLead.GenericUDAFLeadEvaluator) continue;
                WindowFrameDef wdwFrame = wFnDef.getWindowFrame();
                BoundaryDef end = wdwFrame.getEnd();
                if (wdwFrame.getWindowType() == WindowingSpec.WindowType.RANGE) {
                    return false;
                }
                if (end.getDirection() != WindowingSpec.Direction.FOLLOWING) continue;
                return false;
            }
            return true;
        }

        private void pushRankLimitToRedSink(PTFOperator ptfOp, HiveConf conf, int rLimit) throws SemanticException {
            Operator<OperatorDesc> gP;
            Operator<OperatorDesc> parent = ptfOp.getParentOperators().get(0);
            Operator<OperatorDesc> operator = gP = parent == null ? null : parent.getParentOperators().get(0);
            if (gP == null || !(gP instanceof ReduceSinkOperator)) {
                return;
            }
            float threshold = conf.getFloatVar(HiveConf.ConfVars.HIVELIMITPUSHDOWNMEMORYUSAGE);
            ReduceSinkOperator rSink = (ReduceSinkOperator)gP;
            ReduceSinkDesc rDesc = (ReduceSinkDesc)rSink.getConf();
            rDesc.setTopN(rLimit);
            rDesc.setTopNMemoryUsage(threshold);
            rDesc.setMapGroupBy(true);
            rDesc.setPTFReduceSink(true);
        }
    }

    public static class ScriptPPD
    extends DefaultPPD
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            LOG.debug("Processing for " + nd.getName() + "(" + ((Operator)nd).getIdentifier() + ")");
            OpWalkerInfo owi = (OpWalkerInfo)procCtx;
            ExprWalkerInfo childInfo = OpProcFactory.getChildWalkerInfo((Operator)nd, owi);
            if (childInfo != null && HiveConf.getBoolVar(owi.getParseContext().getConf(), HiveConf.ConfVars.HIVEPPDREMOVEDUPLICATEFILTERS)) {
                ExprWalkerInfo unpushedPreds = this.mergeChildrenPred(nd, owi, null, false);
                return OpProcFactory.createFilter((Operator)nd, unpushedPreds, owi);
            }
            return null;
        }
    }
}

