/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import hive.org.apache.commons.lang.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.IOConstants;
import org.apache.hadoop.hive.ql.io.StorageFormatDescriptor;
import org.apache.hadoop.hive.ql.io.StorageFormatFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public class StorageFormat {
    private static final StorageFormatFactory storageFormatFactory = new StorageFormatFactory();
    private final Configuration conf;
    private String inputFormat;
    private String outputFormat;
    private String storageHandler;
    private String serde;
    private final Map<String, String> serdeProps;

    public StorageFormat(Configuration conf) {
        this.conf = conf;
        this.serdeProps = new HashMap<String, String>();
    }

    public boolean fillStorageFormat(ASTNode child) throws SemanticException {
        switch (child.getToken().getType()) {
            case 1045: {
                if (child.getChildCount() < 2) {
                    throw new SemanticException("Incomplete specification of File Format. You must provide InputFormat, OutputFormat.");
                }
                this.inputFormat = ParseUtils.ensureClassExists(BaseSemanticAnalyzer.unescapeSQLString(child.getChild(0).getText()));
                this.outputFormat = ParseUtils.ensureClassExists(BaseSemanticAnalyzer.unescapeSQLString(child.getChild(1).getText()));
                if (child.getChildCount() != 3) break;
                this.serde = ParseUtils.ensureClassExists(BaseSemanticAnalyzer.unescapeSQLString(child.getChild(2).getText()));
                break;
            }
            case 1023: {
                this.storageHandler = ParseUtils.ensureClassExists(BaseSemanticAnalyzer.unescapeSQLString(child.getChild(0).getText()));
                if (child.getChildCount() != 2) break;
                BaseSemanticAnalyzer.readProps((ASTNode)child.getChild(1).getChild(0), this.serdeProps);
                break;
            }
            case 839: {
                ASTNode grandChild = (ASTNode)child.getChild(0);
                String name = (grandChild == null ? "" : grandChild.getText()).trim().toUpperCase();
                this.processStorageFormat(name);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    protected void processStorageFormat(String name) throws SemanticException {
        if (name.isEmpty()) {
            throw new SemanticException("File format in STORED AS clause cannot be empty");
        }
        StorageFormatDescriptor descriptor = storageFormatFactory.get(name);
        if (descriptor == null) {
            throw new SemanticException("Unrecognized file format in STORED AS clause: '" + name + "'");
        }
        this.inputFormat = ParseUtils.ensureClassExists(descriptor.getInputFormat());
        this.outputFormat = ParseUtils.ensureClassExists(descriptor.getOutputFormat());
        if (this.serde == null) {
            this.serde = ParseUtils.ensureClassExists(descriptor.getSerde());
        }
        if (this.serde == null) {
            this.serde = name.equalsIgnoreCase("RCFILE") ? ParseUtils.ensureClassExists(HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVEDEFAULTRCFILESERDE)) : ParseUtils.ensureClassExists(HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVEDEFAULTSERDE));
        }
    }

    protected void fillDefaultStorageFormat(boolean isExternal, boolean isMaterializedView) throws SemanticException {
        if (this.inputFormat == null && this.storageHandler == null) {
            String defaultFormat;
            String defaultManagedFormat;
            if (isMaterializedView) {
                defaultFormat = defaultManagedFormat = HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVE_MATERIALIZED_VIEW_FILE_FORMAT);
                this.serde = HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVE_MATERIALIZED_VIEW_SERDE);
            } else {
                defaultFormat = HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVEDEFAULTFILEFORMAT);
                defaultManagedFormat = HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVEDEFAULTMANAGEDFILEFORMAT);
            }
            if (!isExternal && !"none".equals(defaultManagedFormat)) {
                defaultFormat = defaultManagedFormat;
            }
            if (StringUtils.isBlank(defaultFormat)) {
                this.inputFormat = IOConstants.TEXTFILE_INPUT;
                this.outputFormat = IOConstants.TEXTFILE_OUTPUT;
            } else {
                this.processStorageFormat(defaultFormat);
                if (defaultFormat.equalsIgnoreCase("RCFILE")) {
                    this.serde = HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVEDEFAULTRCFILESERDE);
                }
            }
        }
    }

    public void setSerde(String serde) {
        this.serde = serde;
    }

    public String getInputFormat() {
        return this.inputFormat;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public String getStorageHandler() {
        return this.storageHandler;
    }

    public String getSerde() {
        return this.serde;
    }

    public Map<String, String> getSerdeProps() {
        return this.serdeProps;
    }
}

