/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveRelNode;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortLimit;

public class HiveSortJoinReduceRule
extends RelOptRule {
    public static final HiveSortJoinReduceRule INSTANCE = new HiveSortJoinReduceRule();

    private HiveSortJoinReduceRule() {
        super(HiveSortJoinReduceRule.operand(HiveSortLimit.class, (RelOptRuleOperand)HiveSortJoinReduceRule.operand(HiveJoin.class, (RelOptRuleOperandChildren)HiveSortJoinReduceRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
    }

    public boolean matches(RelOptRuleCall call) {
        RelNode reducedInput;
        HiveSortLimit sortLimit = (HiveSortLimit)call.rel(0);
        HiveJoin join = (HiveJoin)call.rel(1);
        if (!HiveCalciteUtil.limitRelNode(sortLimit) || RexLiteral.intValue((RexNode)sortLimit.fetch) == 0) {
            return false;
        }
        if (join.getJoinType() == JoinRelType.LEFT) {
            reducedInput = join.getLeft();
            if (sortLimit.getCollation() != RelCollations.EMPTY) {
                for (RelFieldCollation relFieldCollation : sortLimit.getCollation().getFieldCollations()) {
                    if (relFieldCollation.getFieldIndex() < join.getLeft().getRowType().getFieldCount()) continue;
                    return false;
                }
            }
        } else if (join.getJoinType() == JoinRelType.RIGHT) {
            reducedInput = join.getRight();
            if (sortLimit.getCollation() != RelCollations.EMPTY) {
                for (RelFieldCollation relFieldCollation : sortLimit.getCollation().getFieldCollations()) {
                    if (relFieldCollation.getFieldIndex() >= join.getLeft().getRowType().getFieldCount()) continue;
                    return false;
                }
            }
        } else {
            return false;
        }
        int offset = sortLimit.offset == null ? 0 : RexLiteral.intValue((RexNode)sortLimit.offset);
        RelMetadataQuery mq = call.getMetadataQuery();
        return !((double)(offset + RexLiteral.intValue((RexNode)sortLimit.fetch)) >= mq.getRowCount(reducedInput));
    }

    public void onMatch(RelOptRuleCall call) {
        HiveSortLimit sortLimit = (HiveSortLimit)call.rel(0);
        HiveJoin join = (HiveJoin)call.rel(1);
        RelNode inputLeft = join.getLeft();
        RelNode inputRight = join.getRight();
        if (join.getJoinType() == JoinRelType.LEFT) {
            inputLeft = sortLimit.copy(sortLimit.getTraitSet(), inputLeft, sortLimit.getCollation(), sortLimit.offset, sortLimit.fetch);
            ((HiveSortLimit)inputLeft).setRuleCreated(true);
        } else {
            RelCollation rightCollation = (RelCollation)RelCollationTraitDef.INSTANCE.canonize((RelTrait)RelCollations.shift((RelCollation)sortLimit.getCollation(), (int)(-join.getLeft().getRowType().getFieldCount())));
            inputRight = sortLimit.copy(sortLimit.getTraitSet().replace((RelTrait)rightCollation), inputRight, rightCollation, sortLimit.offset, sortLimit.fetch);
            ((HiveSortLimit)inputRight).setRuleCreated(true);
        }
        HiveRelNode result = join.copy(join.getTraitSet(), join.getCondition(), inputLeft, inputRight, join.getJoinType(), join.isSemiJoinDone());
        result = sortLimit.copy(sortLimit.getTraitSet(), result, sortLimit.getCollation(), sortLimit.offset, sortLimit.fetch);
        call.transformTo((RelNode)result);
    }
}

