/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import hive.com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationImpl;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCallBinding;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveRelNode;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortLimit;

public class HiveProjectSortTransposeRule
extends RelOptRule {
    public static final HiveProjectSortTransposeRule INSTANCE = new HiveProjectSortTransposeRule();

    private HiveProjectSortTransposeRule() {
        super(HiveProjectSortTransposeRule.operand(HiveProject.class, (RelOptRuleOperand)HiveProjectSortTransposeRule.operand(HiveSortLimit.class, (RelOptRuleOperandChildren)HiveProjectSortTransposeRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
    }

    protected HiveProjectSortTransposeRule(RelOptRuleOperand operand) {
        super(operand);
    }

    public void onMatch(RelOptRuleCall call) {
        HiveProject project = (HiveProject)call.rel(0);
        HiveSortLimit sort = (HiveSortLimit)call.rel(1);
        RelOptCluster cluster = project.getCluster();
        Mapping map = RelOptUtil.permutationIgnoreCast((List)project.getProjects(), (RelDataType)project.getInput().getRowType()).inverse();
        HashSet<Integer> needed = new HashSet<Integer>();
        for (RelFieldCollation fc : sort.getCollation().getFieldCollations()) {
            needed.add(fc.getFieldIndex());
            RexNode node = (RexNode)project.getProjects().get(map.getTarget(fc.getFieldIndex()));
            if (!node.isA(SqlKind.CAST)) continue;
            RexCall cast = (RexCall)node;
            RexCallBinding binding = RexCallBinding.create((RelDataTypeFactory)cluster.getTypeFactory(), (RexCall)cast, ImmutableList.of(RexUtil.apply((Mappings.TargetMapping)map, (RelCollation)sort.getCollation())));
            if (cast.getOperator().getMonotonicity((SqlOperatorBinding)binding) != SqlMonotonicity.NOT_MONOTONIC) continue;
            return;
        }
        HashMap<Integer, Integer> m = new HashMap<Integer, Integer>();
        for (int projPos = 0; projPos < project.getChildExps().size(); ++projPos) {
            int parentPos;
            Set<Integer> positions;
            RexNode expr = (RexNode)project.getChildExps().get(projPos);
            if (!(expr instanceof RexInputRef) || (positions = HiveCalciteUtil.getInputRefs(expr)).size() > 1 || !needed.contains(parentPos = positions.iterator().next().intValue())) continue;
            m.put(parentPos, projPos);
            needed.remove(parentPos);
        }
        if (!needed.isEmpty()) {
            return;
        }
        ArrayList<RelFieldCollation> fieldCollations = new ArrayList<RelFieldCollation>();
        for (RelFieldCollation fc : sort.getCollation().getFieldCollations()) {
            fieldCollations.add(new RelFieldCollation(((Integer)m.get(fc.getFieldIndex())).intValue(), fc.direction, fc.nullDirection));
        }
        RelTraitSet traitSet = sort.getCluster().traitSetOf((RelTrait)HiveRelNode.CONVENTION);
        RelCollation newCollation = (RelCollation)traitSet.canonize((RelTrait)RelCollationImpl.of(fieldCollations));
        RelNode newProject = project.copy(sort.getInput().getTraitSet(), ImmutableList.of(sort.getInput()));
        HiveSortLimit newSort = sort.copy(newProject.getTraitSet(), newProject, newCollation, sort.offset, sort.fetch);
        call.transformTo((RelNode)newSort);
    }
}

