/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata.formatting;

import hive.com.google.common.collect.Lists;
import hive.org.apache.commons.lang.StringEscapeUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.BinaryColumnStatsData;
import org.apache.hadoop.hive.metastore.api.BooleanColumnStatsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Date;
import org.apache.hadoop.hive.metastore.api.DateColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Decimal;
import org.apache.hadoop.hive.metastore.api.DecimalColumnStatsData;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.StringColumnStatsData;
import org.apache.hadoop.hive.metastore.api.WMFullResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMMapping;
import org.apache.hadoop.hive.metastore.api.WMPool;
import org.apache.hadoop.hive.metastore.api.WMPoolTrigger;
import org.apache.hadoop.hive.metastore.api.WMResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMTrigger;
import org.apache.hadoop.hive.ql.metadata.CheckConstraint;
import org.apache.hadoop.hive.ql.metadata.DefaultConstraint;
import org.apache.hadoop.hive.ql.metadata.ForeignKeyInfo;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.NotNullConstraint;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.PrimaryKeyInfo;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.UniqueConstraint;
import org.apache.hadoop.hive.ql.metadata.formatting.JsonMetaDataFormatter;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatter;
import org.apache.hadoop.hive.ql.metadata.formatting.TextMetaDataFormatter;
import org.apache.hadoop.hive.ql.plan.DescTableDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hive.common.util.HiveStringUtils;

public final class MetaDataFormatUtils {
    public static final String FIELD_DELIM = "\t";
    public static final String LINE_DELIM = "\n";
    static final int DEFAULT_STRINGBUILDER_SIZE = 2048;
    private static final int ALIGNMENT = 20;

    private MetaDataFormatUtils() {
    }

    private static String convertToString(Decimal val) {
        if (val == null) {
            return "";
        }
        HiveDecimal result = HiveDecimal.create(new BigInteger(val.getUnscaled()), (int)val.getScale());
        if (result != null) {
            return result.toString();
        }
        return "";
    }

    private static String convertToString(Date val) {
        if (val == null) {
            return "";
        }
        DateWritableV2 writableValue = new DateWritableV2((int)val.getDaysSinceEpoch());
        return writableValue.toString();
    }

    private static String convertToString(byte[] buf) {
        if (buf == null || buf.length == 0) {
            return "";
        }
        byte[] sub = new byte[]{buf[0], buf[1]};
        return new String(sub);
    }

    static ColumnStatisticsObj getColumnStatisticsObject(String colName, String colType, List<ColumnStatisticsObj> colStats) {
        if (colStats != null && !colStats.isEmpty()) {
            for (ColumnStatisticsObj cso : colStats) {
                if (!cso.getColName().equalsIgnoreCase(colName) || !cso.getColType().equalsIgnoreCase(colType)) continue;
                return cso;
            }
        }
        return null;
    }

    public static String getConstraintsInformation(PrimaryKeyInfo pkInfo, ForeignKeyInfo fkInfo, UniqueConstraint ukInfo, NotNullConstraint nnInfo, DefaultConstraint dInfo, CheckConstraint cInfo) {
        StringBuilder constraintsInfo = new StringBuilder(2048);
        constraintsInfo.append(LINE_DELIM).append("# Constraints").append(LINE_DELIM);
        if (pkInfo != null && !pkInfo.getColNames().isEmpty()) {
            constraintsInfo.append(LINE_DELIM).append("# Primary Key").append(LINE_DELIM);
            MetaDataFormatUtils.getPrimaryKeyInformation(constraintsInfo, pkInfo);
        }
        if (fkInfo != null && !fkInfo.getForeignKeys().isEmpty()) {
            constraintsInfo.append(LINE_DELIM).append("# Foreign Keys").append(LINE_DELIM);
            MetaDataFormatUtils.getForeignKeysInformation(constraintsInfo, fkInfo);
        }
        if (ukInfo != null && !ukInfo.getUniqueConstraints().isEmpty()) {
            constraintsInfo.append(LINE_DELIM).append("# Unique Constraints").append(LINE_DELIM);
            MetaDataFormatUtils.getUniqueConstraintsInformation(constraintsInfo, ukInfo);
        }
        if (nnInfo != null && !nnInfo.getNotNullConstraints().isEmpty()) {
            constraintsInfo.append(LINE_DELIM).append("# Not Null Constraints").append(LINE_DELIM);
            MetaDataFormatUtils.getNotNullConstraintsInformation(constraintsInfo, nnInfo);
        }
        if (dInfo != null && !dInfo.getDefaultConstraints().isEmpty()) {
            constraintsInfo.append(LINE_DELIM).append("# Default Constraints").append(LINE_DELIM);
            MetaDataFormatUtils.getDefaultConstraintsInformation(constraintsInfo, dInfo);
        }
        if (cInfo != null && !cInfo.getCheckConstraints().isEmpty()) {
            constraintsInfo.append(LINE_DELIM).append("# Check Constraints").append(LINE_DELIM);
            MetaDataFormatUtils.getCheckConstraintsInformation(constraintsInfo, cInfo);
        }
        return constraintsInfo.toString();
    }

    private static void getPrimaryKeyInformation(StringBuilder constraintsInfo, PrimaryKeyInfo pkInfo) {
        MetaDataFormatUtils.formatOutput("Table:", pkInfo.getDatabaseName() + "." + pkInfo.getTableName(), constraintsInfo);
        MetaDataFormatUtils.formatOutput("Constraint Name:", pkInfo.getConstraintName(), constraintsInfo);
        Map<Integer, String> colNames = pkInfo.getColNames();
        String columnNames = "Column Names:";
        constraintsInfo.append(String.format("%-20s", "Column Names:")).append(FIELD_DELIM);
        if (colNames != null && colNames.size() > 0) {
            MetaDataFormatUtils.formatOutput(colNames.values().toArray(new String[colNames.size()]), constraintsInfo);
        }
    }

    private static void getForeignKeyColInformation(StringBuilder constraintsInfo, ForeignKeyInfo.ForeignKeyCol fkCol) {
        String[] fkcFields = new String[]{"Parent Column Name:" + fkCol.parentDatabaseName + "." + fkCol.parentTableName + "." + fkCol.parentColName, "Column Name:" + fkCol.childColName, "Key Sequence:" + fkCol.position};
        MetaDataFormatUtils.formatOutput(fkcFields, constraintsInfo);
    }

    private static void getForeignKeyRelInformation(StringBuilder constraintsInfo, String constraintName, List<ForeignKeyInfo.ForeignKeyCol> fkRel) {
        MetaDataFormatUtils.formatOutput("Constraint Name:", constraintName, constraintsInfo);
        if (fkRel != null && fkRel.size() > 0) {
            for (ForeignKeyInfo.ForeignKeyCol fkc : fkRel) {
                MetaDataFormatUtils.getForeignKeyColInformation(constraintsInfo, fkc);
            }
        }
        constraintsInfo.append(LINE_DELIM);
    }

    private static void getForeignKeysInformation(StringBuilder constraintsInfo, ForeignKeyInfo fkInfo) {
        MetaDataFormatUtils.formatOutput("Table:", fkInfo.getChildDatabaseName() + "." + fkInfo.getChildTableName(), constraintsInfo);
        Map<String, List<ForeignKeyInfo.ForeignKeyCol>> foreignKeys = fkInfo.getForeignKeys();
        if (foreignKeys != null && foreignKeys.size() > 0) {
            for (Map.Entry<String, List<ForeignKeyInfo.ForeignKeyCol>> me : foreignKeys.entrySet()) {
                MetaDataFormatUtils.getForeignKeyRelInformation(constraintsInfo, me.getKey(), me.getValue());
            }
        }
    }

    private static void getUniqueConstraintColInformation(StringBuilder constraintsInfo, UniqueConstraint.UniqueConstraintCol ukCol) {
        String[] fkcFields = new String[]{"Column Name:" + ukCol.colName, "Key Sequence:" + ukCol.position};
        MetaDataFormatUtils.formatOutput(fkcFields, constraintsInfo);
    }

    private static void getUniqueConstraintRelInformation(StringBuilder constraintsInfo, String constraintName, List<UniqueConstraint.UniqueConstraintCol> ukRel) {
        MetaDataFormatUtils.formatOutput("Constraint Name:", constraintName, constraintsInfo);
        if (ukRel != null && ukRel.size() > 0) {
            for (UniqueConstraint.UniqueConstraintCol ukc : ukRel) {
                MetaDataFormatUtils.getUniqueConstraintColInformation(constraintsInfo, ukc);
            }
        }
        constraintsInfo.append(LINE_DELIM);
    }

    private static void getUniqueConstraintsInformation(StringBuilder constraintsInfo, UniqueConstraint ukInfo) {
        MetaDataFormatUtils.formatOutput("Table:", ukInfo.getDatabaseName() + "." + ukInfo.getTableName(), constraintsInfo);
        Map<String, List<UniqueConstraint.UniqueConstraintCol>> uniqueConstraints = ukInfo.getUniqueConstraints();
        if (uniqueConstraints != null && uniqueConstraints.size() > 0) {
            for (Map.Entry<String, List<UniqueConstraint.UniqueConstraintCol>> me : uniqueConstraints.entrySet()) {
                MetaDataFormatUtils.getUniqueConstraintRelInformation(constraintsInfo, me.getKey(), me.getValue());
            }
        }
    }

    private static void getNotNullConstraintsInformation(StringBuilder constraintsInfo, NotNullConstraint nnInfo) {
        MetaDataFormatUtils.formatOutput("Table:", nnInfo.getDatabaseName() + "." + nnInfo.getTableName(), constraintsInfo);
        Map<String, String> notNullConstraints = nnInfo.getNotNullConstraints();
        if (notNullConstraints != null && notNullConstraints.size() > 0) {
            for (Map.Entry<String, String> me : notNullConstraints.entrySet()) {
                MetaDataFormatUtils.formatOutput("Constraint Name:", me.getKey(), constraintsInfo);
                MetaDataFormatUtils.formatOutput("Column Name:", me.getValue(), constraintsInfo);
                constraintsInfo.append(LINE_DELIM);
            }
        }
    }

    private static void getDefaultConstraintColInformation(StringBuilder constraintsInfo, DefaultConstraint.DefaultConstraintCol ukCol) {
        String[] fkcFields = new String[]{"Column Name:" + ukCol.colName, "Default Value:" + ukCol.defaultVal};
        MetaDataFormatUtils.formatOutput(fkcFields, constraintsInfo);
    }

    private static void getCheckConstraintColInformation(StringBuilder constraintsInfo, CheckConstraint.CheckConstraintCol ukCol) {
        String[] fkcFields = new String[]{"Column Name:" + ukCol.colName, "Check Value:" + ukCol.checkExpression};
        MetaDataFormatUtils.formatOutput(fkcFields, constraintsInfo);
    }

    private static void getDefaultConstraintRelInformation(StringBuilder constraintsInfo, String constraintName, List<DefaultConstraint.DefaultConstraintCol> ukRel) {
        MetaDataFormatUtils.formatOutput("Constraint Name:", constraintName, constraintsInfo);
        if (ukRel != null && ukRel.size() > 0) {
            for (DefaultConstraint.DefaultConstraintCol ukc : ukRel) {
                MetaDataFormatUtils.getDefaultConstraintColInformation(constraintsInfo, ukc);
            }
        }
        constraintsInfo.append(LINE_DELIM);
    }

    private static void getCheckConstraintRelInformation(StringBuilder constraintsInfo, String constraintName, List<CheckConstraint.CheckConstraintCol> ukRel) {
        MetaDataFormatUtils.formatOutput("Constraint Name:", constraintName, constraintsInfo);
        if (ukRel != null && ukRel.size() > 0) {
            for (CheckConstraint.CheckConstraintCol ukc : ukRel) {
                MetaDataFormatUtils.getCheckConstraintColInformation(constraintsInfo, ukc);
            }
        }
        constraintsInfo.append(LINE_DELIM);
    }

    private static void getDefaultConstraintsInformation(StringBuilder constraintsInfo, DefaultConstraint dInfo) {
        MetaDataFormatUtils.formatOutput("Table:", dInfo.getDatabaseName() + "." + dInfo.getTableName(), constraintsInfo);
        Map<String, List<DefaultConstraint.DefaultConstraintCol>> defaultConstraints = dInfo.getDefaultConstraints();
        if (defaultConstraints != null && defaultConstraints.size() > 0) {
            for (Map.Entry<String, List<DefaultConstraint.DefaultConstraintCol>> me : defaultConstraints.entrySet()) {
                MetaDataFormatUtils.getDefaultConstraintRelInformation(constraintsInfo, me.getKey(), me.getValue());
            }
        }
    }

    private static void getCheckConstraintsInformation(StringBuilder constraintsInfo, CheckConstraint dInfo) {
        MetaDataFormatUtils.formatOutput("Table:", dInfo.getDatabaseName() + "." + dInfo.getTableName(), constraintsInfo);
        Map<String, List<CheckConstraint.CheckConstraintCol>> checkConstraints = dInfo.getCheckConstraints();
        if (checkConstraints != null && checkConstraints.size() > 0) {
            for (Map.Entry<String, List<CheckConstraint.CheckConstraintCol>> me : checkConstraints.entrySet()) {
                MetaDataFormatUtils.getCheckConstraintRelInformation(constraintsInfo, me.getKey(), me.getValue());
            }
        }
    }

    public static String getPartitionInformation(Partition part) {
        StringBuilder tableInfo = new StringBuilder(2048);
        tableInfo.append(LINE_DELIM).append("# Detailed Partition Information").append(LINE_DELIM);
        MetaDataFormatUtils.getPartitionMetaDataInformation(tableInfo, part);
        if (part.getTable().getTableType() != TableType.VIRTUAL_VIEW) {
            tableInfo.append(LINE_DELIM).append("# Storage Information").append(LINE_DELIM);
            MetaDataFormatUtils.getStorageDescriptorInfo(tableInfo, part.getTPartition().getSd());
        }
        return tableInfo.toString();
    }

    public static String getTableInformation(Table table, boolean isOutputPadded) {
        StringBuilder tableInfo = new StringBuilder(2048);
        tableInfo.append(LINE_DELIM).append("# Detailed Table Information").append(LINE_DELIM);
        MetaDataFormatUtils.getTableMetaDataInformation(tableInfo, table, isOutputPadded);
        tableInfo.append(LINE_DELIM).append("# Storage Information").append(LINE_DELIM);
        MetaDataFormatUtils.getStorageDescriptorInfo(tableInfo, table.getTTable().getSd());
        if (table.isView() || table.isMaterializedView()) {
            tableInfo.append(LINE_DELIM).append("# View Information").append(LINE_DELIM);
            MetaDataFormatUtils.getViewInfo(tableInfo, table);
        }
        return tableInfo.toString();
    }

    private static void getViewInfo(StringBuilder tableInfo, Table tbl) {
        MetaDataFormatUtils.formatOutput("View Original Text:", tbl.getViewOriginalText(), tableInfo);
        MetaDataFormatUtils.formatOutput("View Expanded Text:", tbl.getViewExpandedText(), tableInfo);
        MetaDataFormatUtils.formatOutput("View Rewrite Enabled:", tbl.isRewriteEnabled() ? "Yes" : "No", tableInfo);
    }

    private static void getStorageDescriptorInfo(StringBuilder tableInfo, StorageDescriptor storageDesc) {
        MetaDataFormatUtils.formatOutput("SerDe Library:", storageDesc.getSerdeInfo().getSerializationLib(), tableInfo);
        MetaDataFormatUtils.formatOutput("InputFormat:", storageDesc.getInputFormat(), tableInfo);
        MetaDataFormatUtils.formatOutput("OutputFormat:", storageDesc.getOutputFormat(), tableInfo);
        MetaDataFormatUtils.formatOutput("Compressed:", storageDesc.isCompressed() ? "Yes" : "No", tableInfo);
        MetaDataFormatUtils.formatOutput("Num Buckets:", String.valueOf(storageDesc.getNumBuckets()), tableInfo);
        MetaDataFormatUtils.formatOutput("Bucket Columns:", storageDesc.getBucketCols().toString(), tableInfo);
        MetaDataFormatUtils.formatOutput("Sort Columns:", storageDesc.getSortCols().toString(), tableInfo);
        if (storageDesc.isStoredAsSubDirectories()) {
            MetaDataFormatUtils.formatOutput("Stored As SubDirectories:", "Yes", tableInfo);
        }
        if (null != storageDesc.getSkewedInfo()) {
            List<List<String>> skewedColValues;
            List<String> skewedColNames = MetaDataFormatUtils.sortedList(storageDesc.getSkewedInfo().getSkewedColNames());
            if (skewedColNames != null && skewedColNames.size() > 0) {
                MetaDataFormatUtils.formatOutput("Skewed Columns:", skewedColNames.toString(), tableInfo);
            }
            if ((skewedColValues = MetaDataFormatUtils.sortedList(storageDesc.getSkewedInfo().getSkewedColValues(), new VectorComparator())) != null && skewedColValues.size() > 0) {
                MetaDataFormatUtils.formatOutput("Skewed Values:", skewedColValues.toString(), tableInfo);
            }
            TreeMap skewedColMap = new TreeMap(new VectorComparator());
            skewedColMap.putAll(storageDesc.getSkewedInfo().getSkewedColValueLocationMaps());
            if (skewedColMap != null && skewedColMap.size() > 0) {
                MetaDataFormatUtils.formatOutput("Skewed Value to Path:", ((Object)skewedColMap).toString(), tableInfo);
                TreeMap truncatedSkewedColMap = new TreeMap(new VectorComparator());
                Set entries = skewedColMap.entrySet();
                for (Map.Entry entry : entries) {
                    truncatedSkewedColMap.put((List)entry.getKey(), PlanUtils.removePrefixFromWarehouseConfig((String)entry.getValue()));
                }
                MetaDataFormatUtils.formatOutput("Skewed Value to Truncated Path:", ((Object)truncatedSkewedColMap).toString(), tableInfo);
            }
        }
        if (storageDesc.getSerdeInfo().getParametersSize() > 0) {
            tableInfo.append("Storage Desc Params:").append(LINE_DELIM);
            MetaDataFormatUtils.displayAllParameters(storageDesc.getSerdeInfo().getParameters(), tableInfo);
        }
    }

    private static void getTableMetaDataInformation(StringBuilder tableInfo, Table tbl, boolean isOutputPadded) {
        MetaDataFormatUtils.formatOutput("Database:", tbl.getDbName(), tableInfo);
        MetaDataFormatUtils.formatOutput("OwnerType:", tbl.getOwnerType() != null ? tbl.getOwnerType().name() : "null", tableInfo);
        MetaDataFormatUtils.formatOutput("Owner:", tbl.getOwner(), tableInfo);
        MetaDataFormatUtils.formatOutput("CreateTime:", MetaDataFormatUtils.formatDate(tbl.getTTable().getCreateTime()), tableInfo);
        MetaDataFormatUtils.formatOutput("LastAccessTime:", MetaDataFormatUtils.formatDate(tbl.getTTable().getLastAccessTime()), tableInfo);
        MetaDataFormatUtils.formatOutput("Retention:", Integer.toString(tbl.getRetention()), tableInfo);
        if (!tbl.isView()) {
            MetaDataFormatUtils.formatOutput("Location:", tbl.getDataLocation().toString(), tableInfo);
        }
        MetaDataFormatUtils.formatOutput("Table Type:", tbl.getTableType().name(), tableInfo);
        if (tbl.getParameters().size() > 0) {
            tableInfo.append("Table Parameters:").append(LINE_DELIM);
            MetaDataFormatUtils.displayAllParameters(tbl.getParameters(), tableInfo, false, isOutputPadded);
        }
    }

    private static void getPartitionMetaDataInformation(StringBuilder tableInfo, Partition part) {
        MetaDataFormatUtils.formatOutput("Partition Value:", part.getValues().toString(), tableInfo);
        MetaDataFormatUtils.formatOutput("Database:", part.getTPartition().getDbName(), tableInfo);
        MetaDataFormatUtils.formatOutput("Table:", part.getTable().getTableName(), tableInfo);
        MetaDataFormatUtils.formatOutput("CreateTime:", MetaDataFormatUtils.formatDate(part.getTPartition().getCreateTime()), tableInfo);
        MetaDataFormatUtils.formatOutput("LastAccessTime:", MetaDataFormatUtils.formatDate(part.getTPartition().getLastAccessTime()), tableInfo);
        MetaDataFormatUtils.formatOutput("Location:", part.getLocation(), tableInfo);
        if (part.getTPartition().getParameters().size() > 0) {
            tableInfo.append("Partition Parameters:").append(LINE_DELIM);
            MetaDataFormatUtils.displayAllParameters(part.getTPartition().getParameters(), tableInfo);
        }
    }

    private static void displayAllParameters(Map<String, String> params, StringBuilder tableInfo) {
        MetaDataFormatUtils.displayAllParameters(params, tableInfo, true, false);
    }

    private static void displayAllParameters(Map<String, String> params, StringBuilder tableInfo, boolean escapeUnicode, boolean isOutputPadded) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            tableInfo.append(FIELD_DELIM);
            MetaDataFormatUtils.formatOutput(key, escapeUnicode ? StringEscapeUtils.escapeJava(params.get(key)) : HiveStringUtils.escapeJava(params.get(key)), tableInfo, isOutputPadded);
        }
    }

    static String getComment(FieldSchema col) {
        return col.getComment() != null ? col.getComment() : "";
    }

    static <T extends Comparable<T>> List<T> sortedList(List<T> list) {
        if (list == null || list.size() <= 1) {
            return list;
        }
        ArrayList<T> ret = new ArrayList<T>();
        ret.addAll(list);
        Collections.sort(ret);
        return ret;
    }

    static <T> List<T> sortedList(List<T> list, Comparator<T> comp) {
        if (list == null || list.size() <= 1) {
            return list;
        }
        ArrayList<T> ret = new ArrayList<T>();
        ret.addAll(list);
        Collections.sort(ret, comp);
        return ret;
    }

    private static String formatDate(long timeInSeconds) {
        if (timeInSeconds != 0L) {
            java.util.Date date = new java.util.Date(timeInSeconds * 1000L);
            return date.toString();
        }
        return "UNKNOWN";
    }

    static void formatOutput(String[] fields, StringBuilder tableInfo, boolean isLastLinePadded, boolean isFormatted) {
        if (!isFormatted) {
            for (int i = 0; i < fields.length; ++i) {
                String value = HiveStringUtils.escapeJava(fields[i]);
                if (value != null) {
                    tableInfo.append((Object)value);
                }
                tableInfo.append(i == fields.length - 1 ? LINE_DELIM : FIELD_DELIM);
            }
        } else {
            int[] paddings = new int[fields.length - 1];
            if (fields.length > 1) {
                for (int i = 0; i < fields.length - 1; ++i) {
                    if (fields[i] == null) {
                        tableInfo.append(FIELD_DELIM);
                        continue;
                    }
                    tableInfo.append(String.format("%-20s", fields[i])).append(FIELD_DELIM);
                    paddings[i] = 20 > fields[i].length() ? 20 : fields[i].length();
                }
            }
            if (fields.length > 0) {
                String value = fields[fields.length - 1];
                String unescapedValue = isLastLinePadded && value != null ? value.replaceAll("\\\\n|\\\\r|\\\\r\\\\n", LINE_DELIM) : value;
                MetaDataFormatUtils.indentMultilineValue(unescapedValue, tableInfo, paddings, false);
            } else {
                tableInfo.append(LINE_DELIM);
            }
        }
    }

    private static void formatOutput(String[] fields, StringBuilder tableInfo) {
        MetaDataFormatUtils.formatOutput(fields, tableInfo, false, true);
    }

    private static void formatOutput(String name, String value, StringBuilder tableInfo) {
        tableInfo.append(String.format("%-20s", name)).append(FIELD_DELIM);
        int colNameLength = 20 > name.length() ? 20 : name.length();
        MetaDataFormatUtils.indentMultilineValue(value, tableInfo, new int[]{0, colNameLength}, true);
    }

    static void formatOutput(String name, String value, StringBuilder tableInfo, boolean isOutputPadded) {
        String unescapedValue = isOutputPadded && value != null ? value.replaceAll("\\\\n|\\\\r|\\\\r\\\\n", LINE_DELIM) : value;
        MetaDataFormatUtils.formatOutput(name, unescapedValue, tableInfo);
    }

    public static String[] extractColumnValues(FieldSchema col) {
        return MetaDataFormatUtils.extractColumnValues(col, false, null);
    }

    public static String[] extractColumnValues(FieldSchema col, boolean isColStatsAvailable, ColumnStatisticsObj columnStatisticsObj) {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(col.getName());
        ret.add(col.getType());
        if (isColStatsAvailable) {
            if (columnStatisticsObj != null) {
                ColumnStatisticsData csd = columnStatisticsObj.getStatsData();
                if (csd.isSetBinaryStats()) {
                    BinaryColumnStatsData bcsd = csd.getBinaryStats();
                    ret.addAll(Lists.newArrayList("", "", "" + bcsd.getNumNulls(), "", "" + bcsd.getAvgColLen(), "" + bcsd.getMaxColLen(), "", "", MetaDataFormatUtils.convertToString(bcsd.getBitVectors())));
                } else if (csd.isSetStringStats()) {
                    StringColumnStatsData scsd = csd.getStringStats();
                    ret.addAll(Lists.newArrayList("", "", "" + scsd.getNumNulls(), "" + scsd.getNumDVs(), "" + scsd.getAvgColLen(), "" + scsd.getMaxColLen(), "", "", MetaDataFormatUtils.convertToString(scsd.getBitVectors())));
                } else if (csd.isSetBooleanStats()) {
                    BooleanColumnStatsData bcsd = csd.getBooleanStats();
                    ret.addAll(Lists.newArrayList("", "", "" + bcsd.getNumNulls(), "", "", "", "" + bcsd.getNumTrues(), "" + bcsd.getNumFalses(), MetaDataFormatUtils.convertToString(bcsd.getBitVectors())));
                } else if (csd.isSetDecimalStats()) {
                    DecimalColumnStatsData dcsd = csd.getDecimalStats();
                    ret.addAll(Lists.newArrayList(MetaDataFormatUtils.convertToString(dcsd.getLowValue()), MetaDataFormatUtils.convertToString(dcsd.getHighValue()), "" + dcsd.getNumNulls(), "" + dcsd.getNumDVs(), "", "", "", "", MetaDataFormatUtils.convertToString(dcsd.getBitVectors())));
                } else if (csd.isSetDoubleStats()) {
                    DoubleColumnStatsData dcsd = csd.getDoubleStats();
                    ret.addAll(Lists.newArrayList("" + dcsd.getLowValue(), "" + dcsd.getHighValue(), "" + dcsd.getNumNulls(), "" + dcsd.getNumDVs(), "", "", "", "", MetaDataFormatUtils.convertToString(dcsd.getBitVectors())));
                } else if (csd.isSetLongStats()) {
                    LongColumnStatsData lcsd = csd.getLongStats();
                    ret.addAll(Lists.newArrayList("" + lcsd.getLowValue(), "" + lcsd.getHighValue(), "" + lcsd.getNumNulls(), "" + lcsd.getNumDVs(), "", "", "", "", MetaDataFormatUtils.convertToString(lcsd.getBitVectors())));
                } else if (csd.isSetDateStats()) {
                    DateColumnStatsData dcsd = csd.getDateStats();
                    ret.addAll(Lists.newArrayList(MetaDataFormatUtils.convertToString(dcsd.getLowValue()), MetaDataFormatUtils.convertToString(dcsd.getHighValue()), "" + dcsd.getNumNulls(), "" + dcsd.getNumDVs(), "", "", "", "", MetaDataFormatUtils.convertToString(dcsd.getBitVectors())));
                }
            } else {
                ret.addAll(Lists.newArrayList("", "", "", "", "", "", "", "", ""));
            }
        }
        ret.add(MetaDataFormatUtils.getComment(col));
        return ret.toArray(new String[0]);
    }

    private static void indentMultilineValue(String value, StringBuilder tableInfo, int[] columnWidths, boolean printNull) {
        if (value == null) {
            if (printNull) {
                tableInfo.append(String.format("%-20s", value));
            }
            tableInfo.append(LINE_DELIM);
        } else {
            String[] valueSegments = value.split("\n|\r|\r\n");
            tableInfo.append(String.format("%-20s", valueSegments[0])).append(LINE_DELIM);
            for (int i = 1; i < valueSegments.length; ++i) {
                MetaDataFormatUtils.printPadding(tableInfo, columnWidths);
                tableInfo.append(String.format("%-20s", valueSegments[i])).append(LINE_DELIM);
            }
        }
    }

    private static void printPadding(StringBuilder tableInfo, int[] columnWidths) {
        for (int columnWidth : columnWidths) {
            if (columnWidth == 0) {
                tableInfo.append(FIELD_DELIM);
                continue;
            }
            tableInfo.append(String.format("%" + columnWidth + "s\t", ""));
        }
    }

    public static String[] getColumnsHeader(List<ColumnStatisticsObj> colStats) {
        boolean showColStats = false;
        if (colStats != null) {
            showColStats = true;
        }
        return DescTableDesc.getSchema(showColStats).split("#")[0].split(",");
    }

    public static MetaDataFormatter getFormatter(HiveConf conf) {
        if ("json".equals(conf.get(HiveConf.ConfVars.HIVE_DDL_OUTPUT_FORMAT.varname, "text"))) {
            return new JsonMetaDataFormatter();
        }
        return new TextMetaDataFormatter(conf.getIntVar(HiveConf.ConfVars.CLIPRETTYOUTPUTNUMCOLS), conf.getBoolVar(HiveConf.ConfVars.HIVE_DISPLAY_PARTITION_COLUMNS_SEPARATELY));
    }

    public static void formatFullRP(RPFormatter rpFormatter, WMFullResourcePlan fullRp) throws HiveException {
        try {
            WMResourcePlan plan = fullRp.getPlan();
            Integer parallelism = plan.isSetQueryParallelism() ? Integer.valueOf(plan.getQueryParallelism()) : null;
            String defaultPool = plan.isSetDefaultPoolPath() ? plan.getDefaultPoolPath() : null;
            rpFormatter.startRP(plan.getName(), "status", plan.getStatus().toString(), "parallelism", parallelism, "defaultPool", defaultPool);
            rpFormatter.startPools();
            PoolTreeNode root = PoolTreeNode.makePoolTree(fullRp);
            root.sortChildren();
            for (PoolTreeNode pool : root.children) {
                pool.writePoolTreeNode(rpFormatter);
            }
            rpFormatter.endPools();
            rpFormatter.endRP();
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
    }

    private static class PoolTreeNode {
        private String nonPoolName;
        private WMPool pool;
        private final List<PoolTreeNode> children = new ArrayList<PoolTreeNode>();
        private final List<WMTrigger> triggers = new ArrayList<WMTrigger>();
        private final HashMap<String, List<String>> mappings = new HashMap();
        private boolean isDefault;

        private PoolTreeNode() {
        }

        private void writePoolTreeNode(RPFormatter rpFormatter) throws IOException {
            if (this.pool != null) {
                String path = this.pool.getPoolPath();
                int n = path.lastIndexOf(46);
                if (n != -1) {
                    path = path.substring(n + 1);
                }
                Double allocFraction = this.pool.getAllocFraction();
                String schedulingPolicy = this.pool.isSetSchedulingPolicy() ? this.pool.getSchedulingPolicy() : null;
                Integer parallelism = this.pool.getQueryParallelism();
                rpFormatter.startPool(path, "allocFraction", allocFraction, "schedulingPolicy", schedulingPolicy, "parallelism", parallelism);
            } else {
                rpFormatter.startPool(this.nonPoolName, new Object[0]);
            }
            rpFormatter.startTriggers();
            for (WMTrigger wMTrigger : this.triggers) {
                rpFormatter.formatTrigger(wMTrigger.getTriggerName(), wMTrigger.getActionExpression(), wMTrigger.getTriggerExpression());
            }
            rpFormatter.endTriggers();
            rpFormatter.startMappings();
            for (Map.Entry entry : this.mappings.entrySet()) {
                ((List)entry.getValue()).sort(String::compareTo);
                rpFormatter.formatMappingType((String)entry.getKey(), (List)entry.getValue());
            }
            if (this.isDefault) {
                rpFormatter.formatMappingType("default", Lists.newArrayList());
            }
            rpFormatter.endMappings();
            rpFormatter.startPools();
            for (PoolTreeNode poolTreeNode : this.children) {
                poolTreeNode.writePoolTreeNode(rpFormatter);
            }
            rpFormatter.endPools();
            rpFormatter.endPool();
        }

        private void sortChildren() {
            this.children.sort((p1, p2) -> {
                if (p2.pool == null) {
                    return p1.pool == null ? 0 : -1;
                }
                if (p1.pool == null) {
                    return 1;
                }
                return Double.compare(p2.pool.getAllocFraction(), p1.pool.getAllocFraction());
            });
            for (PoolTreeNode child : this.children) {
                child.sortChildren();
            }
            this.triggers.sort((t1, t2) -> t1.getTriggerName().compareTo(t2.getTriggerName()));
        }

        static PoolTreeNode makePoolTree(WMFullResourcePlan fullRp) {
            PoolTreeNode curr;
            HashMap<String, PoolTreeNode> poolMap = new HashMap<String, PoolTreeNode>();
            PoolTreeNode root = new PoolTreeNode();
            for (WMPool pool : fullRp.getPools()) {
                PoolTreeNode parent;
                int ind;
                String path = pool.getPoolPath();
                Object curr2 = (PoolTreeNode)poolMap.get(path);
                if (curr2 == null) {
                    curr2 = new PoolTreeNode();
                    poolMap.put(path, (PoolTreeNode)curr2);
                }
                ((PoolTreeNode)curr2).pool = pool;
                if (fullRp.getPlan().isSetDefaultPoolPath() && fullRp.getPlan().getDefaultPoolPath().equals(path)) {
                    ((PoolTreeNode)curr2).isDefault = true;
                }
                if ((ind = path.lastIndexOf(46)) == -1) {
                    parent = root;
                } else {
                    String parentPath = path.substring(0, ind);
                    parent = (PoolTreeNode)poolMap.get(parentPath);
                    if (parent == null) {
                        parent = new PoolTreeNode();
                        poolMap.put(parentPath, parent);
                    }
                }
                parent.children.add((PoolTreeNode)curr2);
            }
            HashMap<String, WMTrigger> triggerMap = new HashMap<String, WMTrigger>();
            ArrayList<WMTrigger> unmanagedTriggers = new ArrayList<WMTrigger>();
            HashSet<WMTrigger> unusedTriggers = new HashSet<WMTrigger>();
            if (fullRp.isSetTriggers()) {
                for (WMTrigger trigger : fullRp.getTriggers()) {
                    triggerMap.put(trigger.getTriggerName(), trigger);
                    if (trigger.isIsInUnmanaged()) {
                        unmanagedTriggers.add(trigger);
                        continue;
                    }
                    unusedTriggers.add(trigger);
                }
            }
            if (fullRp.isSetPoolTriggers()) {
                for (WMPoolTrigger pool2Trigger : fullRp.getPoolTriggers()) {
                    PoolTreeNode node = (PoolTreeNode)poolMap.get(pool2Trigger.getPool());
                    WMTrigger trigger = (WMTrigger)triggerMap.get(pool2Trigger.getTrigger());
                    if (node == null || trigger == null) {
                        throw new IllegalStateException("Invalid trigger to pool: " + pool2Trigger.getPool() + ", " + pool2Trigger.getTrigger());
                    }
                    unusedTriggers.remove(trigger);
                    node.triggers.add(trigger);
                }
            }
            HashMap<String, List<String>> unmanagedMappings = new HashMap<String, List<String>>();
            HashMap invalidMappings = new HashMap();
            if (fullRp.isSetMappings()) {
                for (WMMapping mapping : fullRp.getMappings()) {
                    if (mapping.isSetPoolPath()) {
                        PoolTreeNode destNode = (PoolTreeNode)poolMap.get(mapping.getPoolPath());
                        PoolTreeNode.addMappingToMap(destNode == null ? invalidMappings : destNode.mappings, mapping);
                        continue;
                    }
                    PoolTreeNode.addMappingToMap(unmanagedMappings, mapping);
                }
            }
            if (!unmanagedTriggers.isEmpty() || !unmanagedMappings.isEmpty()) {
                curr = PoolTreeNode.createNonPoolNode(poolMap, "unmanaged queries", root);
                curr.triggers.addAll(unmanagedTriggers);
                curr.mappings.putAll(unmanagedMappings);
            }
            if (!unusedTriggers.isEmpty()) {
                curr = PoolTreeNode.createNonPoolNode(poolMap, "unused triggers", root);
                curr.triggers.addAll(unusedTriggers);
            }
            if (!invalidMappings.isEmpty()) {
                curr = PoolTreeNode.createNonPoolNode(poolMap, "invalid mappings", root);
                curr.mappings.putAll(invalidMappings);
            }
            return root;
        }

        private static PoolTreeNode createNonPoolNode(Map<String, PoolTreeNode> poolMap, String name, PoolTreeNode root) {
            PoolTreeNode result;
            while ((result = poolMap.get(name = "<" + (String)name + ">")) != null) {
            }
            result = new PoolTreeNode();
            result.nonPoolName = name;
            poolMap.put((String)name, result);
            root.children.add(result);
            return result;
        }

        private static void addMappingToMap(HashMap<String, List<String>> map, WMMapping mapping) {
            List<String> list = map.get(mapping.getEntityType());
            if (list == null) {
                list = new ArrayList<String>();
                map.put(mapping.getEntityType(), list);
            }
            list.add(mapping.getEntityName());
        }
    }

    public static interface RPFormatter {
        public void startRP(String var1, Object ... var2) throws IOException;

        public void endRP() throws IOException;

        public void startPools() throws IOException;

        public void startPool(String var1, Object ... var2) throws IOException;

        public void endPool() throws IOException;

        public void endPools() throws IOException;

        public void startTriggers() throws IOException;

        public void formatTrigger(String var1, String var2, String var3) throws IOException;

        public void endTriggers() throws IOException;

        public void startMappings() throws IOException;

        public void formatMappingType(String var1, List<String> var2) throws IOException;

        public void endMappings() throws IOException;
    }

    private static class VectorComparator<T extends Comparable<T>>
    implements Comparator<List<T>> {
        private VectorComparator() {
        }

        @Override
        public int compare(List<T> listA, List<T> listB) {
            for (int i = 0; i < listA.size() && i < listB.size(); ++i) {
                Comparable valA = (Comparable)listA.get(i);
                Comparable valB = (Comparable)listB.get(i);
                if (valA != null) {
                    int ret = valA.compareTo(valB);
                    if (ret == 0) continue;
                    return ret;
                }
                if (valB == null) continue;
                return -1;
            }
            return Integer.compare(listA.size(), listB.size());
        }
    }
}

