/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.ptf;

import hive.com.google.common.base.Preconditions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorBase;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

public class VectorPTFEvaluatorDecimalSum
extends VectorPTFEvaluatorBase {
    private static final long serialVersionUID = 1L;
    private static final String CLASS_NAME = VectorPTFEvaluatorDecimalSum.class.getName();
    private static final Log LOG = LogFactory.getLog((String)CLASS_NAME);
    protected boolean isGroupResultNull;
    protected HiveDecimalWritable sum = new HiveDecimalWritable();
    protected HiveDecimalWritable temp = new HiveDecimalWritable();

    public VectorPTFEvaluatorDecimalSum(WindowFrameDef windowFrameDef, VectorExpression inputVecExpr, int outputColumnNum) {
        super(windowFrameDef, inputVecExpr, outputColumnNum);
        this.resetEvaluator();
    }

    @Override
    public void evaluateGroupBatch(VectorizedRowBatch batch, boolean isLastGroupBatch) throws HiveException {
        block14: {
            DecimalColumnVector decimalColVector;
            int size;
            block13: {
                this.evaluateInputExpr(batch);
                Preconditions.checkState(!batch.selectedInUse);
                size = batch.size;
                if (size == 0) {
                    return;
                }
                decimalColVector = (DecimalColumnVector)batch.cols[this.inputColumnNum];
                if (!decimalColVector.isRepeating) break block13;
                if (!decimalColVector.noNulls && decimalColVector.isNull[0]) break block14;
                this.temp.setFromLong(batch.size);
                if (this.isGroupResultNull) {
                    this.sum.set(decimalColVector.vector[0]);
                    this.sum.mutateMultiply(this.temp);
                    this.isGroupResultNull = false;
                } else {
                    this.temp.mutateMultiply(decimalColVector.vector[0]);
                    this.sum.mutateAdd(this.temp);
                }
                break block14;
            }
            if (decimalColVector.noNulls) {
                HiveDecimalWritable[] vector = decimalColVector.vector;
                if (this.isGroupResultNull) {
                    this.sum.set(vector[0]);
                    this.isGroupResultNull = false;
                } else {
                    this.sum.mutateAdd(vector[0]);
                }
                for (int i = 1; i < size; ++i) {
                    this.sum.mutateAdd(vector[i]);
                }
            } else {
                boolean[] batchIsNull = decimalColVector.isNull;
                int i = 0;
                while (batchIsNull[i]) {
                    if (++i < size) continue;
                    return;
                }
                HiveDecimalWritable[] vector = decimalColVector.vector;
                if (this.isGroupResultNull) {
                    this.sum.set(vector[i++]);
                    this.isGroupResultNull = false;
                } else {
                    this.sum.mutateAdd(vector[i++]);
                }
                while (i < size) {
                    if (!batchIsNull[i]) {
                        this.sum.mutateAdd(vector[i]);
                    }
                    ++i;
                }
            }
        }
    }

    @Override
    public boolean isGroupResultNull() {
        return this.isGroupResultNull;
    }

    @Override
    public ColumnVector.Type getResultColumnVectorType() {
        return ColumnVector.Type.DECIMAL;
    }

    @Override
    public HiveDecimalWritable getDecimalGroupResult() {
        return this.sum;
    }

    @Override
    public void resetEvaluator() {
        this.isGroupResultNull = true;
        this.sum.set(HiveDecimal.ZERO);
    }
}

