/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark;

import hive.com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.spark.SparkTask;
import org.apache.hadoop.hive.ql.exec.spark.session.SparkSession;
import org.apache.hadoop.hive.ql.exec.spark.session.SparkSessionManager;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.spark.OptimizeSparkProcContext;
import org.apache.hadoop.hive.ql.parse.spark.SparkPartitionPruningSinkOperator;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.SparkWork;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hive.spark.client.SparkClientUtilities;
import org.apache.spark.SparkConf;

public class SparkUtilities {
    public static HiveKey copyHiveKey(HiveKey key) {
        HiveKey copy = new HiveKey();
        copy.setDistKeyLength(key.getDistKeyLength());
        copy.setHashCode(key.hashCode());
        copy.set(key);
        return copy;
    }

    public static BytesWritable copyBytesWritable(BytesWritable bw) {
        BytesWritable copy = new BytesWritable();
        copy.set(bw);
        return copy;
    }

    public static URI uploadToHDFS(URI source, HiveConf conf) throws IOException {
        Path localFile = new Path(source.getPath());
        Path remoteFile = new Path(SessionState.get().getSparkSession().getHDFSSessionDir(), SparkUtilities.getFileName(source));
        FileSystem fileSystem = FileSystem.get((URI)remoteFile.toUri(), (Configuration)conf);
        fileSystem.copyFromLocalFile(false, true, localFile, remoteFile);
        Path fullPath = fileSystem.getFileStatus(remoteFile).getPath();
        return fullPath.toUri();
    }

    public static boolean needUploadToHDFS(URI source, SparkConf sparkConf) {
        String master = sparkConf.get("spark.master");
        String deployMode = sparkConf.contains("spark.submit.deployMode") ? sparkConf.get("spark.submit.deployMode") : null;
        return SparkClientUtilities.isYarnClusterMode((String)master, (String)deployMode) && !source.getScheme().equals("maprfs") && !source.getScheme().equals("viewfs");
    }

    private static String getFileName(URI uri) {
        if (uri == null) {
            return null;
        }
        String name = FilenameUtils.getName((String)uri.getPath());
        return name;
    }

    public static boolean isDedicatedCluster(Configuration conf) {
        String master = conf.get("spark.master");
        return SparkClientUtilities.isYarnMaster((String)master) || SparkClientUtilities.isLocalMaster((String)master);
    }

    public static SparkSession getSparkSession(HiveConf conf, SparkSessionManager sparkSessionManager) throws HiveException {
        SparkSession sparkSession = SessionState.get().getSparkSession();
        HiveConf sessionConf = SessionState.get().getConf();
        if (sessionConf.getSparkConfigUpdated() || conf.getSparkConfigUpdated()) {
            sparkSessionManager.closeSession(sparkSession);
            sparkSession = null;
            conf.setSparkConfigUpdated(false);
            sessionConf.setSparkConfigUpdated(false);
        }
        sparkSession = sparkSessionManager.getSession(sparkSession, conf, true);
        SessionState.get().setSparkSession(sparkSession);
        return sparkSession;
    }

    public static Path generateTmpPathForPartitionPruning(Path basePath, String id) {
        return new Path(basePath, id);
    }

    public static String getWorkId(BaseWork work) {
        String workName = work.getName();
        return workName.substring(workName.indexOf(" ") + 1);
    }

    public static SparkTask createSparkTask(HiveConf conf) {
        return (SparkTask)TaskFactory.get(new SparkWork(conf.getVar(HiveConf.ConfVars.HIVEQUERYID)));
    }

    public static SparkTask createSparkTask(SparkWork work, HiveConf conf) {
        return (SparkTask)TaskFactory.get(work);
    }

    public static void collectOp(Collection<Operator<?>> result, Operator<?> root, Class<?> clazz) {
        Preconditions.checkArgument(clazz != null, "AssertionError: clazz should not be null");
        if (root == null) {
            return;
        }
        if (clazz.isAssignableFrom(root.getClass())) {
            result.add(root);
        }
        for (Operator<OperatorDesc> child : root.getChildOperators()) {
            SparkUtilities.collectOp(result, child, clazz);
        }
    }

    public static <T extends Operator<?>> void collectOp(Operator<?> root, Class<T> cls, Collection<T> result, Set<Operator<?>> seen) {
        if (seen.contains(root)) {
            return;
        }
        ArrayDeque deque = new ArrayDeque();
        deque.add(root);
        while (!deque.isEmpty()) {
            Operator op = (Operator)deque.remove();
            seen.add(op);
            if (cls.isInstance(op)) {
                result.add(op);
            }
            if (op.getChildOperators() == null) continue;
            for (Operator<OperatorDesc> child : op.getChildOperators()) {
                if (seen.contains(child)) continue;
                deque.add(child);
            }
        }
    }

    public static void removeEmptySparkTask(SparkTask currTask) {
        Object[] parTaskArr;
        ArrayList<Task<Serializable>> parTasks = new ArrayList<Task<Serializable>>();
        parTasks.addAll(currTask.getParentTasks());
        for (Object parTask : parTaskArr = parTasks.toArray()) {
            ((Task)parTask).removeDependentTask(currTask);
        }
        currTask.removeFromChildrenTasks();
    }

    public static SparkPartitionPruningSinkOperator findReusableDPPSink(Operator<? extends OperatorDesc> branchingOP, List<Operator<? extends OperatorDesc>> list) {
        for (Operator<OperatorDesc> other : branchingOP.getChildOperators()) {
            int i;
            for (i = 0; i < list.size() && other != list.get(i) && other.logicalEquals(list.get(i)); ++i) {
                if (i == list.size() - 1) continue;
                if (other.getChildOperators() == null || other.getChildOperators().size() != 1) break;
                other = other.getChildOperators().get(0);
            }
            if (i != list.size()) continue;
            return (SparkPartitionPruningSinkOperator)other;
        }
        return null;
    }

    public static void removeNestedDPP(OptimizeSparkProcContext procContext) {
        HashSet allDPPs = new HashSet();
        HashSet seen = new HashSet();
        for (TableScanOperator tableScanOperator : procContext.getParseContext().getTopOps().values()) {
            SparkUtilities.collectOp(tableScanOperator, SparkPartitionPruningSinkOperator.class, allDPPs, seen);
        }
        HashSet branchingOps = new HashSet();
        for (SparkPartitionPruningSinkOperator dpp : allDPPs) {
            branchingOps.add(dpp.getBranchingOp());
        }
        HashSet hashSet = new HashSet();
        for (Operator operator : branchingOps) {
            if (hashSet.contains(operator)) continue;
            hashSet.add(operator);
            seen.clear();
            HashSet nestedDPPs = new HashSet();
            for (Operator<OperatorDesc> branch : operator.getChildOperators()) {
                if (SparkUtilities.isDirectDPPBranch(branch)) continue;
                SparkUtilities.collectOp(branch, SparkPartitionPruningSinkOperator.class, nestedDPPs, seen);
            }
            for (SparkPartitionPruningSinkOperator nestedDPP : nestedDPPs) {
                hashSet.add(nestedDPP.getBranchingOp());
                if (nestedDPP.isWithMapjoin()) continue;
                OperatorUtils.removeBranch(nestedDPP);
            }
        }
    }

    public static boolean isDirectDPPBranch(Operator<?> op) {
        if (op instanceof SelectOperator && op.getChildOperators() != null && op.getChildOperators().size() == 1 && (op = op.getChildOperators().get(0)) instanceof GroupByOperator && op.getChildOperators() != null && op.getChildOperators().size() == 1) {
            op = op.getChildOperators().get(0);
            return op instanceof SparkPartitionPruningSinkOperator;
        }
        return false;
    }

    public static String reverseDNSLookupURL(String url) throws UnknownHostException {
        URI uri = URI.create(url);
        InetAddress address = InetAddress.getByName(uri.getHost());
        return uri.getScheme() + "://" + address.getCanonicalHostName() + ":" + uri.getPort();
    }
}

