/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.coordinator;

import hive.com.google.common.cache.Cache;
import hive.com.google.common.cache.CacheBuilder;
import hive.com.google.common.cache.RemovalListener;
import hive.com.google.common.cache.RemovalNotification;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.DaemonId;
import org.apache.hadoop.hive.llap.LlapUtil;
import org.apache.hadoop.hive.llap.security.LlapSigner;
import org.apache.hadoop.hive.llap.security.LlapSignerImpl;
import org.apache.hadoop.hive.llap.security.LlapTokenLocalClient;
import org.apache.hadoop.hive.llap.security.LlapTokenLocalClientImpl;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapCoordinator {
    private static final Logger LOG = LoggerFactory.getLogger(LlapCoordinator.class);
    private final Cache<String, LlapSigner> signers = CacheBuilder.newBuilder().removalListener(new RemovalListener<String, LlapSigner>(){

        @Override
        public void onRemoval(RemovalNotification<String, LlapSigner> notification) {
            if (notification.getValue() != null) {
                ((LlapSigner)notification.getValue()).close();
            }
        }
    }).expireAfterAccess(10L, TimeUnit.MINUTES).build();
    private static final Cache<String, LlapTokenLocalClient> localClientCache = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).removalListener(new RemovalListener<String, LlapTokenLocalClient>(){

        @Override
        public void onRemoval(RemovalNotification<String, LlapTokenLocalClient> notification) {
            if (notification.getValue() != null) {
                ((LlapTokenLocalClient)notification.getValue()).close();
            }
        }
    }).build();
    private HiveConf hiveConf;
    private String clusterUser;
    private long startTime;
    private final AtomicInteger appIdCounter = new AtomicInteger(0);
    private static final LlapCoordinator INSTANCE = new LlapCoordinator();

    LlapCoordinator() {
    }

    private void init(HiveConf hiveConf) throws IOException {
        this.hiveConf = hiveConf;
        this.clusterUser = UserGroupInformation.getCurrentUser().getShortUserName();
        long randomBits = (long)new Random().nextInt() << 32;
        this.startTime = Math.abs(System.currentTimeMillis() & Integer.MAX_VALUE | randomBits);
    }

    public LlapSigner getLlapSigner(Configuration jobConf) {
        assert (UserGroupInformation.isSecurityEnabled());
        final String clusterId = DaemonId.createClusterString(this.clusterUser, LlapUtil.generateClusterName(jobConf));
        try {
            return this.signers.get(clusterId, new Callable<LlapSigner>(){

                @Override
                public LlapSigner call() throws Exception {
                    return new LlapSignerImpl(LlapCoordinator.this.hiveConf, clusterId);
                }
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public ApplicationId createExtClientAppId() {
        return ApplicationId.newInstance((long)this.startTime, (int)this.appIdCounter.incrementAndGet());
    }

    public LlapTokenLocalClient getLocalTokenClient(Configuration conf, String clusterUser) throws IOException {
        assert (UserGroupInformation.isSecurityEnabled());
        String clusterName = LlapUtil.generateClusterName(conf);
        final String clusterId = DaemonId.createClusterString(clusterUser, clusterName);
        try {
            return localClientCache.get(clusterId, (Callable<LlapTokenLocalClient>)new Callable<LlapTokenLocalClientImpl>(){

                @Override
                public LlapTokenLocalClientImpl call() throws Exception {
                    return new LlapTokenLocalClientImpl(LlapCoordinator.this.hiveConf, clusterId);
                }
            });
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
    }

    public void close() {
        try {
            localClientCache.invalidateAll();
            this.signers.invalidateAll();
            localClientCache.cleanUp();
            this.signers.cleanUp();
        }
        catch (Exception ex) {
            LOG.error("Error closing the coordinator; ignoring", (Throwable)ex);
        }
    }

    public static void initializeInstance(HiveConf hiveConf) throws IOException {
        INSTANCE.init(hiveConf);
    }

    public static LlapCoordinator getInstance() {
        return INSTANCE;
    }
}

